/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.tileentity;

import a1lic.cubicvillager.event.RegistryHandler;
import a1lic.cubicvillager.inventory.container.TraderContainer;
import com.google.common.collect.LinkedHashMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.Sets;
import com.mojang.datafixers.types.Type;
import com.mojang.datafixers.types.constant.NilDrop;
import it.unimi.dsi.fastutil.ints.Int2ObjectMap;
import it.unimi.dsi.fastutil.ints.IntIterator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.merchant.villager.AbstractVillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerData;
import net.minecraft.entity.merchant.villager.VillagerEntity;
import net.minecraft.entity.merchant.villager.VillagerProfession;
import net.minecraft.entity.merchant.villager.VillagerTrades;
import net.minecraft.entity.merchant.villager.WanderingTraderEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.villager.IVillagerDataHolder;
import net.minecraft.entity.villager.IVillagerType;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.item.ItemStack;
import net.minecraft.item.MerchantOffer;
import net.minecraft.item.MerchantOffers;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.Direction;
import net.minecraft.util.NonNullList;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.registry.Registry;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraft.world.biome.Biome;
import net.minecraft.world.biome.Biomes;
import net.minecraft.world.server.ServerWorld;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public final class TraderTileEntity
extends TileEntity
implements ITickableTileEntity,
INamedContainerProvider,
ISidedInventory {
    private static final Logger LOG = LogManager.getLogger();
    private static final String REGNAME = "cubic_villager";
    private static final ResourceLocation RESLOC = new ResourceLocation("cubicvillager", "cubic_villager");
    private static final Set<Block> BLOCKS;
    public static final TileEntityType<TraderTileEntity> ENTRY;
    private static final Type<?> NILDROP;
    private static final ITextComponent GUI_TITLE;
    private static Map<VillagerProfession, Int2ObjectMap<VillagerTrades.ITrade[]>> TRADEABLE_PROFESSIONS;
    private final Random rand = new Random();
    private LazyOptional<IItemHandlerModifiable> capabilityHandler;
    private boolean oneshot = true;
    public boolean isRegularVillager = true;
    public int villagerExp;
    public int villagerLevel = 1;
    public VillagerProfession villagerProfession = VillagerProfession.field_221151_a;
    public IVillagerType villagerType = IVillagerType.field_221175_c;
    public MerchantOffers villagerOffers = new MerchantOffers();
    private int tradeIndex = -1;
    private ItemStack cachedOfferA;
    private ItemStack cachedOfferB;
    private ItemStack cachedSell;
    private boolean doubleOfferMode;
    private int tradeExp;
    private boolean doAddExp;
    private boolean noUpdateTrade;
    private final Inventory inv = new Inventory(11);
    private final Multimap<ItemStack, Integer> stackMap = LinkedHashMultimap.create((int)8, (int)16);
    private boolean invalidateStackMap;
    public final ItemHandler itemHandler = new ItemHandler();

    public static TraderTileEntity factory() {
        return new TraderTileEntity();
    }

    public TraderTileEntity() {
        super(ENTRY);
    }

    public TraderTileEntity(World world) {
        super(ENTRY);
        this.field_145850_b = world;
    }

    public TraderTileEntity(AbstractVillagerEntity villager) {
        super(ENTRY);
        this.field_145850_b = villager.field_70170_p;
        if (villager instanceof VillagerEntity) {
            this.isRegularVillager = true;
            VillagerData data = ((VillagerEntity)villager).func_213700_eh();
            this.villagerExp = villager.func_213708_dV();
            this.villagerLevel = data.func_221132_c();
            this.villagerProfession = data.func_221130_b();
            this.villagerType = data.func_221129_a();
        } else {
            this.isRegularVillager = false;
        }
        this.villagerOffers = villager.func_213706_dY();
        Inventory inv = villager.func_213715_ed();
        int invSize = inv.func_70302_i_();
        for (int i = 0; i < invSize; ++i) {
            ItemStack stack = inv.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            this.inv.func_70299_a(3 + i, stack);
        }
        this.resetOffers();
    }

    private void addExp() {
        if (!this.isRegularVillager || this.tradeExp == 0) {
            return;
        }
        this.doAddExp = true;
        int oldLevel = this.getVillagerLevelFromExp();
        int exp = this.villagerExp + 1;
        if (exp < this.villagerExp) {
            exp = Integer.MAX_VALUE;
        }
        this.setExp(exp);
        int newLevel = this.getVillagerLevelFromExp();
        if (newLevel > oldLevel) {
            this.noUpdateTrade = false;
            ++oldLevel;
            while (oldLevel <= newLevel) {
                this.villagerLevel = oldLevel++;
                this.populateTradeData();
            }
        } else {
            this.noUpdateTrade = true;
        }
        this.notifyUpdateToClient(false);
        this.noUpdateTrade = false;
        this.doAddExp = false;
    }

    public void clearTrade() {
        this.setTradeIndex(-1);
    }

    private void createTradeableProfessions() {
        if (TRADEABLE_PROFESSIONS != null) {
            return;
        }
        TRADEABLE_PROFESSIONS = new HashMap<VillagerProfession, Int2ObjectMap<VillagerTrades.ITrade[]>>();
        for (VillagerProfession prof : ForgeRegistries.PROFESSIONS.getValues()) {
            Int2ObjectMap map = (Int2ObjectMap)VillagerTrades.field_221239_a.get(prof);
            if (map == null) continue;
            int professionTrades = 0;
            IntIterator intIterator = map.keySet().iterator();
            while (intIterator.hasNext()) {
                int key = (Integer)intIterator.next();
                VillagerTrades.ITrade[] trades = (VillagerTrades.ITrade[])map.get(key);
                if (trades == null || trades.length == 0) continue;
                professionTrades += trades.length;
            }
            if (professionTrades <= 0) continue;
            TRADEABLE_PROFESSIONS.put(prof, (Int2ObjectMap<VillagerTrades.ITrade[]>)map);
        }
        LOG.info("Profession to have trades... {}", (Object)TRADEABLE_PROFESSIONS.keySet().toString());
    }

    public AbstractVillagerEntity createVillagerEntity(int yOffset) {
        assert (this.field_145850_b != null);
        Object entity = this.isRegularVillager ? new VillagerEntity(EntityType.field_200756_av, this.field_145850_b) : new WanderingTraderEntity(EntityType.field_220351_aK, this.field_145850_b);
        double x = (double)this.field_174879_c.func_177958_n() + 0.5;
        double y = (double)this.field_174879_c.func_177956_o() + 0.5 + (double)yOffset;
        double z = (double)this.field_174879_c.func_177952_p() + 0.5;
        entity.func_70107_b(x, y, z);
        if (this.isRegularVillager) {
            assert (entity instanceof VillagerEntity);
            VillagerData data = new VillagerData(this.villagerType, this.villagerProfession, this.getVillagerLevelFromExp());
            entity.func_213753_a(data);
            if (this.villagerExp <= 0) {
                this.villagerExp = 1;
            }
            entity.func_213761_t(this.villagerExp);
            entity.func_213768_b(this.villagerOffers);
        } else {
            MerchantOffers offers = entity.func_213706_dY();
            offers.clear();
            offers.addAll((Collection)this.villagerOffers);
        }
        Inventory inventory = entity.func_213715_ed();
        for (int i = 3; i < 11; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (stack.func_190926_b()) continue;
            inventory.func_70299_a(i - 3, stack);
        }
        return entity;
    }

    private void doDoubleOffer() {
        int sellMax;
        int decr;
        int current;
        ItemStack stack;
        Collection slotsA = this.stackMap.get((Object)this.cachedOfferA);
        Collection slotsB = this.stackMap.get((Object)this.cachedOfferB);
        if (slotsA.isEmpty() && slotsB.isEmpty()) {
            return;
        }
        int consumeA = this.cachedOfferA.func_190916_E();
        int consumeB = this.cachedOfferB.func_190916_E();
        ArrayList<Integer> pendingToRemove = new ArrayList<Integer>();
        ItemStack sellStack = this.func_70301_a(2);
        boolean metA = false;
        boolean metB = false;
        int decrSlotA = -1;
        int decrSlotB = -1;
        for (Integer index : slotsA) {
            stack = this.func_70301_a(index);
            current = stack.func_190916_E();
            if (current <= consumeA) {
                pendingToRemove.add(index);
            }
            if ((decr = consumeA - current) <= 0) {
                metA = true;
                if (decr >= 0) break;
                decrSlotA = index;
                break;
            }
            consumeA = decr;
        }
        for (Integer index : slotsB) {
            stack = this.func_70301_a(index);
            current = stack.func_190916_E();
            if (current <= consumeB) {
                pendingToRemove.add(index);
            }
            if ((decr = consumeB - current) <= 0) {
                metB = true;
                if (decr >= 0) break;
                decrSlotB = index;
                break;
            }
            consumeB = decr;
        }
        if (!metA || !metB) {
            return;
        }
        if (!this.isPuttableInSellSlot()) {
            return;
        }
        int sellCur = sellStack.func_190916_E() + this.cachedSell.func_190916_E();
        if (sellCur > (sellMax = sellStack.func_77976_d())) {
            return;
        }
        for (Integer rIndex : pendingToRemove) {
            this.func_70304_b(rIndex);
        }
        if (consumeA > 0) {
            this.func_70298_a(decrSlotA, consumeA);
        }
        if (consumeB > 0) {
            this.func_70298_a(decrSlotB, consumeB);
        }
        if (sellStack.func_190926_b()) {
            sellStack = this.cachedSell.func_77946_l();
            this.func_70299_a(2, sellStack);
        } else {
            sellStack.func_190920_e(sellCur);
        }
        this.addExp();
        this.func_70296_d();
    }

    private void doSingleOffer() {
        int sellMax;
        Collection slotsA = this.stackMap.get((Object)this.cachedOfferA);
        if (slotsA.isEmpty()) {
            return;
        }
        int consumeA = this.cachedOfferA.func_190916_E();
        ArrayList<Integer> pendingToRemove = new ArrayList<Integer>();
        ItemStack sellStack = this.func_70301_a(2);
        boolean metA = false;
        int decrSlotA = -1;
        for (Integer index : slotsA) {
            int decr;
            ItemStack stack = this.func_70301_a(index);
            int current = stack.func_190916_E();
            if (current <= consumeA) {
                pendingToRemove.add(index);
            }
            if ((decr = consumeA - current) <= 0) {
                metA = true;
                if (decr >= 0) break;
                decrSlotA = index;
                break;
            }
            consumeA = decr;
        }
        if (!metA) {
            return;
        }
        if (!this.isPuttableInSellSlot()) {
            return;
        }
        int sellCur = sellStack.func_190916_E() + this.cachedSell.func_190916_E();
        if (sellCur > (sellMax = sellStack.func_77976_d())) {
            return;
        }
        for (Integer rIndex : pendingToRemove) {
            this.func_70304_b(rIndex);
        }
        if (consumeA > 0) {
            this.func_70298_a(decrSlotA, consumeA);
        }
        if (sellStack.func_190926_b()) {
            sellStack = this.cachedSell.func_77946_l();
            this.func_70299_a(2, sellStack);
        } else {
            sellStack.func_190920_e(sellCur);
        }
        this.addExp();
        this.func_70296_d();
    }

    public int getExp() {
        return this.villagerExp;
    }

    private IItemHandlerModifiable getItemHandler() {
        return this.itemHandler;
    }

    public MerchantOffer getCurrentOffer() {
        int countOffers = this.villagerOffers.size();
        if (this.tradeIndex < 0 || this.tradeIndex >= countOffers) {
            return null;
        }
        return (MerchantOffer)this.villagerOffers.get(this.tradeIndex);
    }

    public int getTradeIndex() {
        return this.tradeIndex;
    }

    public IInventory getTradeInventory() {
        return this.inv;
    }

    public int getVillagerLeftToNextLevel() {
        if (!this.isRegularVillager) {
            return 0;
        }
        int nextBase = this.villagerExp < 10 ? 10 : (this.villagerExp < 70 ? 70 : (this.villagerExp < 150 ? 150 : (this.villagerExp < 250 ? 250 : 0)));
        if (nextBase == 0) {
            return 0;
        }
        return nextBase - this.villagerExp;
    }

    public int getVillagerLevelFromExp() {
        if (!this.isRegularVillager) {
            return 0;
        }
        int level = 1;
        if (this.villagerExp >= 10) {
            ++level;
        }
        if (this.villagerExp >= 70) {
            ++level;
        }
        if (this.villagerExp >= 150) {
            ++level;
        }
        if (this.villagerExp >= 250) {
            ++level;
        }
        this.villagerLevel = level;
        return level;
    }

    private static boolean isItemStackAppreciate(ItemStack check, ItemStack offered) {
        CompoundNBT tagOffered;
        CompoundNBT tagCheck = check.func_190926_b() ? null : check.func_77978_p();
        CompoundNBT compoundNBT = tagOffered = offered.func_190926_b() ? null : offered.func_77978_p();
        if (!offered.func_185136_b(check)) {
            return false;
        }
        if (tagCheck == null && tagOffered == null) {
            return true;
        }
        if (tagCheck == null || tagOffered == null) {
            return false;
        }
        return tagOffered.equals((Object)tagCheck);
    }

    private boolean isPuttableInSellSlot() {
        ItemStack sellStack = this.func_70301_a(2);
        if (sellStack.func_190926_b()) {
            return true;
        }
        if (!ItemStack.func_179545_c((ItemStack)sellStack, (ItemStack)this.cachedSell)) {
            return false;
        }
        if (!sellStack.func_77985_e()) {
            return false;
        }
        return ItemStack.func_77970_a((ItemStack)sellStack, (ItemStack)this.cachedSell);
    }

    private boolean isValidProfession() {
        if (!this.isRegularVillager) {
            return true;
        }
        if (this.villagerProfession == null) {
            return false;
        }
        return TRADEABLE_PROFESSIONS.containsKey(this.villagerProfession);
    }

    private void initializeServerSideVillager() {
        Set<VillagerProfession> profs = TRADEABLE_PROFESSIONS.keySet();
        if (this.isValidProfession()) {
            return;
        }
        if (this.isRegularVillager) {
            Biome biome;
            try {
                assert (this.field_145850_b != null);
                biome = this.field_145850_b.func_226691_t_(this.func_174877_v());
            }
            catch (NullPointerException e) {
                biome = Biomes.field_76772_c;
            }
            this.villagerType = IVillagerType.func_221170_a((Biome)biome);
            int randomIndex = (int)((double)profs.size() * Math.random());
            Iterator<VillagerProfession> iterator = profs.iterator();
            while (iterator.hasNext()) {
                VillagerProfession _prof;
                this.villagerProfession = _prof = iterator.next();
                if (randomIndex-- != 0) continue;
                break;
            }
        }
        this.villagerOffers.clear();
        if (!this.isRegularVillager) {
            this.populateTradeData();
        } else {
            int currentLevel = this.villagerLevel;
            this.villagerLevel = 1;
            while (this.villagerLevel <= currentLevel) {
                this.populateTradeData();
                ++this.villagerLevel;
            }
            this.villagerLevel = currentLevel;
        }
    }

    public void notifyUpdateToClient(boolean force) {
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        List players = ((ServerWorld)this.field_145850_b).func_217369_A();
        SUpdateTileEntityPacket packet = this.func_189518_D_();
        for (ServerPlayerEntity player : players) {
            if (!force && !(player.field_71070_bA instanceof TraderContainer)) continue;
            player.field_71135_a.func_147359_a((IPacket)packet);
        }
    }

    public void oneshot() {
        if (!this.oneshot || this.field_145850_b == null) {
            return;
        }
        this.oneshot = false;
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        this.initializeServerSideVillager();
        this.notifyUpdateToClient(true);
    }

    private void populateTradeData() {
        Int2ObjectMap tradeList = this.isRegularVillager ? (Int2ObjectMap)VillagerTrades.field_221239_a.get(this.villagerProfession) : VillagerTrades.field_221240_b;
        if (tradeList == null || tradeList.isEmpty()) {
            return;
        }
        if (this.isRegularVillager) {
            VillagerTrades.ITrade[] tradeOfLevel = (VillagerTrades.ITrade[])tradeList.get(this.villagerLevel);
            if (tradeOfLevel != null && tradeOfLevel.length > 0) {
                this.populateTradeEntries(tradeOfLevel, 2);
            }
        } else {
            VillagerTrades.ITrade[] trades = (VillagerTrades.ITrade[])tradeList.get(1);
            if (trades != null && trades.length > 0) {
                this.populateTradeEntries(trades, 5);
            }
            trades = (VillagerTrades.ITrade[])tradeList.get(2);
            this.populateTradeEntries(trades, 1);
        }
    }

    private void populateTradeEntries(VillagerTrades.ITrade[] adds, int addCount) {
        int i;
        HashSet set = Sets.newHashSet();
        if (adds.length > addCount) {
            for (i = 0; i < addCount; ++i) {
                set.add(this.rand.nextInt(adds.length));
            }
        } else {
            for (i = 0; i < adds.length; ++i) {
                set.add(i);
            }
        }
        VillagerDataEntity dummy = new VillagerDataEntity(this.field_145850_b);
        for (Integer integer : set) {
            VillagerTrades.ITrade trade = adds[integer];
            MerchantOffer merchantoffer = trade.func_221182_a((Entity)dummy, this.rand);
            if (merchantoffer == null) continue;
            this.villagerOffers.add((Object)merchantoffer);
        }
    }

    private void rebuildBuyableItemStackMap() {
        if (!this.invalidateStackMap) {
            return;
        }
        this.invalidateStackMap = false;
        this.stackMap.clear();
        if (this.cachedOfferA == null) {
            return;
        }
        for (int i = 0; i < 11; ++i) {
            ItemStack stack;
            if (i == 2 || (stack = this.func_70301_a(i)).func_190926_b()) continue;
            if (TraderTileEntity.isItemStackAppreciate(stack, this.cachedOfferA)) {
                this.stackMap.put((Object)this.cachedOfferA, (Object)i);
                continue;
            }
            if (!TraderTileEntity.isItemStackAppreciate(stack, this.cachedOfferB)) continue;
            this.stackMap.put((Object)this.cachedOfferB, (Object)i);
        }
    }

    public void readMetadatas(CompoundNBT compound) {
        this.isRegularVillager = compound.func_74764_b("Rglr") ? compound.func_74767_n("Rglr") : true;
        if (this.isRegularVillager) {
            String _type = compound.func_74779_i("Type");
            this.villagerType = (IVillagerType)Registry.field_218369_K.func_82594_a(new ResourceLocation(_type));
            String _prof = compound.func_74779_i("Prof");
            this.villagerProfession = (VillagerProfession)ForgeRegistries.PROFESSIONS.getValue(new ResourceLocation(_prof));
            if (this.villagerProfession == null) {
                this.villagerProfession = VillagerProfession.field_221151_a;
            }
            this.villagerExp = compound.func_74762_e("Exp");
            this.villagerLevel = this.getVillagerLevelFromExp();
        } else {
            this.villagerType = null;
            this.villagerProfession = null;
            this.villagerExp = 1;
            this.villagerLevel = 0;
        }
        CompoundNBT _offers = compound.func_74775_l("Ofer");
        this.villagerOffers = new MerchantOffers(_offers);
        if (compound.func_74764_b("Items")) {
            NonNullList list = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
            ItemStackHelper.func_191283_b((CompoundNBT)compound, (NonNullList)list);
            for (int i = 0; i < 11; ++i) {
                ItemStack item = (ItemStack)list.get(i);
                this.inv.func_70299_a(i, item);
            }
        }
        this.tradeIndex = -1;
        this.setTradeIndex(compound.func_74765_d("Sel"));
    }

    private void resetOffers() {
        MerchantOffers offers = new MerchantOffers();
        for (MerchantOffer offer : this.villagerOffers) {
            offers.add((Object)new MerchantOffer(offer.func_222218_a(), offer.func_222202_c(), offer.func_222200_d(), 0, offer.func_222214_i(), offer.func_222210_n(), offer.func_222211_m(), offer.func_225482_k()));
        }
        this.villagerOffers = offers;
    }

    public void setExp(int xpIn) {
        this.villagerExp = xpIn;
        if (!this.doAddExp) {
            this.notifyUpdateToClient(false);
        }
    }

    public void setTradeIndex(int newIndex) {
        if (newIndex < -1) {
            newIndex = -1;
        }
        if (this.tradeIndex == newIndex) {
            return;
        }
        this.tradeIndex = newIndex;
        if (this.field_145850_b instanceof ServerWorld) {
            this.updateOfferCache();
            this.invalidateStackMap = true;
            this.rebuildBuyableItemStackMap();
        }
    }

    private void updateCheckSlotsMap(int checkIndex) {
        if (checkIndex == 2) {
            return;
        }
        ItemStack stack = this.func_70301_a(checkIndex);
        LinkedHashMultimap queue = LinkedHashMultimap.create();
        for (Map.Entry entry : this.stackMap.entries()) {
            ItemStack offer;
            if ((Integer)entry.getValue() != checkIndex || TraderTileEntity.isItemStackAppreciate(stack, offer = (ItemStack)entry.getKey())) continue;
            queue.put(entry.getKey(), entry.getValue());
        }
        for (Map.Entry entry : queue.entries()) {
            this.stackMap.remove(entry.getKey(), entry.getValue());
        }
        MerchantOffer offer = this.getCurrentOffer();
        if (offer == null) {
            return;
        }
        ItemStack offerStackA = offer.func_222218_a();
        ItemStack offerStackB = offer.func_222202_c();
        if (TraderTileEntity.isItemStackAppreciate(stack, offerStackA)) {
            this.stackMap.put((Object)offerStackA, (Object)checkIndex);
        }
        if (TraderTileEntity.isItemStackAppreciate(stack, offerStackB)) {
            this.stackMap.put((Object)offerStackB, (Object)checkIndex);
        }
    }

    private void updateOfferCache() {
        boolean hasBuyStackB;
        MerchantOffer offer = this.getCurrentOffer();
        if (offer == null) {
            this.cachedOfferA = null;
            this.cachedOfferB = null;
            this.cachedSell = null;
            this.tradeExp = 0;
            return;
        }
        this.cachedOfferA = offer.func_222218_a();
        this.cachedOfferB = offer.func_222202_c();
        this.cachedSell = offer.func_222200_d();
        this.tradeExp = offer.func_222221_q() ? offer.func_222210_n() : 1;
        boolean hasBuyStackA = !this.cachedOfferA.func_190926_b();
        boolean bl = hasBuyStackB = !this.cachedOfferB.func_190926_b();
        if (!hasBuyStackA && !hasBuyStackB) {
            return;
        }
        if (hasBuyStackB && !hasBuyStackA) {
            this.cachedOfferA = this.cachedOfferB;
            this.cachedOfferB = ItemStack.field_190927_a;
        }
        if (hasBuyStackB) {
            int bCount = this.cachedOfferB.func_190916_E();
            this.cachedOfferB.func_190920_e(this.cachedOfferA.func_190916_E());
            boolean eq = ItemStack.func_77989_b((ItemStack)this.cachedOfferA, (ItemStack)this.cachedOfferB);
            this.cachedOfferB.func_190920_e(bCount);
            if (eq) {
                this.cachedOfferA = this.cachedOfferA.func_77946_l();
                this.cachedOfferA.func_190917_f(this.cachedOfferB.func_190916_E());
                this.cachedOfferB = ItemStack.field_190927_a;
                this.doubleOfferMode = false;
            } else {
                this.doubleOfferMode = true;
            }
        } else {
            this.doubleOfferMode = false;
        }
    }

    public void writeMetadatas(CompoundNBT compound, boolean withItemstacks) {
        compound.func_74757_a("Rglr", this.isRegularVillager);
        if (this.isRegularVillager) {
            ResourceLocation type = Registry.field_218369_K.func_177774_c((Object)this.villagerType);
            ResourceLocation prof = this.villagerProfession.getRegistryName();
            assert (prof != null);
            compound.func_74778_a("Type", type.toString());
            compound.func_74778_a("Prof", prof.toString());
            compound.func_74768_a("Exp", this.villagerExp);
        }
        compound.func_218657_a("Ofer", (INBT)this.villagerOffers.func_222199_a());
        compound.func_74777_a("Sel", (short)this.tradeIndex);
        if (withItemstacks) {
            NonNullList list = NonNullList.func_191197_a((int)11, (Object)ItemStack.field_190927_a);
            for (int i = 0; i < 11; ++i) {
                ItemStack item = this.inv.func_70301_a(i);
                list.set(i, (Object)item);
            }
            ItemStackHelper.func_191282_a((CompoundNBT)compound, (NonNullList)list);
        }
    }

    public SUpdateTileEntityPacket func_189518_D_() {
        int type = this.noUpdateTrade ? 2 : 1;
        return new SUpdateTileEntityPacket(this.field_174879_c, type, this.func_189517_E_());
    }

    public CompoundNBT func_189517_E_() {
        CompoundNBT compound = super.func_189517_E_();
        if (this.noUpdateTrade) {
            compound.func_74768_a("Exp", this.villagerExp);
        } else {
            this.writeMetadatas(compound, false);
        }
        return compound;
    }

    public void func_145839_a(CompoundNBT compound) {
        super.func_145839_a(compound);
        this.readMetadatas(compound);
    }

    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        this.writeMetadatas(compound, true);
        return compound;
    }

    public <T> LazyOptional<T> getCapability(Capability<T> cap, Direction side) {
        if (cap != CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return super.getCapability(cap, side);
        }
        if (this.capabilityHandler == null) {
            this.capabilityHandler = LazyOptional.of(this::getItemHandler);
        }
        return this.capabilityHandler.cast();
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        int type = pkt.func_148853_f();
        if (type != 1 && type != 2) {
            return;
        }
        if (type == 1) {
            this.readMetadatas(pkt.func_148857_g());
            this.oneshot = true;
        } else {
            CompoundNBT tag = pkt.func_148857_g();
            this.setExp(tag.func_74762_e("Exp"));
        }
    }

    public void func_73660_a() {
        int needTicks;
        this.createTradeableProfessions();
        this.oneshot();
        if (!(this.field_145850_b instanceof ServerWorld)) {
            return;
        }
        if (this.tradeIndex < 0) {
            return;
        }
        if (this.cachedOfferA == null) {
            this.updateOfferCache();
            if (this.cachedOfferA == null) {
                return;
            }
        }
        this.rebuildBuyableItemStackMap();
        if (this.isRegularVillager) {
            int level = this.getVillagerLevelFromExp();
            switch (level) {
                case 1: {
                    needTicks = 40;
                    break;
                }
                case 2: {
                    needTicks = 20;
                    break;
                }
                case 3: {
                    needTicks = 10;
                    break;
                }
                case 4: {
                    needTicks = 5;
                    break;
                }
                default: {
                    needTicks = 1;
                    break;
                }
            }
        } else {
            needTicks = 5;
        }
        if (this.field_145850_b.func_82737_E() % (long)needTicks != 0L) {
            return;
        }
        if (this.doubleOfferMode) {
            this.doDoubleOffer();
        } else {
            this.doSingleOffer();
        }
    }

    public ITextComponent func_145748_c_() {
        return GUI_TITLE;
    }

    public Container createMenu(int windowId, PlayerInventory inventory, PlayerEntity player) {
        return new TraderContainer(windowId, inventory, this);
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, Direction direction) {
        return index != 2;
    }

    public boolean func_180461_b(int index, ItemStack stack, Direction direction) {
        return index == 2;
    }

    public int[] func_180463_a(Direction side) {
        int[] faces = new int[11];
        for (int i = 0; i < 11; ++i) {
            faces[i] = i;
        }
        return faces;
    }

    public void func_174888_l() {
        this.inv.func_174888_l();
        this.stackMap.clear();
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = this.inv.func_70301_a(index);
        if (stack.func_190926_b()) {
            return stack;
        }
        int currentCountStack = stack.func_190916_E();
        ItemStack diviedStack = this.inv.func_70298_a(index, count);
        if (currentCountStack <= count) {
            this.updateCheckSlotsMap(index);
        }
        return diviedStack;
    }

    public int func_70302_i_() {
        return 11;
    }

    public ItemStack func_70301_a(int index) {
        return this.inv.func_70301_a(index);
    }

    public boolean func_191420_l() {
        return this.inv.func_191420_l();
    }

    public boolean func_70300_a(PlayerEntity player) {
        return true;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = this.inv.func_70304_b(index);
        if (!stack.func_190926_b()) {
            this.updateCheckSlotsMap(index);
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inv.func_70299_a(index, stack);
        this.updateCheckSlotsMap(index);
    }

    static {
        NILDROP = new NilDrop();
        GUI_TITLE = new TranslationTextComponent("container.cubicvillager.trader", new Object[0]);
        BLOCKS = new HashSet<Block>();
        BLOCKS.add(RegistryHandler.blockTrader);
        ENTRY = new TileEntityType(TraderTileEntity::factory, BLOCKS, NILDROP);
        ENTRY.setRegistryName(RESLOC);
    }

    private class VillagerDataEntity
    extends Entity
    implements IVillagerDataHolder {
        public VillagerDataEntity(World world) {
            super(EntityType.field_200756_av, world);
        }

        public IPacket<?> func_213297_N() {
            return null;
        }

        public VillagerData func_213700_eh() {
            return new VillagerData(TraderTileEntity.this.villagerType, TraderTileEntity.this.villagerProfession, TraderTileEntity.this.villagerLevel);
        }

        protected void func_70037_a(CompoundNBT compound) {
        }

        protected void func_70088_a() {
        }

        protected void func_213281_b(CompoundNBT compound) {
        }
    }

    private class ItemHandler
    implements IItemHandlerModifiable {
        private ItemHandler() {
        }

        public int getSlots() {
            return 11;
        }

        public ItemStack getStackInSlot(int slot) {
            return TraderTileEntity.this.func_70301_a(slot);
        }

        public ItemStack insertItem(int slot, ItemStack stack, boolean simulate) {
            ItemStack result;
            if (slot == 2) {
                return stack;
            }
            ItemStack currentStack = this.getStackInSlot(slot);
            if (currentStack.func_190926_b()) {
                result = ItemStack.field_190927_a;
                if (!simulate) {
                    TraderTileEntity.this.func_70299_a(slot, stack);
                }
            } else {
                int stackCount = stack.func_190916_E();
                stack.func_190920_e(currentStack.func_190916_E());
                boolean eq = ItemStack.func_77989_b((ItemStack)currentStack, (ItemStack)stack);
                stack.func_190920_e(stackCount);
                if (!eq) {
                    result = stack;
                } else {
                    int maxCount = currentStack.func_77976_d();
                    int newCount = currentStack.func_190916_E() + stack.func_190916_E();
                    if (newCount <= maxCount) {
                        result = ItemStack.field_190927_a;
                    } else {
                        result = stack.func_77946_l();
                        result.func_190920_e(newCount - maxCount);
                        newCount = maxCount;
                    }
                    if (!simulate) {
                        currentStack.func_190920_e(newCount);
                    }
                }
            }
            return result;
        }

        public ItemStack extractItem(int slot, int amount, boolean simulate) {
            ItemStack result;
            int count;
            if (slot != 2 || amount <= 0) {
                return ItemStack.field_190927_a;
            }
            ItemStack ext = this.getStackInSlot(slot);
            if (ext.func_190926_b()) {
                return ItemStack.field_190927_a;
            }
            int maxCount = ext.func_77976_d();
            if (amount > maxCount) {
                amount = maxCount;
            }
            if (amount > (count = ext.func_190916_E())) {
                amount = count;
            }
            int newCount = count - amount;
            if (!simulate) {
                result = ext.func_77946_l();
                result.func_190920_e(amount);
                if (newCount > 0) {
                    ext.func_190920_e(newCount);
                } else {
                    TraderTileEntity.this.func_70304_b(slot);
                }
            } else {
                result = ext.func_77946_l();
                if (newCount > 0) {
                    result.func_190920_e(amount);
                }
            }
            return result;
        }

        public int getSlotLimit(int slot) {
            return 64;
        }

        public boolean isItemValid(int slot, ItemStack stack) {
            return slot != 2;
        }

        public void setStackInSlot(int slot, ItemStack stack) {
            TraderTileEntity.this.func_70299_a(slot, stack);
        }
    }
}

