/*
 * Decompiled with CFR 0.152.
 */
package a1lic.cubicvillager.tool.reflect;

import java.lang.reflect.Field;
import java.util.function.BiConsumer;
import java.util.function.Function;
import org.apache.logging.log4j.Level;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public abstract class AbstractField<R> {
    protected static final Logger LOG;
    public static final Field Field_modifiers;
    protected final Field field;
    protected final boolean wasFinal;
    protected Function<Object, R> delegatedGetter;
    protected BiConsumer<Object, R> delegatedSetter;

    public AbstractField(Class<?> target, String[] names) {
        if (target == null || names == null || names.length == 0) {
            throw new AssertionError((Object)"target==null or names==null");
        }
        Field f = null;
        for (String name : names) {
            try {
                f = target.getDeclaredField(name);
                f.setAccessible(true);
                break;
            }
            catch (NoSuchFieldException e) {
                LOG.catching(Level.DEBUG, (Throwable)e);
            }
        }
        this.field = f;
        if (this.field != null) {
            this.wasFinal = AbstractField.setFinalFlag(this.field, false);
            if (this.wasFinal) {
                AbstractField.setFinalFlag(this.field, true);
            }
        } else {
            this.wasFinal = false;
        }
    }

    public static boolean setFinalFlag(Field field, boolean beFinal) {
        boolean ok;
        try {
            int newMod;
            int mod = Field_modifiers.getInt(field);
            int n = newMod = beFinal ? 16 : 0;
            if ((mod & 0x10) != newMod) {
                Field_modifiers.setInt(field, mod ^ 0x10);
                ok = true;
            } else {
                ok = false;
            }
        }
        catch (IllegalAccessException | IllegalArgumentException e) {
            ok = false;
        }
        return ok;
    }

    public final boolean hasField() {
        return this.field != null;
    }

    public final R get(Object instance) {
        return this.delegatedGetter.apply(instance);
    }

    public final void set(Object instance, R value) {
        if (this.wasFinal) {
            AbstractField.setFinalFlag(this.field, false);
        }
        this.delegatedSetter.accept(instance, value);
        if (this.wasFinal) {
            AbstractField.setFinalFlag(this.field, true);
        }
    }

    static {
        Field f;
        LOG = LogManager.getLogger();
        try {
            f = Field.class.getDeclaredField("modifiers");
            f.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new NoSuchFieldError("'modifiers' not found on 'Field' class. May different VM implementation?");
        }
        Field_modifiers = f;
    }
}

