/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.item;

import com.google.common.collect.HashBasedTable;
import com.google.common.collect.Table;
import net.minecraft.block.Block;
import net.minecraft.init.Blocks;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class ItemStackRegistry {
    private static Table<String, String, ItemStack> stackRegistry = HashBasedTable.create();

    public static void registerCustomItemStack(String name, ItemStack stack) {
        stackRegistry.put((Object)Loader.instance().activeModContainer().getModId(), (Object)name, (Object)stack);
    }

    public static ItemStack findItemStack(String modId, String name, int stackSize) {
        ItemStack foundStack = ItemStackRegistry.findItemStack(modId, name);
        if (foundStack != null) {
            ItemStack copy = foundStack.func_77946_l();
            copy.field_77994_a = Math.min(stackSize, copy.func_77976_d());
            return copy;
        }
        return null;
    }

    public static ItemStack findItemStack(String modId, String name) {
        Block block;
        Item item;
        ItemStack stack = (ItemStack)stackRegistry.get((Object)modId, (Object)name);
        if (stack == null && (item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(modId, name))) != null) {
            stack = new ItemStack(item, 0, 0);
        }
        if (stack == null && (block = (Block)ForgeRegistries.BLOCKS.getValue(new ResourceLocation(modId, name))) != null && block != Blocks.field_150350_a) {
            stack = new ItemStack(block, 0, Short.MAX_VALUE);
        }
        return stack;
    }
}

