/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.raytracer;

import codechicken.lib.raytracer.CuboidRayTraceResult;
import codechicken.lib.raytracer.IndexedCuboid6;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vector3;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class RayTracer {
    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, List<IndexedCuboid6> cuboids, BlockPos pos) {
        return RayTracer.rayTraceCuboidsClosest(new Vector3(start), new Vector3(end), cuboids, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, List<IndexedCuboid6> cuboids, BlockPos pos) {
        ArrayList<CuboidRayTraceResult> results = new ArrayList<CuboidRayTraceResult>();
        for (IndexedCuboid6 cuboid6 : cuboids) {
            CuboidRayTraceResult hit = RayTracer.rayTrace(pos, start, end, cuboid6);
            results.add(hit);
        }
        CuboidRayTraceResult closestHit = null;
        double curClosest = Double.MAX_VALUE;
        for (CuboidRayTraceResult hit : results) {
            if (hit == null || !(curClosest > hit.dist)) continue;
            closestHit = hit;
            curClosest = hit.dist;
        }
        return closestHit;
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, AxisAlignedBB ... boxes) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (boxes != null) {
            for (AxisAlignedBB box : boxes) {
                cuboidList.add(new IndexedCuboid6((Object)0, box));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, cuboidList, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, AxisAlignedBB ... boxes) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (boxes != null) {
            for (AxisAlignedBB box : boxes) {
                cuboidList.add(new IndexedCuboid6((Object)0, box));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, cuboidList, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, Cuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            for (Cuboid6 cuboid : cuboids) {
                cuboidList.add(new IndexedCuboid6((Object)0, cuboid));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, cuboidList, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, Cuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            for (Cuboid6 cuboid : cuboids) {
                cuboidList.add(new IndexedCuboid6((Object)0, cuboid));
            }
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, cuboidList, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vector3 start, Vector3 end, BlockPos pos, IndexedCuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            Collections.addAll(cuboidList, cuboids);
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, cuboidList, pos);
    }

    public static CuboidRayTraceResult rayTraceCuboidsClosest(Vec3d start, Vec3d end, BlockPos pos, IndexedCuboid6 ... cuboids) {
        LinkedList<IndexedCuboid6> cuboidList = new LinkedList<IndexedCuboid6>();
        if (cuboids != null) {
            Collections.addAll(cuboidList, cuboids);
        }
        return RayTracer.rayTraceCuboidsClosest(start, end, cuboidList, pos);
    }

    public static CuboidRayTraceResult rayTrace(BlockPos pos, Vector3 start, Vector3 end, IndexedCuboid6 cuboid) {
        Vector3 startRay = start.copy().subtract(pos);
        Vector3 endRay = end.copy().subtract(pos);
        RayTraceResult bbResult = cuboid.aabb().func_72327_a(startRay.vec3(), endRay.vec3());
        if (bbResult != null) {
            Vector3 hitVec = new Vector3(bbResult.field_72307_f).add(pos);
            EnumFacing sideHit = bbResult.field_178784_b;
            double dist = hitVec.copy().subtract(start).magSquared();
            return new CuboidRayTraceResult(hitVec, pos, sideHit, cuboid, dist);
        }
        return null;
    }

    public static RayTraceResult retraceBlock(World world, EntityPlayer player, BlockPos pos) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        return world.func_180495_p(pos).func_185910_a(world, pos, startVec, endVec);
    }

    private static double getBlockReachDistance_server(EntityPlayerMP player) {
        return player.field_71134_c.getBlockReachDistance();
    }

    @SideOnly(value=Side.CLIENT)
    private static double getBlockReachDistance_client() {
        return Minecraft.func_71410_x().field_71442_b.func_78757_d();
    }

    public static RayTraceResult retrace(EntityPlayer player) {
        return RayTracer.retrace(player, RayTracer.getBlockReachDistance(player));
    }

    public static RayTraceResult retrace(EntityPlayer player, boolean stopOnFluid) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player);
        return player.field_70170_p.func_147447_a(startVec, endVec, stopOnFluid, false, true);
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach, boolean stopOnFluids) {
        Vec3d startVec = RayTracer.getStartVec(player);
        Vec3d endVec = RayTracer.getEndVec(player, reach);
        return player.field_70170_p.func_147447_a(startVec, endVec, stopOnFluids, false, true);
    }

    public static RayTraceResult retrace(EntityPlayer player, double reach) {
        return RayTracer.retrace(player, reach, true);
    }

    public static Vec3d getCorrectedHeadVec(EntityPlayer player) {
        Vector3 v = Vector3.fromEntity((Entity)player).add(0.0, player.func_70047_e(), 0.0);
        return v.vec3();
    }

    public static Vec3d getStartVec(EntityPlayer player) {
        return RayTracer.getCorrectedHeadVec(player);
    }

    public static double getBlockReachDistance(EntityPlayer player) {
        return player.field_70170_p.field_72995_K ? RayTracer.getBlockReachDistance_client() : (player instanceof EntityPlayerMP ? RayTracer.getBlockReachDistance_server((EntityPlayerMP)player) : 5.0);
    }

    public static Vec3d getEndVec(EntityPlayer player) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        double reach = RayTracer.getBlockReachDistance(player);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }

    public static Vec3d getEndVec(EntityPlayer player, double reach) {
        Vec3d headVec = RayTracer.getCorrectedHeadVec(player);
        Vec3d lookVec = player.func_70676_i(1.0f);
        return headVec.func_72441_c(lookVec.field_72450_a * reach, lookVec.field_72448_b * reach, lookVec.field_72449_c * reach);
    }
}

