/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.shader.pipeline;

import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.render.shader.pipeline.attribute.IShaderOperation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class CCShaderPipeline {
    private static int nextOperationIndex;
    private ShaderProgram program;
    private ArrayList<IShaderOperation> ops = new ArrayList();
    private ArrayList<PipelineNode> nodes = new ArrayList();
    private ArrayList<IShaderOperation> sorted = new ArrayList();
    private PipelineNode loading;
    private PipelineBuilder builder = new PipelineBuilder();

    public static int registerOperation() {
        return nextOperationIndex++;
    }

    public static int operationCount() {
        return nextOperationIndex;
    }

    public CCShaderPipeline(ShaderProgram program) {
        this.program = program;
    }

    public void setPipeline(IShaderOperation ... ops) {
        this.ops.clear();
        Collections.addAll(this.ops, ops);
        this.rebuild();
    }

    public void setPipeline(List<IShaderOperation> ops) {
        this.ops.clear();
        this.ops.addAll(ops);
        this.rebuild();
    }

    public void reset() {
        this.ops.clear();
        this.unbuild();
    }

    private void unbuild() {
        this.sorted.clear();
    }

    public void rebuild() {
        if (this.ops.isEmpty()) {
            return;
        }
        while (this.nodes.size() < CCShaderPipeline.operationCount()) {
            this.nodes.add(new PipelineNode());
        }
        this.unbuild();
        for (IShaderOperation op : this.ops) {
            this.loading = this.nodes.get(op.operationID());
            boolean loaded = op.load(this.program);
            if (!loaded) continue;
            this.loading.op = op;
        }
        for (PipelineNode node : this.nodes) {
            node.add();
        }
    }

    public void addRequirement(int opRef) {
        this.loading.deps.add(this.nodes.get(opRef));
    }

    public void operate() {
        for (IShaderOperation op : this.sorted) {
            op.operate(this.program);
        }
    }

    public PipelineBuilder builder() {
        this.ops.clear();
        return this.builder;
    }

    private class PipelineNode {
        public ArrayList<PipelineNode> deps = new ArrayList();
        public IShaderOperation op;

        private PipelineNode() {
        }

        public void add() {
            if (this.op == null) {
                return;
            }
            for (int i = 0; i < this.deps.size(); ++i) {
                this.deps.get(i).add();
            }
            this.deps.clear();
            CCShaderPipeline.this.sorted.add(this.op);
            this.op = null;
        }
    }

    public class PipelineBuilder {
        public PipelineBuilder add(IShaderOperation op) {
            CCShaderPipeline.this.ops.add(op);
            return this;
        }

        public PipelineBuilder add(IShaderOperation ... ops) {
            for (int i = 0; i < ops.length; ++i) {
                CCShaderPipeline.this.ops.add(ops[i]);
            }
            return this;
        }

        public void build() {
            CCShaderPipeline.this.rebuild();
        }
    }
}

