/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.world.placement;

import codechicken.lib.world.placement.lighting.LightingCalcEntry;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.WorldServer;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.FMLLog;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;

public class BlockPlacementLightingManager {
    private static final LinkedList<LightingCalcEntry> lightingQue = new LinkedList();
    public static final int lightEntriesPerTick = Integer.parseInt(System.getProperty("ccl.lightingEntriesPerTic", "100"));

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void tickEvent(TickEvent.ServerTickEvent serverTick) {
        if (serverTick.phase == TickEvent.Phase.START && !lightingQue.isEmpty()) {
            LinkedList<LightingCalcEntry> linkedList = lightingQue;
            synchronized (linkedList) {
                FMLLog.info((String)("Que Size: " + lightingQue.size()), (Object[])new Object[0]);
                Iterator iterator = lightingQue.iterator();
                int entriesProcessed = 0;
                while (iterator.hasNext() && entriesProcessed < lightEntriesPerTick) {
                    LightingCalcEntry entry = (LightingCalcEntry)iterator.next();
                    if (entry == null) continue;
                    WorldServer world = BlockPlacementLightingManager.getServer().func_71218_a(entry.dimension);
                    Chunk chunk = BlockPlacementLightingManager.getChunk(world, entry.pos);
                    if (entry.chunkHeightModified) {
                        chunk.func_76603_b();
                    } else {
                        if (entry.newLightOpacity > 0) {
                            if (entry.pos.func_177956_o() >= entry.height) {
                                chunk.func_76615_h(entry.pos.func_177958_n() & 0xF, entry.pos.func_177956_o() + 1, entry.pos.func_177952_p() & 0xF);
                            }
                        } else if (entry.pos.func_177956_o() == entry.height - 1) {
                            chunk.func_76615_h(entry.pos.func_177958_n() & 0xF, entry.pos.func_177956_o(), entry.pos.func_177952_p() & 0xF);
                        }
                        if (entry.newLightOpacity != entry.oldLightOpacity && (entry.newLightOpacity < entry.oldLightOpacity || entry.skyLight > 0 || entry.blockLight > 0)) {
                            chunk.func_76595_e(entry.pos.func_177958_n() & 0xF, entry.pos.func_177952_p() & 0xF);
                        }
                    }
                    ++entriesProcessed;
                    iterator.remove();
                }
            }
        }
    }

    private static MinecraftServer getServer() {
        return FMLCommonHandler.instance().getMinecraftServerInstance();
    }

    public static void uploadToLightingQue(LinkedList<LightingCalcEntry> lightingEntries) {
        BlockPlacementLightingManager.addEntries(lightingEntries);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static synchronized void addEntries(LinkedList<LightingCalcEntry> entries) {
        LinkedList<LightingCalcEntry> linkedList = lightingQue;
        synchronized (linkedList) {
            lightingQue.addAll(entries);
        }
    }

    protected static Chunk getChunk(WorldServer world, BlockPos pos) {
        return world.func_72964_e(pos.func_177958_n() >> 4, pos.func_177952_p() >> 4);
    }

    static {
        MinecraftForge.EVENT_BUS.register((Object)new BlockPlacementLightingManager());
    }
}

