/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution;

import codechicken.lib.packet.PacketCustom;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.achievements.Achievements;
import com.brandon3055.draconicevolution.blocks.energynet.rendering.ENetFXHandler;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.reactor.ReactorEffectHandler;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.entity.DragonChunkLoader;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.entity.EntityChaosImplosion;
import com.brandon3055.draconicevolution.entity.EntityCustomArrow;
import com.brandon3055.draconicevolution.entity.EntityDragonHeart;
import com.brandon3055.draconicevolution.entity.EntityEnderEnergyManipulator;
import com.brandon3055.draconicevolution.entity.EntityGuardianCrystal;
import com.brandon3055.draconicevolution.entity.EntityGuardianProjectile;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.handlers.ContributorHandler;
import com.brandon3055.draconicevolution.handlers.CustomArmorHandler;
import com.brandon3055.draconicevolution.handlers.DEEventHandler;
import com.brandon3055.draconicevolution.integration.ModHelper;
import com.brandon3055.draconicevolution.integration.computers.CCOCIntegration;
import com.brandon3055.draconicevolution.lib.OreDoublingRegistry;
import com.brandon3055.draconicevolution.lib.RecipeManager;
import com.brandon3055.draconicevolution.magic.EnchantmentReaper;
import com.brandon3055.draconicevolution.network.CCLNetworkTest;
import com.brandon3055.draconicevolution.network.CrystalUpdateBatcher;
import com.brandon3055.draconicevolution.network.PacketConfigureTool;
import com.brandon3055.draconicevolution.network.PacketContributor;
import com.brandon3055.draconicevolution.network.PacketDislocator;
import com.brandon3055.draconicevolution.network.PacketExplosionFX;
import com.brandon3055.draconicevolution.network.PacketLootSync;
import com.brandon3055.draconicevolution.network.PacketPlaceItem;
import com.brandon3055.draconicevolution.network.PacketPlaySound;
import com.brandon3055.draconicevolution.network.PacketShieldHit;
import com.brandon3055.draconicevolution.network.PacketSimpleBoolean;
import com.brandon3055.draconicevolution.network.PacketToolProfile;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.audio.ISound;
import net.minecraft.init.Items;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.CraftingManager;
import net.minecraft.item.crafting.IRecipe;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.event.FMLInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPostInitializationEvent;
import net.minecraftforge.fml.common.event.FMLPreInitializationEvent;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.oredict.ShapedOreRecipe;

public class CommonProxy {
    public void preInit(FMLPreInitializationEvent event) {
        RecipeManager.initialize();
        this.registerEventListeners(event.getSide());
        ContributorHandler.init();
        this.registerTileEntities();
        this.initializeNetwork();
        this.registerOres();
        EnchantmentReaper.init();
        Achievements.addModAchievements();
        LogHelper.info("Finished PreInitialization");
    }

    public void init(FMLInitializationEvent event) {
        this.registerGuiHandeler();
        this.registerEntities();
        CCOCIntegration.init();
        ModHelper.init();
        DragonChunkLoader.init();
        RecipeManager.loadRecipes();
        LogHelper.info("Finished Initialization");
    }

    public void postInit(FMLPostInitializationEvent event) {
        OreDoublingRegistry.init();
        Achievements.registerAchievementPane();
        if (DEConfig.expensiveDragonRitual) {
            List list = CraftingManager.func_77594_a().func_77592_b();
            boolean removed = false;
            Iterator i = list.iterator();
            while (i.hasNext()) {
                IRecipe recipe = (IRecipe)i.next();
                if (recipe.func_77571_b() == null || recipe.func_77571_b().func_77973_b() != Items.field_185158_cP) continue;
                i.remove();
                removed = true;
            }
            if (removed) {
                GameRegistry.addRecipe((IRecipe)new ShapedOreRecipe(new ItemStack(Items.field_185158_cP), new Object[]{"AAA", "ABA", "ACA", Character.valueOf('A'), "paneGlassColorless", Character.valueOf('B'), "netherStar", Character.valueOf('C'), Items.field_151073_bk}));
            }
        }
        LogHelper.info("Finished PostInitialization");
    }

    public void initializeNetwork() {
        PacketCustom.assignHandler((Object)"DE", (PacketCustom.ICustomPacketHandler)new CCLNetworkTest());
        DraconicEvolution.network = NetworkRegistry.INSTANCE.newSimpleChannel("DEvolutionNC");
        DraconicEvolution.network.registerMessage(PacketSimpleBoolean.Handler.class, PacketSimpleBoolean.class, 0, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketConfigureTool.Handler.class, PacketConfigureTool.class, 1, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketPlaySound.Handler.class, PacketPlaySound.class, 2, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketShieldHit.Handler.class, PacketShieldHit.class, 3, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketDislocator.Handler.class, PacketDislocator.class, 4, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketPlaceItem.Handler.class, PacketPlaceItem.class, 5, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketLootSync.Handler.class, PacketLootSync.class, 6, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketToolProfile.Handler.class, PacketToolProfile.class, 7, Side.SERVER);
        DraconicEvolution.network.registerMessage(PacketContributor.Handler.class, PacketContributor.class, 8, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketContributor.Handler.class, PacketContributor.class, 9, Side.SERVER);
        DraconicEvolution.network.registerMessage(CrystalUpdateBatcher.Handler.class, CrystalUpdateBatcher.class, 10, Side.CLIENT);
        DraconicEvolution.network.registerMessage(PacketExplosionFX.Handler.class, PacketExplosionFX.class, 11, Side.CLIENT);
    }

    public void registerTileEntities() {
    }

    public void registerEventListeners(Side s) {
        MinecraftForge.EVENT_BUS.register((Object)new DEEventHandler());
        MinecraftForge.EVENT_BUS.register((Object)new Achievements());
        MinecraftForge.EVENT_BUS.register((Object)new CustomArmorHandler());
    }

    public void registerGuiHandeler() {
    }

    public void registerOres() {
    }

    public void registerEntities() {
        EntityRegistry.registerModEntity(EntityPersistentItem.class, (String)"PersistentItem", (int)1, (Object)DraconicEvolution.instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityDragonHeart.class, (String)"DragonHeartItem", (int)5, (Object)DraconicEvolution.instance, (int)128, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityChaosGuardian.class, (String)"ChaosGuardian", (int)6, (Object)DraconicEvolution.instance, (int)512, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityGuardianProjectile.class, (String)"GuardianProjectile", (int)7, (Object)DraconicEvolution.instance, (int)256, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityGuardianCrystal.class, (String)"GuardianCrystal", (int)8, (Object)DraconicEvolution.instance, (int)256, (int)5, (boolean)false);
        EntityRegistry.registerModEntity(EntityChaosImplosion.class, (String)"EntityChaosEnergyVortex", (int)10, (Object)DraconicEvolution.instance, (int)512, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityCustomArrow.class, (String)"CustomArrow", (int)11, (Object)DraconicEvolution.instance, (int)128, (int)1, (boolean)true);
        EntityRegistry.registerModEntity(EntityLootCore.class, (String)"LootCore", (int)12, (Object)DraconicEvolution.instance, (int)64, (int)5, (boolean)true);
        EntityRegistry.registerModEntity(EntityEnderEnergyManipulator.class, (String)"EnderEnergyManipulator", (int)13, (Object)DraconicEvolution.instance, (int)128, (int)5, (boolean)true);
    }

    public void registerParticles() {
        DEParticles.registerServer();
    }

    public ENetFXHandler createENetFXHandler(TileCrystalBase tile) {
        return tile.createServerFXHandler();
    }

    public ReactorEffectHandler createReactorFXHandler(TileReactorCore tile) {
        return null;
    }

    public ISound playISound(ISound sound) {
        return null;
    }
}

