/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.reactor.tileentity;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.blocks.TileEnergyBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.network.wrappers.SyncableBool;
import com.brandon3055.brandonscore.network.wrappers.SyncableEnum;
import com.brandon3055.brandonscore.network.wrappers.SyncableInt;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableVec3I;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.reactor.tileentity.TileReactorCore;
import com.brandon3055.draconicevolution.integration.computers.ArgHelper;
import com.brandon3055.draconicevolution.integration.computers.IDEPeripheral;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.HashMap;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumParticleTypes;
import net.minecraft.util.ITickable;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;
import net.minecraft.world.chunk.Chunk;

public abstract class TileReactorComponent
extends TileEnergyBase
implements ITickable,
IDEPeripheral {
    private final SyncableVec3I coreOffset = new SyncableVec3I(new Vec3I(0, 0, 0), true, false);
    public final SyncableEnum<EnumFacing> facing = new SyncableEnum((Enum)EnumFacing.UP, true, false);
    public final SyncableBool isBound = new SyncableBool(false, true, false);
    public final SyncableEnum<RSMode> rsMode = new SyncableEnum((Enum)RSMode.TEMP, true, false);
    public final SyncableInt rsPower = new SyncableInt(0, true, false, true);
    public float animRotation = 0.0f;
    public float animRotationSpeed = 0.0f;
    private TileReactorCore cachedCore = null;
    public boolean coreFalureIminent = false;

    public TileReactorComponent() {
        this.registerSyncableObject((SyncableObject)this.coreOffset);
        this.registerSyncableObject((SyncableObject)this.facing);
        this.registerSyncableObject((SyncableObject)this.isBound);
        this.registerSyncableObject((SyncableObject)this.rsMode);
        this.registerSyncableObject((SyncableObject)this.rsPower);
    }

    public void func_73660_a() {
        this.detectAndSendChanges();
        if (this.field_145850_b.field_72995_K) {
            TileReactorCore core = this.tryGetCore();
            if (core != null) {
                this.animRotationSpeed = core.shieldAnimationState * 15.0f;
                this.coreFalureIminent = core.reactorState.value == TileReactorCore.ReactorState.BEYOND_HOPE;
            } else {
                this.coreFalureIminent = false;
                this.animRotationSpeed = 0.0f;
            }
            this.animRotation += this.animRotationSpeed;
            if (this.coreFalureIminent && this.field_145850_b.field_73012_v.nextInt(10) == 0) {
                this.animRotation = (float)((double)this.animRotation + (this.field_145850_b.field_73012_v.nextDouble() - 0.5) * 360.0);
                if (this.field_145850_b.field_73012_v.nextBoolean()) {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.SMOKE_LARGE, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                } else {
                    this.field_145850_b.func_175688_a(EnumParticleTypes.CLOUD, (double)this.field_174879_c.func_177958_n() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177956_o() + this.field_145850_b.field_73012_v.nextDouble(), (double)this.field_174879_c.func_177952_p() + this.field_145850_b.field_73012_v.nextDouble(), 0.0, 0.0, 0.0, new int[0]);
                }
            }
        } else {
            int rs;
            TileReactorCore core = this.getCachedCore();
            if (core != null && (rs = ((RSMode)this.rsMode.value).getRSSignal(core)) != this.rsPower.value) {
                this.rsPower.value = rs;
                this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q());
            }
        }
    }

    public void bindToCore(TileReactorCore core) {
        LogHelper.dev("Reactor-Comp: Bind To Core");
        this.isBound.value = true;
        this.coreOffset.vec = this.getCoreOffset(core.func_174877_v());
    }

    public void pokeCore() {
        TileReactorCore core;
        LogHelper.dev("Reactor-Comp: Try Poke Core");
        if (this.isBound.value && (core = this.checkAndGetCore()) != null) {
            core.pokeCore(this, ((EnumFacing)this.facing.value).func_176734_d());
            return;
        }
        LogHelper.dev("Reactor-Comp: Try Poke Core | Find");
        for (int i = 1; i < 8; ++i) {
            BlockPos searchPos = this.field_174879_c.func_177967_a((EnumFacing)this.facing.value, i);
            if (this.field_145850_b.func_175623_d(searchPos)) continue;
            TileEntity tile = this.field_145850_b.func_175625_s(searchPos);
            LogHelper.dev("Reactor-Comp: Try Poke Core | Found: " + tile);
            if (tile instanceof TileReactorCore && i > 1) {
                ((TileReactorCore)tile).pokeCore(this, ((EnumFacing)this.facing.value).func_176734_d());
            }
            return;
        }
    }

    public void invalidateComponent() {
        this.isBound.value = false;
    }

    public void onPlaced() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pokeCore();
    }

    public void onBroken() {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.componentBroken(this, ((EnumFacing)this.facing.value).func_176734_d());
        }
    }

    public void onActivated(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return;
        }
        this.pokeCore();
        TileReactorCore core = this.checkAndGetCore();
        if (core != null) {
            core.onComponentClicked(player, this);
        }
    }

    public void setRSMode(EntityPlayer player, RSMode rsMode) {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(new PacketTileMessage((TileBCBase)this, 0, rsMode.name(), false));
        } else if (this.verifyPlayerPermission(player)) {
            this.rsMode.value = rsMode;
        }
    }

    public void receivePacketFromClient(PacketTileMessage packet, EntityPlayerMP client) {
        if (packet.getIndex() == 0 && !packet.stringValue.isEmpty()) {
            try {
                this.setRSMode((EntityPlayer)client, RSMode.valueOf(packet.stringValue));
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    protected BlockPos getCorePos() {
        return this.field_174879_c.func_177973_b((Vec3i)this.coreOffset.vec.getPos());
    }

    protected Vec3I getCoreOffset(BlockPos corePos) {
        return new Vec3I(this.field_174879_c.func_177973_b((Vec3i)corePos));
    }

    protected TileReactorCore checkAndGetCore() {
        if (!this.isBound.value) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        if (this.field_145850_b.func_175726_f(this.getCorePos()).func_177410_o()) {
            this.invalidateComponent();
        }
        return null;
    }

    public TileReactorCore tryGetCore() {
        if (!this.isBound.value) {
            return null;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.getCorePos());
        if (tile instanceof TileReactorCore) {
            return (TileReactorCore)tile;
        }
        return null;
    }

    protected TileReactorCore getCachedCore() {
        if (this.isBound.value) {
            BlockPos corePos = this.getCorePos();
            Chunk coreChunk = this.field_145850_b.func_175726_f(corePos);
            if (!coreChunk.func_177410_o()) {
                this.cachedCore = null;
                return null;
            }
            TileEntity tileAtPos = coreChunk.func_177424_a(corePos, Chunk.EnumCreateEntityType.CHECK);
            if (tileAtPos == null || this.cachedCore == null || tileAtPos != this.cachedCore || tileAtPos.func_145837_r()) {
                TileEntity tile = this.field_145850_b.func_175625_s(corePos);
                if (tile instanceof TileReactorCore) {
                    this.cachedCore = (TileReactorCore)tile;
                } else {
                    this.cachedCore = null;
                    this.isBound.value = false;
                }
            }
        }
        return this.cachedCore;
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from == ((EnumFacing)this.facing.value).func_176734_d();
    }

    @Override
    public String getPeripheralName() {
        return "draconic_reactor";
    }

    @Override
    public String[] getMethodNames() {
        return new String[]{"getReactorInfo", "chargeReactor", "activateReactor", "stopReactor", "setFailSafe"};
    }

    @Override
    public Object[] callMethod(String method, ArgHelper args) {
        TileReactorCore reactor = this.getCachedCore();
        if (reactor == null) {
            return null;
        }
        if (method.equals("getReactorInfo")) {
            HashMap<String, Object> map = new HashMap<String, Object>();
            map.put("temperature", Utils.round((double)reactor.temperature.value, (double)100.0));
            map.put("fieldStrength", Utils.round((double)reactor.shieldCharge.value, (double)100.0));
            map.put("maxFieldStrength", Utils.round((double)reactor.maxShieldCharge.value, (double)100.0));
            map.put("energySaturation", reactor.saturation.value);
            map.put("maxEnergySaturation", reactor.maxSaturation.value);
            map.put("fuelConversion", Utils.round((double)reactor.convertedFuel.value, (double)1000.0));
            map.put("maxFuelConversion", reactor.reactableFuel.value + reactor.convertedFuel.value);
            map.put("generationRate", (int)reactor.generationRate.value);
            map.put("fieldDrainRate", reactor.fieldDrain.value);
            map.put("fuelConversionRate", (int)Math.round(reactor.fuelUseRate.value * 1000000.0));
            map.put("status", ((TileReactorCore.ReactorState)reactor.reactorState.value).name().toLowerCase());
            map.put("failSafe", reactor.failSafeMode.value);
            return new Object[]{map};
        }
        if (method.equals("chargeReactor")) {
            if (reactor.canCharge()) {
                reactor.chargeReactor();
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (method.equals("activateReactor")) {
            if (reactor.canActivate()) {
                reactor.activateReactor();
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (method.equals("stopReactor")) {
            if (reactor.canStop()) {
                reactor.shutdownReactor();
                return new Object[]{true};
            }
            return new Object[]{false};
        }
        if (method.equals("setFailSafe")) {
            reactor.failSafeMode.value = args.checkBoolean(0);
            return new Object[]{true};
        }
        return new Object[0];
    }

    public static enum RSMode {
        TEMP{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return (int)(tile.temperature.value / 10000.0 * 15.0);
            }
        }
        ,
        TEMP_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - TEMP.getRSSignal(tile);
            }
        }
        ,
        FIELD{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                double value = tile.shieldCharge.value / tile.maxShieldCharge.value;
                value -= 0.05;
                return (int)((value *= 1.2) * 15.0);
            }
        }
        ,
        FIELD_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - FIELD.getRSSignal(tile);
            }
        }
        ,
        SAT{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return (int)((double)tile.saturation.value / (double)tile.maxSaturation.value * 15.0);
            }
        }
        ,
        SAT_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - SAT.getRSSignal(tile);
            }
        }
        ,
        FUEL{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                double value = tile.convertedFuel.value / (tile.convertedFuel.value + tile.reactableFuel.value);
                value += 0.1;
                value = Utils.map((double)value, (double)0.1, (double)1.0, (double)0.0, (double)1.0);
                return (int)(value * 15.0);
            }
        }
        ,
        FUEL_INV{

            @Override
            public int getRSSignal(TileReactorCore tile) {
                return 15 - FUEL.getRSSignal(tile);
            }
        };


        public abstract int getRSSignal(TileReactorCore var1);
    }
}

