/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.gui;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.client.gui.GuiButtonAHeight;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.inventory.ContainerBCBase;
import com.brandon3055.brandonscore.network.PacketTileMessage;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.blocks.tileentity.TileEnergyStorageCore;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.inventory.GuiContainer;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.Container;
import net.minecraft.util.text.TextFormatting;

public class GuiEnergyCore
extends GuiContainer {
    public EntityPlayer player;
    public TileEnergyStorageCore tile;
    private GuiButton activate;
    private GuiButton tierUp;
    private GuiButton tierDown;
    private GuiButton toggleGuide;
    private GuiButton creativeBuild;

    public GuiEnergyCore(EntityPlayer player, TileEnergyStorageCore tile) {
        super((Container)new ContainerBCBase(player, (TileBCBase)tile).addPlayerSlots(10, 116));
        this.tile = tile;
        this.field_146999_f = 180;
        this.field_147000_g = 200;
        this.player = player;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.field_146292_n.clear();
        this.activate = new GuiButtonAHeight(0, this.field_147003_i + 9, this.field_147009_r + 99, 162, 12, "Activate-L");
        this.field_146292_n.add(this.activate);
        this.tierUp = new GuiButtonAHeight(1, this.field_147003_i + 91, this.field_147009_r + 86, 80, 12, I18n.func_135052_a((String)"button.de.tierUp.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.tierUp);
        this.tierDown = new GuiButtonAHeight(2, this.field_147003_i + 9, this.field_147009_r + 86, 80, 12, I18n.func_135052_a((String)"button.de.tierDown.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.tierDown);
        this.toggleGuide = new GuiButtonAHeight(3, this.field_147003_i + 9, this.field_147009_r + 73, 162, 12, I18n.func_135052_a((String)"button.de.buildGuide.txt", (Object[])new Object[0]));
        this.field_146292_n.add(this.toggleGuide);
        this.creativeBuild = new GuiButtonAHeight(4, this.field_147003_i + 9, this.field_147009_r + this.field_147000_g, 162, 12, "Creative Build");
        this.field_146292_n.add(this.creativeBuild);
        this.updateButtonStates();
    }

    protected void func_146976_a(float partialTicks, int mouseX, int mouseY) {
        GuiHelper.drawGuiBaseBackground((Gui)this, (int)this.field_147003_i, (int)this.field_147009_r, (int)this.field_146999_f, (int)this.field_147000_g);
        GuiHelper.drawPlayerSlots((Gui)this, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 115), (boolean)true);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.de.energyStorageCore.name", (Object[])new Object[]{this.tile.tier.toString()}), this.field_147003_i + this.field_146999_f / 2, this.field_147009_r + 5, 65535);
        if (this.tile.active.value) {
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"gui.de.capacity.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 16), (int)0xFFAA00, (boolean)true);
            String capText = this.tile.tier.value == 8 ? I18n.func_135052_a((String)"gui.de.almostInfinite.txt", (Object[])new Object[0]) : Utils.formatNumber((long)this.tile.getExtendedCapacity());
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)capText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 27), (int)0x555555, (boolean)false);
            DecimalFormat energyValue = new DecimalFormat("###.###");
            double percent = (double)this.tile.getExtendedStorage() / (double)this.tile.getExtendedCapacity() * 100.0;
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"info.bc.charge.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 38), (int)0xFFAA00, (boolean)true);
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)(Utils.formatNumber((long)this.tile.getExtendedStorage()) + "RF [" + energyValue.format(percent) + "%]"), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 49), (int)0x555555, (boolean)false);
            int coreColour = this.tile.transferRate.value > 0L ? 65280 : (this.tile.transferRate.value < 0L ? 0xFF0000 : 0x222222);
            String transfer = (this.tile.transferRate.value > 0L ? "+" : "") + Utils.formatNumber((long)this.tile.transferRate.value) + " RF/t";
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"gui.de.transfer.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 59), (int)0xFFAA00, (boolean)true);
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)transfer, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 70), (int)coreColour, (this.tile.transferRate.value > 0L ? 1 : 0) != 0);
        } else {
            int stabColour = this.tile.stabilizersOK.value ? 65280 : 0xFF0000;
            String stabText = I18n.func_135052_a((String)"gui.de.stabilizers.txt", (Object[])new Object[0]) + ": " + (this.tile.stabilizersOK.value ? I18n.func_135052_a((String)"gui.de.valid.txt", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.invalid.txt", (Object[])new Object[0]));
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)stabText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 18), (int)stabColour, (boolean)this.tile.stabilizersOK.value);
            if (this.tile.tier.value >= 5) {
                GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)I18n.func_135052_a((String)"gui.de.advancedStabilizersRequired.txt", (Object[])new Object[0]), (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 28), (int)0x777777, (boolean)false);
            }
            int coreColour = this.tile.coreValid.value ? 65280 : 0xFF0000;
            String coreText = I18n.func_135052_a((String)"gui.de.core.txt", (Object[])new Object[0]) + ": " + (this.tile.coreValid.value ? I18n.func_135052_a((String)"gui.de.valid.txt", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.invalid.txt", (Object[])new Object[0]));
            GuiHelper.drawCenteredString((FontRenderer)this.field_146289_q, (String)coreText, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 36), (int)coreColour, (boolean)this.tile.coreValid.value);
            if (!this.tile.coreValid.value) {
                GuiHelper.drawCenteredSplitString((FontRenderer)this.field_146289_q, (String)this.tile.invalidMessage.value, (int)(this.field_147003_i + this.field_146999_f / 2), (int)(this.field_147009_r + 46), (int)180, (int)coreColour, (boolean)this.tile.coreValid.value);
            }
        }
    }

    protected void func_146979_b(int mouseX, int mouseY) {
        super.func_146979_b(mouseX, mouseY);
    }

    public void func_73863_a(int mouseX, int mouseY, float partialTicks) {
        super.func_73863_a(mouseX, mouseY, partialTicks);
        if (this.tile.active.value) {
            ArrayList<String> list;
            GuiHelper.drawEnergyBar((Gui)this, (int)(this.field_147003_i + 5), (int)(this.field_147009_r + 82), (int)170, (boolean)true, (long)this.tile.getExtendedStorage(), (long)this.tile.getExtendedCapacity(), (boolean)true, (int)mouseX, (int)mouseY);
            if (GuiHelper.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 27), (int)(this.field_146999_f - 80), (int)8, (int)mouseX, (int)mouseY)) {
                list = new ArrayList<String>();
                list.add(TextFormatting.GRAY + "[" + Utils.addCommas((long)this.tile.getExtendedCapacity()) + " RF]");
                this.func_146283_a(list, mouseX, mouseY);
            }
            if (GuiHelper.isInRect((int)(this.field_147003_i + 40), (int)(this.field_147009_r + 48), (int)(this.field_146999_f - 80), (int)8, (int)mouseX, (int)mouseY)) {
                list = new ArrayList();
                list.add(TextFormatting.GRAY + "[" + Utils.addCommas((long)this.tile.getExtendedStorage()) + " RF]");
                this.func_146283_a(list, mouseX, mouseY);
            }
        }
    }

    public void func_73876_c() {
        super.func_73876_c();
        this.updateButtonStates();
    }

    private void updateButtonStates() {
        if (this.tile.active.value) {
            this.activate.field_146126_j = I18n.func_135052_a((String)"button.de.deactivate.txt", (Object[])new Object[0]);
        } else {
            this.activate.field_146126_j = I18n.func_135052_a((String)"button.de.activate.txt", (Object[])new Object[0]);
            this.toggleGuide.field_146126_j = I18n.func_135052_a((String)"button.de.buildGuide.txt", (Object[])new Object[0]) + " " + (this.tile.buildGuide.value ? I18n.func_135052_a((String)"gui.de.active.txt", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.de.inactive.txt", (Object[])new Object[0]));
            this.tierUp.field_146124_l = this.tile.tier.value < 8;
            this.tierDown.field_146124_l = this.tile.tier.value > 1;
        }
        this.toggleGuide.field_146125_m = !this.tile.active.value;
        this.tierDown.field_146125_m = this.toggleGuide.field_146125_m;
        this.tierUp.field_146125_m = this.toggleGuide.field_146125_m;
        this.creativeBuild.field_146125_m = this.player.field_71075_bZ.field_75098_d && !this.tile.active.value;
    }

    protected void func_146284_a(GuiButton button) throws IOException {
        this.tile.sendPacketToServer(new PacketTileMessage((TileBCBase)this.tile, (byte)button.field_146127_k, true, false));
    }
}

