/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.handler;

import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.render.shader.ShaderProgram;
import codechicken.lib.texture.TextureUtils;
import codechicken.lib.util.TransformUtils;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.ProcessHandlerClient;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.lib.DelayedExecutor;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.ModelUtils;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.ICrystalBinder;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.client.handler.HudHandler;
import com.brandon3055.draconicevolution.client.render.shaders.DEShaders;
import com.brandon3055.draconicevolution.handlers.BinderHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import com.brandon3055.draconicevolution.items.tools.CreativeExchanger;
import com.brandon3055.draconicevolution.items.tools.MiningToolBase;
import com.google.common.collect.Lists;
import java.nio.FloatBuffer;
import java.nio.IntBuffer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.client.gui.GuiMainMenu;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GLAllocation;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.event.FOVUpdateEvent;
import net.minecraftforge.client.event.GuiOpenEvent;
import net.minecraftforge.client.event.RenderGameOverlayEvent;
import net.minecraftforge.client.event.RenderPlayerEvent;
import net.minecraftforge.client.event.RenderWorldLastEvent;
import net.minecraftforge.client.model.obj.OBJLoader;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.fml.client.FMLClientHandler;
import net.minecraftforge.fml.common.eventhandler.SubscribeEvent;
import net.minecraftforge.fml.common.gameevent.TickEvent;
import net.minecraftforge.fml.relauncher.ReflectionHelper;
import net.minecraftforge.fml.relauncher.Side;
import org.lwjgl.util.glu.GLU;

public class ClientEventHandler {
    public static Map<EntityPlayer, DataUtils.XZPair<Float, Integer>> playerShieldStatus = new HashMap<EntityPlayer, DataUtils.XZPair<Float, Integer>>();
    public static FloatBuffer winPos = GLAllocation.func_74529_h((int)3);
    public static volatile int elapsedTicks;
    public static boolean playerHoldingWrench;
    public static Minecraft mc;
    private static Random rand;
    public static IBakedModel shieldModel;
    public static BlockPos explosionPos;
    public static double explosionAnimation;
    public static int explosionTime;
    public static boolean explosionRetreating;

    @SubscribeEvent
    public void renderGameOverlay(RenderGameOverlayEvent.Post event) {
        HudHandler.drawHUD(event);
        if (explosionPos != null && event.getType() == RenderGameOverlayEvent.ElementType.ALL) {
            mc = Minecraft.func_71410_x();
            this.updateExplosionAnimation(mc, (World)ClientEventHandler.mc.field_71441_e, event.getResolution(), mc.func_184121_ak());
        }
    }

    @SubscribeEvent
    public void tickEnd(TickEvent.ClientTickEvent event) {
        if (event.phase != TickEvent.Phase.END || event.type != TickEvent.Type.CLIENT || event.side != Side.CLIENT) {
            return;
        }
        ++elapsedTicks;
        HudHandler.clientTick();
        if (explosionPos != null) {
            this.updateExplosion();
        }
        Iterator<Map.Entry<EntityPlayer, DataUtils.XZPair<Float, Integer>>> i = playerShieldStatus.entrySet().iterator();
        while (i.hasNext()) {
            Map.Entry<EntityPlayer, DataUtils.XZPair<Float, Integer>> entry = i.next();
            if (elapsedTicks - (Integer)entry.getValue().getValue() <= 5) continue;
            i.remove();
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            playerHoldingWrench = player.func_184614_ca() != null && player.func_184614_ca().func_77973_b() instanceof ICrystalBinder || player.func_184592_cb() != null && player.func_184592_cb().func_77973_b() instanceof ICrystalBinder;
        }
    }

    @SubscribeEvent
    public void fovUpdate(FOVUpdateEvent event) {
    }

    @SubscribeEvent
    public void renderPlayerEvent(RenderPlayerEvent.Post event) {
        if (playerShieldStatus.containsKey(event.getEntityPlayer())) {
            if (shieldModel == null) {
                try {
                    shieldModel = OBJLoader.INSTANCE.loadModel(ResourceHelperDE.getResource("models/armor/shield_sphere.obj")).bake((IModelState)TransformUtils.DEFAULT_BLOCK, DefaultVertexFormats.field_176600_a, TextureUtils.bakedTextureGetter);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    return;
                }
            }
            GlStateManager.func_179094_E();
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179129_p();
            GlStateManager.func_179118_c();
            GlStateManager.func_179147_l();
            GlStateManager.func_179140_f();
            float p = ((Float)playerShieldStatus.get(event.getEntityPlayer()).getKey()).floatValue();
            EntityPlayerSP viewingPlayer = Minecraft.func_71410_x().field_71439_g;
            int i = 5 - (elapsedTicks - (Integer)playerShieldStatus.get(event.getEntityPlayer()).getValue());
            if (viewingPlayer != event.getEntityPlayer()) {
                double translationXLT = event.getEntityPlayer().field_70169_q - viewingPlayer.field_70169_q;
                double translationYLT = event.getEntityPlayer().field_70167_r - viewingPlayer.field_70167_r;
                double translationZLT = event.getEntityPlayer().field_70166_s - viewingPlayer.field_70166_s;
                double translationX = translationXLT + (event.getEntityPlayer().field_70165_t - viewingPlayer.field_70165_t - translationXLT) * (double)event.getPartialRenderTick();
                double translationY = translationYLT + (event.getEntityPlayer().field_70163_u - viewingPlayer.field_70163_u - translationYLT) * (double)event.getPartialRenderTick();
                double translationZ = translationZLT + (event.getEntityPlayer().field_70161_v - viewingPlayer.field_70161_v - translationZLT) * (double)event.getPartialRenderTick();
                GlStateManager.func_179137_b((double)translationX, (double)(translationY + 1.1), (double)translationZ);
            } else {
                GlStateManager.func_179137_b((double)0.0, (double)1.15, (double)0.0);
            }
            GlStateManager.func_179139_a((double)1.0, (double)1.5, (double)1.0);
            GlStateManager.func_179144_i((int)Minecraft.func_71410_x().func_147117_R().func_110552_b());
            ModelUtils.renderQuadsARGB((List)shieldModel.func_188616_a(null, null, 0L), (int)new ColourRGBA(1.0 - (double)p, 0.0, (double)p, (double)i / 5.0).argb());
            GlStateManager.func_179089_o();
            GlStateManager.func_179141_d();
            GlStateManager.func_179084_k();
            GlStateManager.func_179145_e();
            GlStateManager.func_179132_a((boolean)true);
            GlStateManager.func_179121_F();
        }
    }

    @SubscribeEvent
    public void guiOpenEvent(GuiOpenEvent event) {
        if (event.getGui() instanceof GuiMainMenu && rand.nextInt(150) == 0) {
            try {
                String s = rand.nextBoolean() ? "Icosahedrons proudly brought to you by CCL!!!" : Utils.addCommas((long)Long.MAX_VALUE) + " RF!!!!";
                ReflectionHelper.setPrivateValue(GuiMainMenu.class, (Object)((GuiMainMenu)event.getGui()), (Object)s, (String[])new String[]{"splashText", "field_110353_x"});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    @SubscribeEvent
    public void renderWorldEvent(RenderWorldLastEvent event) {
        if (event.isCanceled()) {
            return;
        }
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        World world = player.func_130014_f_();
        ItemStack stack = player.func_184614_ca();
        ItemStack offStack = player.func_184592_cb();
        Minecraft mc = Minecraft.func_71410_x();
        float partialTicks = event.getPartialTicks();
        if (stack != null && stack.func_77973_b() instanceof ICrystalBinder) {
            BinderHandler.renderWorldOverlay(player, world, stack, mc, partialTicks);
            return;
        }
        if (offStack != null && offStack.func_77973_b() instanceof ICrystalBinder) {
            BinderHandler.renderWorldOverlay(player, world, offStack, mc, partialTicks);
            return;
        }
        if (mc.field_71476_x == null || mc.field_71476_x.field_72313_a != RayTraceResult.Type.BLOCK) {
            return;
        }
        if (stack != null && stack.func_77973_b() == DEFeatures.creativeExchanger) {
            List<BlockPos> blocks = CreativeExchanger.getBlocksToReplace(stack, mc.field_71476_x.func_178782_a(), world, mc.field_71476_x.field_178784_b);
            Tessellator tessellator = Tessellator.func_178181_a();
            VertexBuffer buffer = tessellator.func_178180_c();
            double offsetX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
            double offsetY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
            double offsetZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
            GlStateManager.func_179147_l();
            GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_187441_d((float)2.0f);
            GlStateManager.func_179090_x();
            for (BlockPos block : blocks) {
                if (world.func_175623_d(block)) continue;
                double renderX = (double)block.func_177958_n() - offsetX;
                double renderY = (double)block.func_177956_o() - offsetY;
                double renderZ = (double)block.func_177952_p() - offsetZ;
                AxisAlignedBB boundingBox = new AxisAlignedBB(renderX, renderY, renderZ, renderX + 1.0, renderY + 1.0, renderZ + 1.0).func_72314_b(0.001, 0.001, 0.001);
                float colour = 1.0f;
                if (!world.func_180495_p(block.func_177972_a(mc.field_71476_x.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)world, block.func_177972_a(mc.field_71476_x.field_178784_b))) {
                    GlStateManager.func_179097_i();
                    colour = 0.2f;
                }
                buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                tessellator.func_78381_a();
                buffer.func_181668_a(3, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                tessellator.func_78381_a();
                buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72339_c).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72336_d, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72338_b, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                buffer.func_181662_b(boundingBox.field_72340_a, boundingBox.field_72337_e, boundingBox.field_72334_f).func_181666_a(colour, colour, colour, colour).func_181675_d();
                tessellator.func_78381_a();
                if (world.func_180495_p(block.func_177972_a(mc.field_71476_x.field_178784_b)).func_177230_c().func_176200_f((IBlockAccess)world, block.func_177972_a(mc.field_71476_x.field_178784_b))) continue;
                GlStateManager.func_179126_j();
            }
            GlStateManager.func_179098_w();
            GlStateManager.func_179084_k();
        }
        if (stack == null || !(stack.func_77973_b() instanceof MiningToolBase) || !ToolConfigHelper.getBooleanField("showDigAOE", stack)) {
            return;
        }
        BlockPos pos = mc.field_71476_x.func_178782_a();
        IBlockState state = world.func_180495_p(pos);
        MiningToolBase tool = (MiningToolBase)stack.func_77973_b();
        if (!tool.isToolEffective(stack, state)) {
            return;
        }
        this.renderMiningAOE(world, stack, pos, player, partialTicks);
    }

    private void renderMiningAOE(World world, ItemStack stack, BlockPos pos, EntityPlayerSP player, float partialTicks) {
        MiningToolBase tool = (MiningToolBase)stack.func_77973_b();
        PairKV<BlockPos, BlockPos> aoe = tool.getMiningArea(pos, (EntityPlayer)player, tool.getDigAOE(stack), tool.getDigDepth(stack));
        ArrayList blocks = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)((BlockPos)aoe.getKey()), (BlockPos)((BlockPos)aoe.getValue())));
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer buffer = tessellator.func_178180_c();
        double offsetX = player.field_70169_q + (player.field_70165_t - player.field_70169_q) * (double)partialTicks;
        double offsetY = player.field_70167_r + (player.field_70163_u - player.field_70167_r) * (double)partialTicks;
        double offsetZ = player.field_70166_s + (player.field_70161_v - player.field_70166_s) * (double)partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.func_187441_d((float)2.0f);
        GlStateManager.func_179090_x();
        GlStateManager.func_179097_i();
        buffer.func_181668_a(1, DefaultVertexFormats.field_181706_f);
        for (BlockPos block : blocks) {
            float alpha;
            IBlockState state = world.func_180495_p(block);
            if (!tool.isToolEffective(stack, state)) continue;
            double renderX = (double)block.func_177958_n() - offsetX;
            double renderY = (double)block.func_177956_o() - offsetY;
            double renderZ = (double)block.func_177952_p() - offsetZ;
            AxisAlignedBB box = new AxisAlignedBB(renderX, renderY, renderZ, renderX + 1.0, renderY + 1.0, renderZ + 1.0).func_186664_h(0.49);
            double rDist = Utils.getDistanceSq((double)pos.func_177958_n(), (double)pos.func_177956_o(), (double)pos.func_177952_p(), (double)block.func_177958_n(), (double)block.func_177956_o(), (double)block.func_177952_p());
            float colour = 1.0f - (float)rDist / 100.0f;
            if (colour < 0.1f) {
                colour = 0.1f;
            }
            if ((double)(alpha = colour) < 0.15) {
                alpha = 0.15f;
            }
            float r = 0.0f;
            float g = 1.0f;
            float b = 1.0f;
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72338_b, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72337_e, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72336_d, box.field_72338_b, box.field_72334_f).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
            buffer.func_181662_b(box.field_72340_a, box.field_72337_e, box.field_72339_c).func_181666_a(r * colour, g * colour, b * colour, alpha).func_181675_d();
        }
        tessellator.func_78381_a();
        GlStateManager.func_179126_j();
        GlStateManager.func_179098_w();
        GlStateManager.func_179084_k();
    }

    public static void triggerExplosionEffect(BlockPos pos) {
        explosionPos = pos;
        explosionRetreating = false;
        explosionAnimation = 0.0;
        explosionTime = 0;
        ProcessHandlerClient.addProcess((IProcess)new DelayedExecutor(5, new Object[0]){

            public void execute(Object[] args) {
                FMLClientHandler.instance().reloadRenderers();
            }
        });
    }

    private void updateExplosion() {
        if (Minecraft.func_71410_x().func_147113_T()) {
            return;
        }
        ++explosionTime;
        if (!explosionRetreating) {
            if ((explosionAnimation += 0.05) >= 1.0) {
                explosionAnimation = 1.0;
                explosionRetreating = true;
            }
        } else {
            if (explosionAnimation <= 0.0) {
                explosionAnimation = 0.0;
                explosionPos = null;
                return;
            }
            explosionAnimation -= 0.01;
        }
    }

    private void updateExplosionAnimation(Minecraft mc, World world, ScaledResolution resolution, float partialTick) {
        boolean behind;
        Entity entity = mc.func_175606_aa();
        float x = (float)(entity.field_70169_q + (entity.field_70165_t - entity.field_70169_q) * (double)partialTick);
        float y = (float)(entity.field_70167_r + (entity.field_70163_u - entity.field_70167_r) * (double)partialTick);
        float z = (float)(entity.field_70166_s + (entity.field_70161_v - entity.field_70166_s) * (double)partialTick);
        Vector3 targetPos = Vector3.fromBlockPosCenter((BlockPos)explosionPos);
        targetPos.subtract((double)x, (double)y, (double)z);
        GLU.gluProject((float)((float)targetPos.x), (float)((float)targetPos.y), (float)((float)targetPos.z), (FloatBuffer)ActiveRenderInfo.field_178812_b, (FloatBuffer)ActiveRenderInfo.field_178813_c, (IntBuffer)ActiveRenderInfo.field_178814_a, (FloatBuffer)winPos);
        float screenX = winPos.get(0) / (float)mc.field_71443_c;
        float screenY = winPos.get(1) / (float)mc.field_71440_d;
        boolean bl = behind = winPos.get(2) > 1.0f;
        if (behind) {
            screenX = -1.0f;
            screenY = -1.0f;
        }
        if (!DEShaders.useShaders() || explosionRetreating) {
            float alpha = explosionAnimation <= 0.0 ? 0.0f : (explosionRetreating ? (float)explosionAnimation - partialTick * 0.003f : (float)explosionAnimation + partialTick * 0.2f);
            GuiHelper.drawColouredRect((int)0, (int)0, (int)resolution.func_78326_a(), (int)resolution.func_78328_b(), (int)(0xFFFFFF | (int)(alpha * 255.0f) << 24));
        } else {
            DEShaders.explosionOverlayOp.setIntensity((float)explosionAnimation);
            DEShaders.explosionOverlayOp.setScreenPos(screenX, screenY);
            DEShaders.explosionOverlay.freeBindShader();
            GuiHelper.drawColouredRect((int)0, (int)0, (int)resolution.func_78326_a(), (int)resolution.func_78328_b(), (int)-1);
            ShaderProgram.unbindShader();
        }
    }

    static {
        playerHoldingWrench = false;
        rand = new Random();
        shieldModel = null;
        explosionPos = null;
        explosionAnimation = 0.0;
        explosionTime = 0;
        explosionRetreating = false;
    }
}

