/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.model.tool;

import codechicken.lib.util.TransformUtils;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.model.tool.ToolTransformOverride;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import javax.annotation.Nullable;
import javax.vecmath.Matrix4f;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.client.model.IPerspectiveAwareModel;
import org.apache.commons.lang3.tuple.Pair;

public class PerspectiveAwareToolModel
implements IPerspectiveAwareModel {
    private final IBakedModel objModel;
    private final ImmutableList<BakedQuad> simpleQuads;
    private final TextureAtlasSprite particle;
    private final ToolTransformOverride transformOverride;

    public PerspectiveAwareToolModel(ImmutableList<BakedQuad> simpleQuads, IBakedModel objModel, TextureAtlasSprite particle, ToolTransformOverride transformOverride) {
        this.objModel = objModel;
        this.simpleQuads = simpleQuads;
        this.particle = particle;
        this.transformOverride = transformOverride;
    }

    public Pair<? extends IBakedModel, Matrix4f> handlePerspective(ItemCameraTransforms.TransformType cameraTransformType) {
        if (DEConfig.disable3DModels) {
            if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
                return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)TransformUtils.DEFAULT_TOOL.getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
            }
            if (cameraTransformType == ItemCameraTransforms.TransformType.GROUND) {
                return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)TransformUtils.DEFAULT_ITEM.getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
            }
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)TransformUtils.DEFAULT_TOOL.getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
        }
        if (cameraTransformType == ItemCameraTransforms.TransformType.GUI) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this, (ImmutableMap)this.transformOverride.getOverride(cameraTransformType, TransformUtils.DEFAULT_TOOL).getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
        }
        if (cameraTransformType == ItemCameraTransforms.TransformType.GROUND) {
            return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this.objModel, (ImmutableMap)this.transformOverride.getOverride(cameraTransformType, TransformUtils.DEFAULT_ITEM).getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
        }
        return IPerspectiveAwareModel.MapWrapper.handlePerspective((IBakedModel)this.objModel, (ImmutableMap)this.transformOverride.getOverride(cameraTransformType, TransformUtils.DEFAULT_TOOL).getTransforms(), (ItemCameraTransforms.TransformType)cameraTransformType);
    }

    public List<BakedQuad> func_188616_a(@Nullable IBlockState state, @Nullable EnumFacing side, long rand) {
        if (side == null) {
            return this.simpleQuads;
        }
        return ImmutableList.of();
    }

    public boolean func_177555_b() {
        return false;
    }

    public boolean func_177556_c() {
        return false;
    }

    public boolean func_188618_c() {
        return false;
    }

    public TextureAtlasSprite func_177554_e() {
        return this.particle;
    }

    public ItemCameraTransforms func_177552_f() {
        return ItemCameraTransforms.field_178357_a;
    }

    public ItemOverrideList func_188617_f() {
        return ItemOverrideList.field_188022_a;
    }
}

