/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import codechicken.lib.render.CCModel;
import codechicken.lib.render.CCOBJParser;
import codechicken.lib.render.CCRenderState;
import codechicken.lib.render.RenderUtils;
import codechicken.lib.render.pipeline.IVertexOperation;
import codechicken.lib.vec.Matrix4;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Scale;
import codechicken.lib.vec.Transformation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IBCParticleFactory;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.helpers.ResourceHelperDE;
import java.util.Map;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.init.SoundEvents;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.world.World;

public class ParticleArrowShockwave
extends BCParticle {
    private static CCModel model = null;
    public double size = 0.0;
    public double maxSize;

    public ParticleArrowShockwave(World worldIn, Vec3D pos) {
        super(worldIn, pos);
        if (model == null) {
            Map map = CCOBJParser.parseObjModels((ResourceLocation)ResourceHelperDE.getResource("models/reactor_core_model.obj"));
            model = CCModel.combine(map.values());
            model.apply((Transformation)new Scale(1.0, 0.5, 1.0));
        }
    }

    public ParticleArrowShockwave(World worldIn, Vec3D pos, Vec3D speed) {
        this(worldIn, pos);
    }

    public void func_189213_a() {
        ++this.field_70546_d;
        this.size += 1.2;
        if (this.size > this.maxSize * 1.2) {
            this.func_187112_i();
        }
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
    }

    public void func_180434_a(VertexBuffer vertexbuffer, Entity entity, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        CCRenderState ccrs = CCRenderState.instance();
        ccrs.draw();
        GlStateManager.func_179094_E();
        GlStateManager.func_179129_p();
        GlStateManager.func_179092_a((int)516, (float)0.0f);
        float a = (float)Math.max(0.0, 0.5 - (this.size + (double)partialTicks) / this.maxSize * 0.5);
        GlStateManager.func_179131_c((float)1.0f, (float)0.1f, (float)0.0f, (float)a);
        GlStateManager.func_179090_x();
        GlStateManager.func_179132_a((boolean)false);
        float xx = (float)(this.field_187123_c + (this.field_187126_f - this.field_187123_c) * (double)partialTicks - field_70556_an);
        float yy = (float)(this.field_187124_d + (this.field_187127_g - this.field_187124_d) * (double)partialTicks - field_70554_ao);
        float zz = (float)(this.field_187125_e + (this.field_187128_h - this.field_187125_e) * (double)partialTicks - field_70555_ap);
        double baseScale = this.size + (double)partialTicks;
        GlStateManager.func_179137_b((double)((double)xx + 0.5), (double)((double)yy + 0.5), (double)((double)zz + 0.5));
        for (int i = 10; i > 0; --i) {
            double scale = baseScale / (double)i * 2.0;
            GlStateManager.func_179131_c((float)(1.0f - (float)i / 5.0f), (float)0.1f, (float)((float)i / 8.0f), (float)a);
            ccrs.startDrawing(4, DefaultVertexFormats.field_181707_g);
            Matrix4 mat = RenderUtils.getMatrix((Vector3)new Vector3(0.0, 0.0, 0.0), (Rotation)new Rotation((double)(((float)ClientEventHandler.elapsedTicks + partialTicks) / 40.0f), 0.0, 1.0, 0.0), (double)(-1.0 * scale));
            model.render(ccrs, new IVertexOperation[]{mat});
            ccrs.draw();
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179098_w();
        GlStateManager.func_179089_o();
        GlStateManager.func_179121_F();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
    }

    public static class Factory
    implements IBCParticleFactory {
        public Particle getEntityFX(int particleID, World world, Vec3D pos, Vec3D speed, int ... args) {
            ParticleArrowShockwave arrowShockwave = new ParticleArrowShockwave(world, pos, speed);
            world.func_184134_a(pos.x, pos.y, pos.z, SoundEvents.field_187539_bB, SoundCategory.PLAYERS, 10.0f, 0.9f + world.field_73012_v.nextFloat() * 0.2f, false);
            arrowShockwave.maxSize = args.length >= 1 ? (double)args[0] / 100.0 : 10.0;
            return arrowShockwave;
        }
    }
}

