/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.client.render.particle;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IBCParticleFactory;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.client.DEParticles;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.entity.Entity;
import net.minecraft.world.World;

public class ParticleDragonHeart
extends BCParticle {
    public Vec3D targetPos;
    public double startDist = 1.0;

    public ParticleDragonHeart(World worldIn, Vec3D pos) {
        super(worldIn, pos);
    }

    public ParticleDragonHeart(World worldIn, Vec3D pos, Vec3D targetPos) {
        super(worldIn, pos, new Vec3D(0.0, 0.0, 0.0));
        this.targetPos = targetPos;
        this.startDist = Utils.getDistanceAtoB((Vec3D)pos, (Vec3D)targetPos);
        this.field_70547_e = 3000;
        this.field_70544_f = 0.0f;
        this.texturesPerRow = 8.0f;
    }

    public boolean func_187111_c() {
        return true;
    }

    public void func_189213_a() {
        this.field_187123_c = this.field_187126_f;
        this.field_187124_d = this.field_187127_g;
        this.field_187125_e = this.field_187128_h;
        double dist = Utils.getDistanceAtoB((Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h), (Vec3D)this.targetPos);
        double progress = dist / this.startDist;
        this.field_70544_f = (float)progress;
        Vec3D dir = Vec3D.getDirectionVec((Vec3D)new Vec3D(this.field_187126_f, this.field_187127_g, this.field_187128_h), (Vec3D)this.targetPos);
        double speed = 0.5 * progress;
        this.field_187129_i = dir.x * speed;
        this.field_187130_j = dir.y * speed;
        this.field_187131_k = dir.z * speed;
        this.moveEntityNoClip(this.field_187129_i, this.field_187130_j, this.field_187131_k);
        if (this.field_70546_d++ > this.field_70547_e || Utils.getDistanceAtoB((double)this.field_187126_f, (double)this.field_187127_g, (double)this.field_187128_h, (double)this.targetPos.x, (double)this.targetPos.y, (double)this.targetPos.z) < 0.01) {
            this.func_187112_i();
        }
    }

    public void func_180434_a(VertexBuffer vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        super.func_180434_a(vertexbuffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
    }

    public static class Factory
    implements IBCParticleFactory {
        public Particle getEntityFX(int particleID, World world, Vec3D pos, Vec3D speed, int ... args) {
            ParticleDragonHeart particleHeart = new ParticleDragonHeart(world, pos, speed);
            if (args.length >= 3) {
                particleHeart.func_70538_b((float)args[0] / 255.0f, (float)args[1] / 255.0f, (float)args[2] / 255.0f);
            }
            if (args.length >= 4) {
                pos.add(0.0, 0.5, 0.0);
                particleHeart.func_187112_i();
                Vec3D playerDir = Vec3D.getDirectionVec((Vec3D)pos, (Vec3D)speed);
                double dist = Utils.getDistanceAtoB((Vec3D)pos, (Vec3D)speed);
                for (int i = 0; i < 100; ++i) {
                    double d = dist * 0.01;
                    double randX = world.field_73012_v.nextDouble() - 0.5;
                    double randY = world.field_73012_v.nextDouble() - 0.5;
                    double randZ = world.field_73012_v.nextDouble() - 0.5;
                    BCEffectHandler.spawnFX((int)DEParticles.LINE_INDICATOR, (World)world, (Vec3D)pos.add(playerDir.x * d, playerDir.y * d, playerDir.z * d), (Vec3D)new Vec3D(randX * (double)0.05f, randY * (double)0.05f, randZ * (double)0.05f), (double)512.0, (int[])new int[]{255, 0, 0});
                }
            }
            return particleHeart;
        }
    }
}

