/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.ChunkPos;
import net.minecraft.world.World;
import net.minecraftforge.common.ForgeChunkManager;
import net.minecraftforge.common.MinecraftForge;

public class DragonChunkLoader
implements ForgeChunkManager.LoadingCallback {
    public static DragonChunkLoader instance;
    public static Map<EntityChaosGuardian, ForgeChunkManager.Ticket> ticketList;
    public static Map<EntityChaosGuardian, ArrayList<ChunkPos>> chunkList;
    public static boolean hasReportedIssue;

    public static void init() {
        if (!DEConfig.chaosGuardianLoading) {
            return;
        }
        instance = new DragonChunkLoader();
        MinecraftForge.EVENT_BUS.register((Object)instance);
        ForgeChunkManager.setForcedChunkLoadingCallback((Object)DraconicEvolution.instance, (ForgeChunkManager.LoadingCallback)instance);
    }

    public static void updateLoaded(EntityChaosGuardian guardian) {
        ForgeChunkManager.Ticket ticket;
        if (!DEConfig.chaosGuardianLoading) {
            return;
        }
        ArrayList<ChunkPos> dragonChunks = new ArrayList<ChunkPos>();
        for (int xx = (int)guardian.field_70165_t / 16 - 2; xx <= (int)guardian.field_70165_t / 16 + 2; ++xx) {
            for (int zz = (int)guardian.field_70161_v / 16 - 2; zz <= (int)guardian.field_70161_v / 16 + 2; ++zz) {
                dragonChunks.add(new ChunkPos(xx, zz));
            }
        }
        if (chunkList.containsKey((Object)guardian) && dragonChunks.hashCode() == chunkList.get((Object)guardian).hashCode()) {
            return;
        }
        if (ticketList.containsKey((Object)guardian)) {
            ticket = ticketList.get((Object)guardian);
            ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        }
        if ((ticket = ForgeChunkManager.requestTicket((Object)DraconicEvolution.instance, (World)guardian.field_70170_p, (ForgeChunkManager.Type)ForgeChunkManager.Type.ENTITY)) == null) {
            if (!hasReportedIssue) {
                LogHelper.error("##########################################################################################");
                LogHelper.error("Could not get ticket for dragon");
                LogHelper.error("Fore some reason forge has denied DE's request for a loader ticket for the chaos guardian");
                LogHelper.error("This means the chaos guardian may not behave as indented");
                LogHelper.error("This error will not show again.");
                LogHelper.error("##########################################################################################");
                hasReportedIssue = true;
            }
            return;
        }
        ticket.bindEntity((Entity)guardian);
        ticket.setChunkListDepth(25);
        ticketList.put(guardian, ticket);
        for (ChunkPos pos : dragonChunks) {
            ForgeChunkManager.forceChunk((ForgeChunkManager.Ticket)ticket, (ChunkPos)pos);
        }
        chunkList.put(guardian, dragonChunks);
    }

    public static void stopLoading(EntityChaosGuardian guardian) {
        if (!DEConfig.chaosGuardianLoading) {
            return;
        }
        if (!ticketList.containsKey((Object)guardian)) {
            return;
        }
        ForgeChunkManager.Ticket ticket = ticketList.get((Object)guardian);
        ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
        ticketList.remove((Object)guardian);
    }

    public void ticketsLoaded(List<ForgeChunkManager.Ticket> tickets, World world) {
        if (!DEConfig.chaosGuardianLoading) {
            return;
        }
        if (!tickets.isEmpty()) {
            for (ForgeChunkManager.Ticket ticket : tickets) {
                ForgeChunkManager.releaseTicket((ForgeChunkManager.Ticket)ticket);
            }
        }
    }

    static {
        ticketList = new HashMap<EntityChaosGuardian, ForgeChunkManager.Ticket>();
        chunkList = new HashMap<EntityChaosGuardian, ArrayList<ChunkPos>>();
        hasReportedIssue = false;
    }
}

