/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import com.brandon3055.brandonscore.config.Feature;
import com.brandon3055.brandonscore.config.ICustomRender;
import com.brandon3055.brandonscore.items.ItemBCore;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.client.handler.ClientEventHandler;
import com.brandon3055.draconicevolution.client.render.item.RenderItemMobSoul;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.multiplayer.WorldClient;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityList;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.IEntityLivingData;
import net.minecraft.entity.monster.EntitySkeleton;
import net.minecraft.entity.monster.EntityZombie;
import net.minecraft.entity.monster.IMob;
import net.minecraft.entity.monster.SkeletonType;
import net.minecraft.entity.monster.ZombieType;
import net.minecraft.entity.passive.EntityPig;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.translation.I18n;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.common.registry.ForgeRegistries;
import net.minecraftforge.fml.common.registry.VillagerRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class MobSoul
extends ItemBCore
implements ICustomRender {
    private static Map<String, Entity> renderEntityMap = new HashMap<String, Entity>();
    private static Map<String, String> entityNameCache = new HashMap<String, String>();
    public static List<String> randomDisplayList = null;

    public EnumActionResult func_180614_a(ItemStack stack, EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        if (player.func_70093_af()) {
            Entity entity = this.createEntity(world, stack);
            double sX = (double)(pos.func_177958_n() + facing.func_82601_c()) + 0.5;
            double sY = (double)(pos.func_177956_o() + facing.func_96559_d()) + 0.5;
            double sZ = (double)(pos.func_177952_p() + facing.func_82599_e()) + 0.5;
            if (entity == null) {
                LogHelper.error("Mob Soul bound entity = null");
                return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
            }
            entity.func_70012_b(sX, sY, sZ, player.field_70177_z, 0.0f);
            if (!world.field_72995_K) {
                world.func_72838_d(entity);
                if (!player.field_71075_bZ.field_75098_d) {
                    InventoryUtils.consumeHeldItem((EntityPlayer)player, (ItemStack)stack, (EnumHand)hand);
                }
            }
        }
        return super.func_180614_a(stack, player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public String func_77653_i(ItemStack stack) {
        String eString = this.getEntityString(stack);
        if (eString.equals("[Random-Display]")) {
            return "Mob " + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"));
        }
        String eModifier = "";
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"ZombieVillagerType")) {
            eModifier = "-" + ItemNBTHelper.getString((ItemStack)stack, (String)"ZombieVillagerType", (String)"minecraft:farmer");
        } else if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"ZombieTypeHusk")) {
            eModifier = "-Husk";
        }
        String localizedName = entityNameCache.computeIfAbsent(eString + eModifier, s -> {
            Entity entity = EntityList.func_75620_a((String)eString, null);
            if (entity == null) {
                entity = new EntityPig(null);
            }
            this.loadAdditionalEntityInfo(stack, entity);
            return entity.func_70005_c_();
        });
        return localizedName + " " + I18n.func_74838_a((String)(this.func_77657_g(stack) + ".name"));
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ModelRegistryHelper.registerItemRenderer((Item)this, (IItemRenderer)new RenderItemMobSoul());
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    public String getEntityString(ItemStack stack) {
        return ItemNBTHelper.getString((ItemStack)stack, (String)"EntityName", (String)"Pig");
    }

    public void setEntityString(String entityString, ItemStack stack) {
        ItemNBTHelper.setString((ItemStack)stack, (String)"EntityName", (String)entityString);
    }

    @Nullable
    public NBTTagCompound getEntityData(ItemStack stack) {
        NBTTagCompound compound = ItemNBTHelper.getCompound((ItemStack)stack);
        if (compound.func_74764_b("EntityData")) {
            return compound.func_74775_l("EntityData");
        }
        return null;
    }

    public void setEntityData(NBTTagCompound compound, ItemStack stack) {
        compound.func_82580_o("UUID");
        compound.func_82580_o("Motion");
        ItemNBTHelper.getCompound((ItemStack)stack).func_74782_a("EntityData", (NBTBase)compound);
    }

    public Entity createEntity(World world, ItemStack stack) {
        try {
            String eName = this.getEntityString(stack);
            NBTTagCompound entityData = this.getEntityData(stack);
            Entity entity = EntityList.func_75620_a((String)eName, (World)world);
            if (entity == null) {
                entity = new EntityPig(world);
            } else if (entityData != null) {
                entity.func_70020_e(entityData);
            } else {
                this.loadAdditionalEntityInfo(stack, entity);
                if (entity instanceof EntityLiving && !ForgeEventFactory.doSpecialSpawn((EntityLiving)((EntityLiving)entity), (World)world, (float)((float)entity.field_70165_t), (float)((float)entity.field_70163_u), (float)((float)entity.field_70161_v))) {
                    ((EntityLiving)entity).func_180482_a(world.func_175649_E(new BlockPos(entity)), (IEntityLivingData)null);
                }
            }
            entity.func_184211_a("IsSpawnerMob");
            return entity;
        }
        catch (Throwable e) {
            return new EntityPig(world);
        }
    }

    public ItemStack getSoulFromEntity(Entity entity, boolean saveEntityData) {
        ItemStack soul = new ItemStack((Item)DEFeatures.mobSoul);
        String registryName = EntityList.func_75621_b((Entity)entity);
        ItemNBTHelper.setString((ItemStack)soul, (String)"EntityName", (String)registryName);
        if (saveEntityData) {
            NBTTagCompound compound = new NBTTagCompound();
            entity.func_189511_e(compound);
            this.setEntityData(compound, soul);
        } else {
            this.saveAditionalEntityInfo(entity, soul);
        }
        return soul;
    }

    @SideOnly(value=Side.CLIENT)
    public Entity getRenderEntity(ItemStack stack) {
        String eName = this.getEntityString(stack);
        String eModifier = "";
        if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"ZombieVillagerType")) {
            eModifier = "-" + ItemNBTHelper.getString((ItemStack)stack, (String)"ZombieVillagerType", (String)"minecraft:farmer");
        } else if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"ZombieTypeHusk")) {
            eModifier = "-Husk";
        }
        if (eName.equals("[Random-Display]")) {
            if (randomDisplayList == null) {
                randomDisplayList = new ArrayList<String>();
                for (String rName : EntityList.func_180124_b()) {
                    Class clazz = (Class)EntityList.field_75625_b.get(rName);
                    if (clazz == null || !IMob.class.isAssignableFrom(clazz)) continue;
                    randomDisplayList.add(rName);
                }
            }
            if (randomDisplayList.size() > 0) {
                eName = randomDisplayList.get(ClientEventHandler.elapsedTicks / 20 % randomDisplayList.size());
            }
        }
        String finalEName = eName;
        if (!renderEntityMap.containsKey(eName + eModifier)) {
            Entity entity;
            WorldClient world = Minecraft.func_71410_x().field_71441_e;
            try {
                entity = EntityList.func_75620_a((String)finalEName, (World)world);
                if (entity == null) {
                    entity = new EntityPig((World)world);
                } else {
                    this.loadAdditionalEntityInfo(stack, entity);
                }
            }
            catch (Throwable e) {
                entity = new EntityPig((World)world);
            }
            renderEntityMap.put(eName + eModifier, entity);
        }
        return renderEntityMap.get(eName + eModifier);
    }

    private void saveAditionalEntityInfo(Entity entity, ItemStack stack) {
        if (entity instanceof EntitySkeleton) {
            ItemNBTHelper.setInteger((ItemStack)stack, (String)"EntityTypeID", (int)((EntitySkeleton)entity).func_189771_df().func_190135_a());
        } else if (entity instanceof EntityZombie) {
            VillagerRegistry.VillagerProfession prof = ((EntityZombie)entity).getVillagerTypeForge();
            if (prof != null && prof.getRegistryName() != null) {
                ItemNBTHelper.setString((ItemStack)stack, (String)"ZombieVillagerType", (String)prof.getRegistryName().toString());
            } else if (((EntityZombie)entity).func_189777_di() == ZombieType.HUSK) {
                ItemNBTHelper.setBoolean((ItemStack)stack, (String)"ZombieTypeHusk", (boolean)true);
            }
        }
    }

    private void loadAdditionalEntityInfo(ItemStack stack, Entity entity) {
        if (entity instanceof EntitySkeleton && ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"EntityTypeID")) {
            ((EntitySkeleton)entity).func_189768_a(SkeletonType.func_190134_a((int)ItemNBTHelper.getInteger((ItemStack)stack, (String)"EntityTypeID", (int)((EntitySkeleton)entity).func_189771_df().func_190135_a())));
        } else if (entity instanceof EntityZombie) {
            if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"ZombieVillagerType")) {
                String name = ItemNBTHelper.getString((ItemStack)stack, (String)"ZombieVillagerType", (String)"minecraft:farmer");
                VillagerRegistry.VillagerProfession p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation(name));
                if (p == null) {
                    p = (VillagerRegistry.VillagerProfession)ForgeRegistries.VILLAGER_PROFESSIONS.getValue(new ResourceLocation("minecraft:farmer"));
                }
                ((EntityZombie)entity).setVillagerType(p);
            } else if (ItemNBTHelper.verifyExistance((ItemStack)stack, (String)"ZombieTypeHusk")) {
                ((EntityZombie)entity).func_189778_a(ZombieType.HUSK);
            }
        }
    }
}

