/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks.properties;

import com.brandon3055.brandonscore.utils.ArrayUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import com.google.common.base.Optional;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import net.minecraft.block.properties.PropertyHelper;

public class PropertyString
extends PropertyHelper<String> {
    private final List<String> valuesSet = new ArrayList<String>();

    public PropertyString(String name, String ... values) {
        super(name, String.class);
        Collections.addAll(this.valuesSet, ArrayUtils.arrayToLowercase(values));
    }

    public Collection<String> func_177700_c() {
        return ImmutableSet.copyOf(this.valuesSet);
    }

    public Optional<String> func_185929_b(String value) {
        if (this.valuesSet.contains(value)) {
            return Optional.of((Object)value);
        }
        return Optional.absent();
    }

    public String getName(String value) {
        return value;
    }

    public int toMeta(String value) {
        return this.valuesSet.contains(value) ? this.valuesSet.indexOf(value) : 0;
    }

    public String fromMeta(int meta) {
        if (meta >= 0 && meta < this.valuesSet.size()) {
            return this.valuesSet.get(meta);
        }
        LogHelperBC.error("[PropertyString] Attempted to load property for invalid meta value");
        return this.valuesSet.get(0);
    }
}

