/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IScrollListener;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class MGuiScrollBar
extends MGuiElementBase {
    private double scrollPos = 0.0;
    public int backColour = -16777216;
    public int borderColour = -1;
    public int scrollColour = -8947849;
    public boolean horizontal = false;
    private boolean isDragging = false;
    public MGuiElementBase parentScrollable = null;
    public IScrollListener listener = null;
    protected double increment = 0.1;
    protected double shiftIncrement = 0.2;
    public double barSizeRatio = 20.0;
    public int clickOffset = 0;
    public double clickPos = 0.0;

    public MGuiScrollBar(IModularGui modularGui) {
        super(modularGui);
    }

    public MGuiScrollBar(IModularGui modularGui, int xPos, int yPos) {
        super(modularGui, xPos, yPos);
    }

    public MGuiScrollBar(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        super(modularGui, xPos, yPos, xSize, ySize);
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        this.drawBorderedRect(this.xPos, this.yPos, this.xSize, this.ySize, 1.0, this.getBackColour(), this.getBorderColour());
        double barWidth = this.horizontal ? (double)this.xSize / this.barSizeRatio : (double)(this.xSize - 2);
        double barHeight = this.horizontal ? (double)(this.ySize - 2) : (double)this.ySize / this.barSizeRatio;
        double barXPos = this.horizontal ? (double)(this.xPos + 1) + this.scrollPos * ((double)(this.xSize - 2) - barWidth) : (double)(this.xPos + 1);
        double barYPos = this.horizontal ? (double)(this.yPos + 1) : (double)(this.yPos + 1) + this.scrollPos * ((double)(this.ySize - 2) - barHeight);
        this.drawColouredRect(barXPos, barYPos, barWidth, barHeight, this.getScrollColour());
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        if (this.isMouseOver(mouseX, mouseY) || this.parentScrollable != null && this.parentScrollable.isMouseOver(mouseX, mouseY)) {
            double increment = GuiScreen.func_146272_n() ? this.shiftIncrement : this.increment;
            this.setScrollPos(this.scrollPos + (scrollDirection > 0 ? -increment : increment));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            double barYPos;
            double barWidth = this.horizontal ? (double)this.xSize / this.barSizeRatio : (double)(this.xSize - 2);
            double barHeight = this.horizontal ? (double)(this.ySize - 2) : (double)this.ySize / this.barSizeRatio;
            double barXPos = this.horizontal ? (double)(this.xPos + 1) + this.scrollPos * ((double)(this.xSize - 2) - barWidth) : (double)(this.xPos + 1);
            double d = barYPos = this.horizontal ? (double)(this.yPos + 1) : (double)(this.yPos + 1) + this.scrollPos * ((double)(this.ySize - 2) - barHeight);
            if (GuiHelper.isInRect((int)barXPos, (int)barYPos, (int)barWidth, (int)barHeight, mouseX, mouseY)) {
                this.isDragging = true;
                this.clickOffset = this.horizontal ? mouseX : mouseY;
                this.clickPos = this.scrollPos;
            } else {
                if (this.horizontal) {
                    double pos = mouseX - this.xPos;
                    this.setScrollPos(pos / (double)this.xSize);
                } else {
                    double pos = mouseY - this.yPos;
                    this.setScrollPos(pos / (double)this.ySize);
                }
                this.isDragging = true;
                this.clickOffset = this.horizontal ? mouseX : mouseY;
                this.clickPos = this.scrollPos;
            }
        }
        return false;
    }

    @Override
    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.isDragging) {
            double barHeight;
            double barWidth = this.horizontal ? (double)this.xSize / this.barSizeRatio : (double)(this.xSize - 2);
            double d = barHeight = this.horizontal ? (double)(this.ySize - 2) : (double)this.ySize / this.barSizeRatio;
            if (this.horizontal) {
                int movement = mouseX - this.clickOffset;
                double pos = this.clickPos + (double)movement / ((double)this.xSize - barWidth);
                this.setScrollPos(pos);
            } else {
                int movement = mouseY - this.clickOffset;
                double pos = this.clickPos + (double)movement / ((double)this.ySize - barHeight);
                this.setScrollPos(pos);
            }
        }
        return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public double getScrollPos() {
        return this.scrollPos;
    }

    public MGuiScrollBar setScrollPos(double scrollPos) {
        if (scrollPos > 1.0) {
            scrollPos = 1.0;
        } else if (scrollPos < 0.0) {
            scrollPos = 0.0;
        }
        this.scrollPos = scrollPos;
        if (this.listener != null) {
            this.listener.scrollBarMoved(this.scrollPos);
        }
        return this;
    }

    public MGuiScrollBar setListener(IScrollListener listener) {
        this.listener = listener;
        return this;
    }

    public void setIncrements(double increment, double shiftIncrement) {
        this.increment = increment;
        this.shiftIncrement = shiftIncrement;
    }

    public int getBackColour() {
        return this.backColour;
    }

    public int getBorderColour() {
        return this.borderColour;
    }

    public int getScrollColour() {
        return this.scrollColour;
    }

    public MGuiScrollBar setBarSizeRatio(double barSizeRatio) {
        this.barSizeRatio = barSizeRatio;
        return this;
    }
}

