/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import com.brandon3055.brandonscore.client.gui.modulargui.lib.IMGuiListener;
import com.brandon3055.brandonscore.client.utils.GuiHelper;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;

public class MGuiSlider
extends MGuiElementBase {
    public IMGuiListener listener;
    public double position = 0.0;
    public boolean horizontal = false;
    private boolean isDragging = false;
    public int barColour = -16777216;
    public int sliderColour = -1;
    public int backFillColour = 0;
    public int backBorderColour = 0;
    public double backBorderWidth = 1.0;
    protected double increment = 0.01;
    protected double shiftIncrement = 0.1;
    protected double barSize = 1.0;

    public MGuiSlider(IModularGui modularGui) {
        super(modularGui);
        this.barSize = this.horizontal ? (double)this.xSize / 15.0 : (double)this.ySize / 15.0;
    }

    public MGuiSlider(IModularGui modularGui, int xPos, int yPos) {
        super(modularGui, xPos, yPos);
        this.barSize = this.horizontal ? (double)this.xSize / 15.0 : (double)this.ySize / 15.0;
    }

    public MGuiSlider(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        super(modularGui, xPos, yPos, xSize, ySize);
        this.barSize = this.horizontal ? (double)xSize / 15.0 : (double)ySize / 15.0;
    }

    @Override
    public void initElement() {
        super.initElement();
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.horizontal) {
            this.drawColouredRect(this.xPos, (double)this.yPos + (double)this.ySize / 2.0 - 0.5, this.xSize, 1.0, this.barColour);
            this.drawColouredRect(this.xPos, this.yPos, 1.0, this.ySize, this.barColour);
            this.drawColouredRect(this.xPos + this.xSize - 1, this.yPos, 1.0, this.ySize, this.barColour);
        } else {
            this.drawColouredRect((double)this.xPos + (double)this.xSize / 2.0 - 0.5, this.yPos, 1.0, this.ySize, this.barColour);
            this.drawColouredRect(this.xPos, this.yPos, this.xSize, 1.0, this.barColour);
            this.drawColouredRect(this.xPos, this.yPos + this.ySize - 1, this.xSize, 1.0, this.barColour);
        }
        double barWidth = this.horizontal ? this.barSize : (double)this.xSize;
        double barHeight = this.horizontal ? (double)this.ySize : this.barSize;
        double barXPos = this.horizontal ? (double)(this.xPos + 1) + this.position * ((double)(this.xSize - 2) - barWidth) : (double)this.xPos;
        double barYPos = this.horizontal ? (double)this.yPos : (double)(this.yPos + 1) + this.position * ((double)(this.ySize - 2) - barHeight);
        this.drawBorderedRect(barXPos, barYPos, barWidth, barHeight, 0.5, this.sliderColour, MGuiSlider.mixColours(this.sliderColour, 0x404040, true));
    }

    @Override
    public boolean handleMouseScroll(int mouseX, int mouseY, int scrollDirection) {
        if (this.isMouseOver(mouseX, mouseY)) {
            double increment = GuiScreen.func_146272_n() ? this.shiftIncrement : this.increment;
            this.setPos(this.position + (scrollDirection > 0 ? -increment : increment));
            return true;
        }
        return false;
    }

    @Override
    public boolean mouseClicked(int mouseX, int mouseY, int mouseButton) throws IOException {
        if (this.isMouseOver(mouseX, mouseY)) {
            double barYPos;
            double barWidth = this.horizontal ? this.barSize : (double)(this.xSize - 2);
            double barHeight = this.horizontal ? (double)(this.ySize - 2) : this.barSize;
            double barXPos = this.horizontal ? (double)(this.xPos + 1) + this.position * ((double)(this.xSize - 2) - barWidth) : (double)(this.xPos + 1);
            double d = barYPos = this.horizontal ? (double)(this.yPos + 1) : (double)(this.yPos + 1) + this.position * ((double)(this.ySize - 2) - barHeight);
            if (GuiHelper.isInRect((int)barXPos, (int)barYPos, (int)barWidth, (int)barHeight, mouseX, mouseY)) {
                this.isDragging = true;
            } else {
                if (this.horizontal) {
                    double pos = (double)(mouseX - this.xPos) - barWidth / 2.0;
                    this.setPos(pos / (double)this.xSize);
                } else {
                    double pos = (double)(mouseY - this.yPos) - barHeight / 2.0;
                    this.setPos(pos / (double)this.ySize);
                }
                this.isDragging = true;
            }
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, mouseButton);
    }

    @Override
    public boolean mouseClickMove(int mouseX, int mouseY, int clickedMouseButton, long timeSinceLastClick) {
        if (this.isDragging) {
            double barHeight;
            double barWidth = this.horizontal ? this.barSize : (double)(this.xSize - 2);
            double d = barHeight = this.horizontal ? (double)(this.ySize - 2) : this.barSize;
            if (this.horizontal) {
                double pos = (double)(mouseX - this.xPos) - barWidth / 2.0;
                this.setPos(pos / ((double)this.xSize - barWidth));
            } else {
                double pos = (double)(mouseY - this.yPos) - barHeight / 2.0;
                this.setPos(pos / ((double)this.ySize - barHeight));
            }
        }
        return super.mouseClickMove(mouseX, mouseY, clickedMouseButton, timeSinceLastClick);
    }

    @Override
    public boolean mouseReleased(int mouseX, int mouseY, int state) {
        this.isDragging = false;
        return super.mouseReleased(mouseX, mouseY, state);
    }

    public MGuiSlider setListener(IMGuiListener listener) {
        this.listener = listener;
        return this;
    }

    public MGuiSlider setColours(int barColour, int sliderColour) {
        this.barColour = barColour;
        this.sliderColour = sliderColour;
        return this;
    }

    public MGuiSlider setBackground(int backFillColour, int backBorderColour, int backBourderWidth) {
        this.backFillColour = backFillColour;
        this.backBorderColour = backBorderColour;
        this.backBorderWidth = backBourderWidth;
        return this;
    }

    public MGuiSlider setIncrements(double increment, double shiftIncrement) {
        this.increment = increment;
        this.shiftIncrement = shiftIncrement;
        return this;
    }

    public MGuiSlider setHorizontal(boolean horizontal) {
        this.horizontal = horizontal;
        this.barSize = horizontal ? (double)this.xSize / 15.0 : (double)this.ySize / 15.0;
        return this;
    }

    public MGuiSlider setBarSize(double barSize) {
        this.barSize = barSize;
        return this;
    }

    public double getPos() {
        return this.position;
    }

    public void setPos(double scrollPos) {
        if (scrollPos > 1.0) {
            scrollPos = 1.0;
        } else if (scrollPos < 0.0) {
            scrollPos = 0.0;
        }
        this.position = scrollPos;
        if (this.listener != null) {
            this.listener.onMGuiEvent("SLIDER_MOVE", this);
        }
    }
}

