/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.handlers.IProcess;
import java.io.Closeable;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.util.function.BiConsumer;
import org.apache.commons.compress.utils.IOUtils;

public class ThreadFileDownloader
extends Thread
implements IProcess {
    private final String sourceURL;
    private final File outputFile;
    private volatile boolean finished = false;
    private volatile boolean failed = false;
    private boolean processComplete = false;
    private Exception exception = null;
    private BiConsumer<ThreadFileDownloader, File> downloadCompleteHandler;

    public ThreadFileDownloader(String threadName, String sourceURL, File outputFile, BiConsumer<ThreadFileDownloader, File> completionCallBack) {
        super(threadName);
        this.sourceURL = sourceURL;
        this.outputFile = outputFile;
        this.downloadCompleteHandler = completionCallBack;
    }

    @Override
    public synchronized void start() {
        BrandonsCore.proxy.addProcess(this);
        super.start();
    }

    @Override
    public void run() {
        try {
            URL url = new URL(this.sourceURL);
            if (!this.outputFile.exists() && !this.outputFile.createNewFile()) {
                throw new IOException("Could not create file, Reason unknown");
            }
            InputStream is = url.openStream();
            FileOutputStream os = new FileOutputStream(this.outputFile);
            IOUtils.copy((InputStream)is, (OutputStream)os);
            IOUtils.closeQuietly((Closeable)is);
            IOUtils.closeQuietly((Closeable)os);
            this.finished = true;
        }
        catch (Exception e) {
            this.exception = e;
            this.failed = true;
        }
    }

    public boolean isFinished() {
        return this.finished;
    }

    public boolean downloadFailed() {
        return this.failed;
    }

    public Exception getException() {
        return this.exception;
    }

    @Override
    public void updateProcess() {
        if (this.isFinished()) {
            this.downloadCompleteHandler.accept(this, this.outputFile);
            this.processComplete = true;
        } else if (this.downloadFailed()) {
            this.downloadCompleteHandler.accept(this, null);
            this.processComplete = true;
        }
    }

    @Override
    public boolean isDead() {
        return this.processComplete;
    }
}

