/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.MessageHandlerWrapper;
import io.netty.buffer.ByteBuf;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fml.common.network.ByteBufUtils;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;

public class PacketTileMessage
implements IMessage {
    public static final byte BOOLEAN_INDEX = 0;
    public static final byte BYTE_INDEX = 1;
    public static final byte INT_INDEX = 2;
    public static final byte DOUBLE_INDEX = 3;
    public static final byte FLOAT_INDEX = 4;
    public static final byte STRING_INDEX = 5;
    public static final byte TAG_INDEX = 6;
    public BlockPos tilePos;
    private byte pktIndex;
    public String stringValue = "";
    public float floatValue = 0.0f;
    public double doubleValue = 0.0;
    public int intValue = 0;
    public byte byteValue = 0;
    public boolean booleanValue = false;
    public NBTTagCompound compound;
    public byte dataType;

    public PacketTileMessage() {
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, boolean booleanValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.booleanValue = booleanValue;
        this.dataType = 0;
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, byte byteValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.byteValue = byteValue;
        this.dataType = 1;
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, int intValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.intValue = intValue;
        this.dataType = (byte)2;
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, double doubleValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.doubleValue = doubleValue;
        this.dataType = (byte)3;
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, float floatValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.floatValue = floatValue;
        this.dataType = (byte)4;
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, String stringValue, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.stringValue = stringValue;
        this.dataType = (byte)5;
    }

    public PacketTileMessage(TileBCBase tile, byte pktIndex, NBTTagCompound compound, boolean updateOnReceived) {
        this.tilePos = tile.func_174877_v();
        this.pktIndex = pktIndex;
        this.compound = compound;
        this.dataType = (byte)6;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeByte((int)this.dataType);
        buf.writeByte((int)this.pktIndex);
        buf.writeInt(this.tilePos.func_177958_n());
        buf.writeInt(this.tilePos.func_177956_o());
        buf.writeInt(this.tilePos.func_177952_p());
        switch (this.dataType) {
            case 0: {
                buf.writeBoolean(this.booleanValue);
                break;
            }
            case 1: {
                buf.writeByte((int)this.byteValue);
                break;
            }
            case 2: {
                buf.writeInt(this.intValue);
                break;
            }
            case 3: {
                buf.writeDouble(this.doubleValue);
                break;
            }
            case 4: {
                buf.writeFloat(this.floatValue);
                break;
            }
            case 5: {
                ByteBufUtils.writeUTF8String((ByteBuf)buf, (String)this.stringValue);
                break;
            }
            case 6: {
                ByteBufUtils.writeTag((ByteBuf)buf, (NBTTagCompound)this.compound);
            }
        }
    }

    public void fromBytes(ByteBuf buf) {
        this.dataType = buf.readByte();
        this.pktIndex = buf.readByte();
        int x = buf.readInt();
        int y = buf.readInt();
        int z = buf.readInt();
        this.tilePos = new BlockPos(x, y, z);
        switch (this.dataType) {
            case 0: {
                this.booleanValue = buf.readBoolean();
                break;
            }
            case 1: {
                this.byteValue = buf.readByte();
                break;
            }
            case 2: {
                this.intValue = buf.readInt();
                break;
            }
            case 3: {
                this.doubleValue = buf.readDouble();
                break;
            }
            case 4: {
                this.floatValue = buf.readFloat();
                break;
            }
            case 5: {
                this.stringValue = ByteBufUtils.readUTF8String((ByteBuf)buf);
                break;
            }
            case 6: {
                this.compound = ByteBufUtils.readTag((ByteBuf)buf);
            }
        }
    }

    public boolean isBool() {
        return this.dataType == 0;
    }

    public boolean isByte() {
        return this.dataType == 1;
    }

    public boolean isInt() {
        return this.dataType == 2;
    }

    public boolean isDouble() {
        return this.dataType == 3;
    }

    public boolean isFload() {
        return this.dataType == 4;
    }

    public boolean isString() {
        return this.dataType == 5;
    }

    public boolean isNBT() {
        return this.dataType == 6 && this.compound != null;
    }

    public byte getIndex() {
        return this.pktIndex;
    }

    public static class Handler
    extends MessageHandlerWrapper<PacketTileMessage, IMessage> {
        @Override
        public IMessage handleMessage(PacketTileMessage message, MessageContext ctx) {
            TileEntity tile;
            if (ctx.side == Side.SERVER) {
                TileEntity tile2 = ctx.getServerHandler().field_147369_b.field_70170_p.func_175625_s(message.tilePos);
                if (tile2 instanceof TileBCBase) {
                    ((TileBCBase)tile2).receivePacketFromClient(message, ctx.getServerHandler().field_147369_b);
                }
            } else if (ctx.side == Side.CLIENT && (tile = BrandonsCore.proxy.getClientWorld().func_175625_s(message.tilePos)) instanceof TileBCBase) {
                ((TileBCBase)tile).receivePacketFromServer(message);
            }
            return null;
        }
    }
}

