/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.network.wrappers;

import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.network.PacketSyncableObject;
import com.brandon3055.brandonscore.network.wrappers.SyncableObject;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class SyncableNBT
extends SyncableObject {
    public NBTTagCompound value;
    private NBTTagCompound lastTickValue;

    public SyncableNBT(NBTTagCompound value, boolean syncInTile, boolean syncInContainer) {
        super(syncInTile, syncInContainer);
        this.value = this.lastTickValue = value;
    }

    @Override
    public void detectAndSendChanges(TileBCBase tile, EntityPlayer player, boolean forceSync) {
        if (!this.lastTickValue.equals((Object)this.value)) {
            this.lastTickValue = this.value;
            if (tile != null) {
                BrandonsCore.network.sendToAllAround((IMessage)new PacketSyncableObject(tile, this.index, this.value, this.updateOnReceived), tile.syncRange());
            } else if (player instanceof EntityPlayerMP) {
                BrandonsCore.network.sendTo((IMessage)new PacketSyncableObject(null, this.index, this.value, this.updateOnReceived), (EntityPlayerMP)player);
            } else {
                LogHelperBC.error("SyncableNBT#detectAndSendChanges No valid destination for sync packet!");
            }
        }
    }

    @Override
    public void updateReceived(PacketSyncableObject packet) {
        if (packet.dataType == 6) {
            this.value = packet.compound;
        }
    }

    @Override
    public void toNBT(NBTTagCompound compound) {
        compound.func_74782_a("SyncableNBT" + this.index, (NBTBase)this.value);
    }

    @Override
    public void fromNBT(NBTTagCompound compound) {
        if (compound.func_74764_b("SyncableNBT" + this.index)) {
            this.value = compound.func_74775_l("SyncableNBT" + this.index);
        }
    }
}

