/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.utils;

import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.IResourceManager;
import net.minecraft.client.resources.IResourceManagerReloadListener;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.Vec3i;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.obj.OBJModel;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class ModelUtils
implements IResourceManagerReloadListener {
    public static Map<IBlockState, List<BakedQuad>> quadCache = new HashMap<IBlockState, List<BakedQuad>>();
    public static Map<ResourceLocation, IBakedModel> bakedModelCache = new HashMap<ResourceLocation, IBakedModel>();

    public static List<BakedQuad> getModelQuads(IBlockState state) {
        if (!quadCache.containsKey(state)) {
            IBakedModel blockModel = Minecraft.func_71410_x().func_175602_ab().func_184389_a(state);
            ArrayList listQuads = new ArrayList();
            if (blockModel instanceof OBJModel.OBJBakedModel) {
                listQuads.addAll(blockModel.func_188616_a(state, null, 0L));
            } else {
                for (EnumFacing face : EnumFacing.field_82609_l) {
                    listQuads.addAll(blockModel.func_188616_a(state, face, 0L));
                }
            }
            quadCache.put(state, listQuads);
        }
        if (quadCache.containsKey(state)) {
            return quadCache.get(state);
        }
        return new ArrayList<BakedQuad>();
    }

    public static void renderQuads(List<BakedQuad> listQuads) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.func_178981_a(bakedquad.func_178209_a());
            vertexbuffer.func_178990_f(1.0f, 1.0f, 1.0f);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            vertexbuffer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
        }
        tessellator.func_78381_a();
    }

    public static void renderQuadsRGB(List<BakedQuad> listQuads, float r, float g, float b) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            vertexbuffer.func_178981_a(bakedquad.func_178209_a());
            vertexbuffer.func_178990_f(r, g, b);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            vertexbuffer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static void renderQuadsARGB(List<BakedQuad> listQuads, int ARGB_Hex) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        int j = listQuads.size();
        for (int i = 0; i < j; ++i) {
            BakedQuad bakedquad = listQuads.get(i);
            vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_176599_b);
            vertexbuffer.func_178981_a(bakedquad.func_178209_a());
            vertexbuffer.func_178968_d(ARGB_Hex);
            Vec3i vec3i = bakedquad.func_178210_d().func_176730_m();
            vertexbuffer.func_178975_e((float)vec3i.func_177958_n(), (float)vec3i.func_177956_o(), (float)vec3i.func_177952_p());
            tessellator.func_78381_a();
        }
    }

    public static IBakedModel loadBakedModel(ResourceLocation modelLocation) {
        if (!bakedModelCache.containsKey(modelLocation)) {
            try {
                IModel model = ModelLoaderRegistry.getModel((ResourceLocation)modelLocation);
                IBakedModel bakedModel = model.bake((IModelState)TRSRTransformation.identity(), DefaultVertexFormats.field_176599_b, input -> Minecraft.func_71410_x().func_147117_R().func_110572_b(input.toString()));
                bakedModelCache.put(modelLocation, bakedModel);
            }
            catch (Exception e) {
                LogHelperBC.fatalErrorMessage("Error at ModelUtils.loadBakedModel, Resource: " + modelLocation.toString());
                throw new RuntimeException(e);
            }
        }
        return bakedModelCache.get(modelLocation);
    }

    public void func_110549_a(IResourceManager resourceManager) {
        quadCache.clear();
        bakedModelCache.clear();
    }
}

