/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.energynet;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.render.item.IItemRenderer;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Rotation;
import codechicken.lib.vec.Vector3;
import com.brandon3055.brandonscore.blocks.BlockBCore;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRegistryOverride;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.draconicevolution.api.IHudDisplay;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalBase;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalDirectIO;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalRelay;
import com.brandon3055.draconicevolution.blocks.energynet.tileentity.TileCrystalWirelessIO;
import com.brandon3055.draconicevolution.client.render.item.RenderItemEnergyCrystal;
import com.brandon3055.draconicevolution.client.render.tile.RenderTileEnergyCrystal;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.block.material.Material;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyEnum;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.block.statemap.IStateMapper;
import net.minecraft.client.renderer.block.statemap.StateMap;
import net.minecraft.client.renderer.tileentity.TileEntitySpecialRenderer;
import net.minecraft.client.resources.I18n;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumBlockRenderType;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.IStringSerializable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.client.registry.ClientRegistry;
import net.minecraftforge.fml.common.registry.GameRegistry;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EnergyCrystal
extends BlockBCore
implements IRenderOverride,
IRegistryOverride,
IHudDisplay {
    public static final PropertyEnum<CrystalType> TYPE = PropertyEnum.func_177709_a((String)"type", CrystalType.class);
    public static final PropertyInteger TIER = PropertyInteger.func_177719_a((String)"tier", (int)0, (int)2);

    public EnergyCrystal() {
        super(Material.field_151592_s);
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a(TYPE, (Comparable)((Object)CrystalType.RELAY)).func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(0)));
        this.setHarvestLevel("pickaxe", 0);
        for (CrystalType type : CrystalType.values()) {
            for (int i = 0; i < 3; ++i) {
                this.addName(type.getIndex() * 3 + i, "energy_crystal." + type.name().toLowerCase() + "." + (i == 0 ? "basic" : (i == 1 ? "wyvern" : "draconic")));
            }
        }
    }

    public boolean uberIsBlockFullCube() {
        return false;
    }

    public void func_149666_a(Item item, CreativeTabs tab, NonNullList<ItemStack> list) {
        for (int i = 0; i < 9; ++i) {
            list.add((Object)new ItemStack(item, 1, i));
        }
    }

    public int func_180651_a(IBlockState state) {
        return this.func_176201_c(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{TYPE, TIER});
    }

    public IBlockState func_176203_a(int meta) {
        return this.func_176223_P().func_177226_a(TYPE, (Comparable)((Object)CrystalType.fromMeta(meta))).func_177226_a((IProperty)TIER, (Comparable)Integer.valueOf(CrystalType.getTier(meta)));
    }

    public int func_176201_c(IBlockState state) {
        return ((CrystalType)((Object)state.func_177229_b(TYPE))).getMeta((Integer)state.func_177229_b((IProperty)TIER));
    }

    public IBlockState func_176221_a(IBlockState state, IBlockAccess worldIn, BlockPos pos) {
        return super.func_176221_a(state, worldIn, pos);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystalRelay.class, (TileEntitySpecialRenderer)new RenderTileEnergyCrystal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystalDirectIO.class, (TileEntitySpecialRenderer)new RenderTileEnergyCrystal());
        ClientRegistry.bindTileEntitySpecialRenderer(TileCrystalWirelessIO.class, (TileEntitySpecialRenderer)new RenderTileEnergyCrystal());
        ModelRegistryHelper.registerItemRenderer((Item)Item.func_150898_a((Block)this), (IItemRenderer)new RenderItemEnergyCrystal());
        StateMap deviceStateMap = new StateMap.Builder().func_178442_a(new IProperty[]{TIER}).func_178442_a(new IProperty[]{TYPE}).func_178441_a();
        ModelLoader.setCustomStateMapper((Block)this, (IStateMapper)deviceStateMap);
    }

    public boolean registerNormal(Feature feature) {
        return false;
    }

    public EnumBlockRenderType func_149645_b(IBlockState state) {
        return EnumBlockRenderType.INVISIBLE;
    }

    public boolean hasTileEntity(IBlockState state) {
        return true;
    }

    public TileEntity createTileEntity(World world, IBlockState state) {
        return ((CrystalType)((Object)state.func_177229_b(TYPE))).createTile();
    }

    public void handleCustomRegistration(Feature feature) {
        GameRegistry.registerTileEntity(TileCrystalRelay.class, (String)(feature.getModid() + ":energy_relay"));
        GameRegistry.registerTileEntity(TileCrystalDirectIO.class, (String)(feature.getModid() + ":energy_io"));
        GameRegistry.registerTileEntity(TileCrystalWirelessIO.class, (String)(feature.getModid() + ":energy_wireless"));
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        if (state.func_177229_b(TYPE) == CrystalType.CRYSTAL_IO) {
            TileEntity tile = source.func_175625_s(pos);
            EnumFacing facing = tile instanceof TileCrystalDirectIO ? (EnumFacing)((TileCrystalDirectIO)tile).facing.value : EnumFacing.DOWN;
            Cuboid6 c = new Cuboid6(0.35, 0.0, 0.35, 0.65, 0.425, 0.65);
            c.apply(Rotation.sideRotations[facing.func_176745_a()].at(Vector3.center));
            return c.aabb();
        }
        return new AxisAlignedBB(0.375, 0.125, 0.375, 0.625, 0.875, 0.625);
    }

    public AxisAlignedBB func_180640_a(IBlockState state, World worldIn, BlockPos pos) {
        return super.func_180640_a(state, worldIn, pos);
    }

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(@Nullable ItemStack stack, World world, @Nullable BlockPos pos, List<String> displayList) {
        TileEntity te = world.func_175625_s(pos);
        if (!(te instanceof TileCrystalBase)) {
            return;
        }
        IBlockState state = world.func_180495_p(pos);
        displayList.add(InfoHelper.HITC() + I18n.func_135052_a((String)("tile.draconicevolution:" + (String)this.nameOverrides.get(((CrystalType)((Object)state.func_177229_b(TYPE))).getMeta((Integer)state.func_177229_b((IProperty)TIER))) + ".name"), (Object[])new Object[0]));
        TileCrystalBase tile = (TileCrystalBase)te;
        tile.addDisplayData(displayList);
    }

    public static enum CrystalType implements IStringSerializable
    {
        RELAY(0){

            @Override
            public TileEntity createTile() {
                return new TileCrystalRelay();
            }
        }
        ,
        CRYSTAL_IO(1){

            @Override
            public TileEntity createTile() {
                return new TileCrystalDirectIO();
            }
        }
        ,
        WIRELESS(2){

            @Override
            public TileEntity createTile() {
                return new TileCrystalWirelessIO();
            }
        };

        private final int index;

        private CrystalType(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        private static CrystalType fromIndex(int i) {
            return i == 0 ? RELAY : (i == 1 ? CRYSTAL_IO : WIRELESS);
        }

        public static CrystalType fromMeta(int meta) {
            return CrystalType.fromIndex(meta / 3);
        }

        public int getMeta(int tier) {
            return this.getIndex() * 3 + tier;
        }

        public static int getTier(int meta) {
            return meta % 3;
        }

        public String func_176610_l() {
            return this.name().toLowerCase();
        }

        public abstract TileEntity createTile();
    }
}

