/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.Vec3I;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedVec3I;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.api.fusioncrafting.ICraftingInjector;
import com.brandon3055.draconicevolution.api.fusioncrafting.IFusionCraftingInventory;
import com.brandon3055.draconicevolution.blocks.machines.CraftingInjector;
import net.minecraft.block.Block;
import net.minecraft.block.properties.IProperty;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;

public class TileCraftingInjector
extends TileInventoryBase
implements IEnergyReceiver,
ICraftingInjector {
    public final ManagedByte facing = (ManagedByte)this.register("facing", (IManagedData)new ManagedByte(0)).syncViaTile().saveToTile().trigerUpdate().finish();
    private final ManagedInt energy = (ManagedInt)this.register("energy", (IManagedData)new ManagedInt(0)).syncViaTile().saveToTile().finish();
    private final ManagedVec3I lastCorePos = (ManagedVec3I)this.register("lastCorePos", (IManagedData)new ManagedVec3I(new Vec3I(0, 0, 0))).syncViaTile().saveToTile().finish();
    public IFusionCraftingInventory currentCraftingInventory = null;
    private int chargeSpeedModifier = 300;

    public TileCraftingInjector() {
        this.setInventorySize(1);
        this.setShouldRefreshOnBlockChange();
    }

    public void updateBlock() {
        super.updateBlock();
        super.update();
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        this.validateCraftingInventory();
        if (this.currentCraftingInventory != null) {
            int maxRFPerTick = this.currentCraftingInventory.getRequiredCharge() / this.chargeSpeedModifier;
            int maxAccept = Math.min(maxReceive, Math.min(this.currentCraftingInventory.getRequiredCharge() - this.energy.value, maxRFPerTick));
            if (!simulate) {
                this.energy.value += maxAccept;
            }
            super.update();
            return maxAccept;
        }
        return 0;
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energy.value;
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return Integer.MAX_VALUE;
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return from != EnumFacing.func_82600_a((int)this.facing.value);
    }

    @Override
    public int getPedestalTier() {
        String tier = (String)((Object)this.getState((Block)DEFeatures.craftingInjector).func_177229_b((IProperty)CraftingInjector.TIER));
        return CraftingInjector.TIER.toMeta(tier);
    }

    @Override
    public ItemStack getStackInPedestal() {
        return this.func_70301_a(0);
    }

    @Override
    public void setStackInPedestal(ItemStack stack) {
        this.func_70299_a(0, stack);
    }

    @Override
    public boolean setCraftingInventory(IFusionCraftingInventory craftingInventory) {
        if (craftingInventory == null) {
            this.currentCraftingInventory = null;
            return false;
        }
        if (this.validateCraftingInventory() && !this.field_145850_b.field_72995_K) {
            return false;
        }
        this.currentCraftingInventory = craftingInventory;
        this.lastCorePos.vec = new Vec3I(((TileEntity)craftingInventory).func_174877_v());
        this.chargeSpeedModifier = 300 - this.getPedestalTier() * 80;
        return true;
    }

    @Override
    public EnumFacing getDirection() {
        return EnumFacing.func_82600_a((int)this.facing.value);
    }

    @Override
    public int getCharge() {
        return this.energy.value;
    }

    private boolean validateCraftingInventory() {
        if (!this.getStackInPedestal().func_190926_b() && this.currentCraftingInventory != null && this.currentCraftingInventory.craftingInProgress() && !((TileEntity)this.currentCraftingInventory).func_145837_r()) {
            return true;
        }
        this.currentCraftingInventory = null;
        return false;
    }

    @Override
    public void onCraft() {
        if (this.currentCraftingInventory != null) {
            this.energy.value = 0;
        }
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        TileEntity tile = this.field_145850_b.func_175625_s(this.lastCorePos.vec.getPos());
        if (tile instanceof IFusionCraftingInventory) {
            this.field_145850_b.func_175685_c(tile.func_174877_v(), tile.func_145838_q(), true);
        }
        this.updateBlock();
    }
}

