/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.utils.FacingUtils;
import com.brandon3055.brandonscore.utils.InventoryUtils;
import com.brandon3055.brandonscore.utils.Teleporter;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.DislocatorReceptacle;
import com.brandon3055.draconicevolution.blocks.Portal;
import com.brandon3055.draconicevolution.blocks.tileentity.TilePortal;
import com.brandon3055.draconicevolution.items.tools.Dislocator;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.Vec3i;

public class TileDislocatorReceptacle
extends TileInventoryBase
implements ITickable {
    public final ManagedBool ACTIVE = (ManagedBool)this.register("ACTIVE", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().trigerUpdate().finish();
    public final ManagedBool CAMO = (ManagedBool)this.register("CAMO", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().trigerUpdate().finish();
    public final ManagedBool LT_REDSTONE = (ManagedBool)this.register("LT_REDSTONE", (IManagedData)new ManagedBool(false)).saveToTile().syncViaTile().trigerUpdate().finish();
    public boolean igniting = false;
    private List<Entity> teleportQ = new ArrayList<Entity>();
    private Map<Integer, Integer> cooldownMap = new HashMap<Integer, Integer>();

    public TileDislocatorReceptacle() {
        this.setInventorySize(1);
        this.setShouldRefreshOnBlockChange();
    }

    public void func_73660_a() {
        super.update();
        for (Entity entity : this.teleportQ) {
            ItemStack stack = this.func_70301_a(0);
            if (!(stack.func_77973_b() instanceof Dislocator)) {
                this.deactivate();
                return;
            }
            Teleporter.TeleportLocation location = ((Dislocator)stack.func_77973_b()).getLocation(stack);
            if (location == null) {
                this.deactivate();
                return;
            }
            DESoundHandler.playSoundFromServer(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
            location.teleport(entity);
            DESoundHandler.playSoundFromServer(entity.field_70170_p, entity.field_70165_t, entity.field_70163_u, entity.field_70161_v, DESoundHandler.portal, SoundCategory.PLAYERS, 0.1f, entity.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.9f, false, 32.0);
        }
        try {
            ArrayList<Integer> toRemove = new ArrayList<Integer>();
            for (Integer key : this.cooldownMap.keySet()) {
                if (this.cooldownMap.get(key) > 0) {
                    this.cooldownMap.put(key, this.cooldownMap.get(key) - 1);
                    continue;
                }
                toRemove.add(key);
            }
            for (Integer i : toRemove) {
                this.cooldownMap.remove(i);
            }
            toRemove.clear();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.teleportQ.clear();
    }

    public boolean onBlockActivated(EntityPlayer player) {
        if (this.field_145850_b.field_72995_K) {
            return !this.LT_REDSTONE.value;
        }
        InventoryUtils.handleHeldStackTransfer((int)0, (IInventory)this, (EntityPlayer)player);
        return true;
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (this.func_70301_a(0).func_190926_b() && this.ACTIVE.value) {
            this.deactivate();
        } else if (!this.func_70301_a(0).func_190926_b()) {
            this.attemptIgnition();
        }
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return stack.func_77973_b() instanceof Dislocator;
    }

    public void handleEntityTeleport(Entity entity) {
        if (this.field_145850_b.field_72995_K || this.teleportQ.contains(entity) || this.cooldownMap.containsKey(entity.func_145782_y())) {
            return;
        }
        this.cooldownMap.put(entity.func_145782_y(), 10);
        this.teleportQ.add(entity);
    }

    public void deactivate() {
        this.ACTIVE.value = false;
        IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
        if (state.func_177230_c() == DEFeatures.dislocatorReceptacle) {
            this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(false)));
        }
        for (BlockPos checkPos : BlockPos.func_177980_a((BlockPos)this.field_174879_c.func_177982_a(-1, -1, -1), (BlockPos)this.field_174879_c.func_177982_a(1, 1, 1))) {
            TileEntity tile = this.field_145850_b.func_175625_s(checkPos);
            if (!(tile instanceof TilePortal) || !((TilePortal)tile).masterPos.vec.getPos().equals((Object)this.field_174879_c)) continue;
            this.field_145850_b.func_175698_g(tile.func_174877_v());
        }
        this.updateBlock();
    }

    public boolean attemptIgnition() {
        ItemStack stack = this.func_70301_a(0);
        if (!(stack.func_77973_b() instanceof Dislocator) || ((Dislocator)stack.func_77973_b()).getLocation(stack) == null) {
            return false;
        }
        PairKV<EnumFacing.Axis, List<BlockPos>> portalConfiguration = this.scanConfigurations();
        if (portalConfiguration != null) {
            this.igniting = true;
            for (BlockPos portalBlock : (List)portalConfiguration.getValue()) {
                this.field_145850_b.func_175656_a(portalBlock, DEFeatures.portal.func_176223_P().func_177226_a(Portal.AXIS, (Comparable)portalConfiguration.getKey()));
                TileEntity tile = this.field_145850_b.func_175625_s(portalBlock);
                if (!(tile instanceof TilePortal)) continue;
                ((TilePortal)tile).setMasterPos(this.field_174879_c);
            }
            this.ACTIVE.value = true;
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            if (state.func_177230_c() == DEFeatures.dislocatorReceptacle) {
                this.field_145850_b.func_175656_a(this.field_174879_c, state.func_177226_a((IProperty)DislocatorReceptacle.ACTIVE, (Comparable)Boolean.valueOf(true)));
            }
            this.updateBlock();
            this.igniting = false;
            return true;
        }
        return false;
    }

    private PairKV<EnumFacing.Axis, List<BlockPos>> scanConfigurations() {
        List<BlockPos> portalBlocks;
        ArrayList<Object> scanned = new ArrayList<BlockPos>();
        for (BlockPos offset : FacingUtils.AROUND_X) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vec3i)offset), EnumFacing.Axis.X, scanned);
            if (portalBlocks == null) continue;
            return new PairKV((Object)EnumFacing.Axis.X, portalBlocks);
        }
        scanned = new ArrayList();
        for (BlockPos offset : FacingUtils.AROUND_Y) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vec3i)offset), EnumFacing.Axis.Y, scanned);
            if (portalBlocks == null) continue;
            return new PairKV((Object)EnumFacing.Axis.Y, portalBlocks);
        }
        scanned = new ArrayList();
        for (BlockPos offset : FacingUtils.AROUND_Z) {
            portalBlocks = this.scanFromOrigin(this.field_174879_c.func_177971_a((Vec3i)offset), EnumFacing.Axis.Z, scanned);
            if (portalBlocks == null) continue;
            return new PairKV((Object)EnumFacing.Axis.Z, portalBlocks);
        }
        return null;
    }

    private List<BlockPos> scanFromOrigin(BlockPos scanOrigin, EnumFacing.Axis scanAxis, List<BlockPos> alreadyScanned) {
        if (!this.field_145850_b.func_175623_d(scanOrigin) || alreadyScanned.contains(scanOrigin)) {
            return null;
        }
        ArrayList<BlockPos> scannedBlocks = new ArrayList<BlockPos>();
        if (this.scanPortal(scanOrigin, scanOrigin, scanAxis, scannedBlocks, alreadyScanned)) {
            return scannedBlocks;
        }
        return null;
    }

    private boolean scanPortal(BlockPos scanPos, BlockPos origin, EnumFacing.Axis scanAxis, List<BlockPos> scanList, List<BlockPos> blackList) {
        Vec3D vec3D = new Vec3D(scanPos);
        Vec3D vec3D2 = new Vec3D(origin);
        if (Utils.getDistanceAtoB((Vec3D)vec3D, (Vec3D)vec3D2) > 100.0) {
            return false;
        }
        scanList.add(scanPos);
        for (EnumFacing facing : FacingUtils.getFacingsAroundAxis((EnumFacing.Axis)scanAxis)) {
            BlockPos nextPos = scanPos.func_177972_a(facing);
            if (scanList.contains(nextPos) || this.isFrame(nextPos)) continue;
            if (this.field_145850_b.func_175623_d(nextPos)) {
                if (this.scanPortal(nextPos, origin, scanAxis, scanList, blackList)) continue;
                return false;
            }
            return false;
        }
        return true;
    }

    private boolean isFrame(BlockPos pos) {
        IBlockState state = this.field_145850_b.func_180495_p(pos);
        return state.func_177230_c() == DEFeatures.infusedObsidian || state.func_177230_c() == DEFeatures.dislocatorReceptacle;
    }
}

