/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.inventory.InventoryRange;
import codechicken.lib.inventory.InventoryUtils;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.blocks.TileEnergyInventoryBase;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedDouble;
import com.brandon3055.brandonscore.lib.datamanager.ManagedEnum;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.ItemNBTHelper;
import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.blocks.DraconiumChest;
import com.brandon3055.draconicevolution.inventory.ContainerDraconiumChest;
import com.brandon3055.draconicevolution.items.ItemCore;
import com.brandon3055.draconicevolution.lib.OreDoublingRegistry;
import java.awt.Rectangle;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.crafting.FurnaceRecipes;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ITickable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;

public class TileDraconiumChest
extends TileEnergyInventoryBase
implements IEnergyReceiver,
ITickable,
ISidedInventory {
    private NonNullList<ItemStack> craftingStacks = NonNullList.func_191197_a((int)10, (Object)ItemStack.field_190927_a);
    public ManagedEnum<AutoSmeltMode> autoSmeltMode = (ManagedEnum)this.register("autoSmeltMode", (IManagedData)new ManagedEnum((Enum)AutoSmeltMode.OFF)).syncViaContainer().saveToTile().saveToItem().finish();
    public ManagedEnum<EnumFacing> facing = (ManagedEnum)this.register("facing", (IManagedData)new ManagedEnum((Enum)EnumFacing.NORTH)).saveToTile().syncViaTile().finish();
    public ManagedDouble burnRate = (ManagedDouble)this.register("burnRate", (IManagedData)new ManagedDouble(0.0)).syncViaContainer().saveToTile().saveToItem().finish();
    public ManagedDouble smeltProgress = (ManagedDouble)this.register("smeltProgress", (IManagedData)new ManagedDouble(0.0)).syncViaContainer().saveToTile().saveToItem().finish();
    public ManagedBool isSmelting = (ManagedBool)this.register("isSmelting", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().finish();
    public ManagedBool furnaceOutputBlocked = (ManagedBool)this.register("furnaceOutputBlocked", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().finish();
    public ManagedInt smeltEnergyPerTick = (ManagedInt)this.register("smeltEnergyPerTick", (IManagedData)new ManagedInt(256)).syncViaContainer().saveToTile().saveToItem().finish();
    public ManagedInt colour = (ManagedInt)this.register("colour", (IManagedData)new ManagedInt(6553750)).syncViaTile().saveToTile().saveToItem().finish();
    public ManagedShort numPlayersUsing = (ManagedShort)this.register("numPlayersUsing", (IManagedData)new ManagedShort(0)).syncViaTile().finish();
    public ManagedByte smeltTime = (ManagedByte)this.register("smeltTime", (IManagedData)new ManagedByte(100)).syncViaContainer().saveToTile().saveToItem().finish();
    public float prevLidAngle;
    public float lidAngle;
    private int ticksSinceSync;
    public static int LAST_CHEST_SLOT = 259;
    public static int FIRST_FURNACE_SLOT = 260;
    public static int LAST_FURNACE_SLOT = 264;
    public static int CAPACITOR_SLOT = 265;
    public static int CORE_SLOT = 266;
    private boolean autoFeedRun = false;
    private boolean autoFeedScheduled = false;
    public SlotRegion[] slotRegions = new SlotRegion[7];
    int itemsSmelted;
    public boolean ioCacheValid;
    private int[][] sidedSlots;
    private boolean[][] canInsert;
    private boolean[][] canExtract;
    private Set<Integer> furnaceInputs;
    private int[] furnaceOutputs;

    public TileDraconiumChest() {
        this.slotRegions[0] = new SlotRegion(0, 0xFF0000, false);
        this.slotRegions[1] = new SlotRegion(1, 65280, false);
        this.slotRegions[2] = new SlotRegion(2, 255, false);
        this.slotRegions[3] = new SlotRegion(3, 0xFFFF00, false);
        this.slotRegions[4] = new SlotRegion(4, 65535, false);
        this.slotRegions[5] = new SlotRegion(5, 0xFF00FF, false);
        this.slotRegions[6] = new SlotRegion(6, 0, true);
        this.itemsSmelted = 0;
        this.ioCacheValid = false;
        this.sidedSlots = new int[6][];
        this.canInsert = new boolean[6][260];
        this.canExtract = new boolean[6][260];
        this.furnaceInputs = new HashSet<Integer>();
        this.furnaceOutputs = new int[0];
        this.setCapacityAndTransfer(1000000, 32000, 0);
        this.setInventorySize(267);
        this.setEnergySyncMode().syncViaContainer();
    }

    public void func_73660_a() {
        super.update();
        this.autoFeedRun = false;
        if (!this.field_145850_b.field_72995_K) {
            this.updateEnergy();
            this.updateSmelting();
            if (this.autoFeedScheduled && this.attemptAutoFeed()) {
                this.validateSmelting();
            }
            this.autoFeedScheduled = false;
        }
        this.updateModel();
    }

    public void updateSmelting() {
        if (this.furnaceOutputBlocked.value) {
            this.burnRate.value = 0.0;
            return;
        }
        if (!this.isSmelting.value) {
            if (this.smeltProgress.value >= 1.0) {
                this.smeltProgress.value -= 1.0;
            }
            this.burnRate.value = 0.0;
            return;
        }
        if (this.smeltProgress.value < (double)this.smeltTime.value) {
            this.burnRate.value = this.getSmeltingSpeed();
            int energyUsage = Math.max((int)(this.burnRate.value * (double)this.smeltEnergyPerTick.value), 8);
            this.smeltProgress.value += this.burnRate.value;
            this.energyStorage.modifyEnergyStored(-energyUsage);
            return;
        }
        if (!this.smeltItems()) {
            this.furnaceOutputBlocked.value = true;
            return;
        }
        this.smeltProgress.value = 0.0;
        this.isSmelting.value = this.canSmelt();
    }

    private boolean smeltItems() {
        this.checkIOCache();
        for (int smeltPass = 0; smeltPass < 5; ++smeltPass) {
            for (int i = FIRST_FURNACE_SLOT; i <= LAST_FURNACE_SLOT; ++i) {
                ItemStack stack = this.func_70301_a(i);
                ItemStack result = this.getSmeltResult(stack);
                if (result.func_190926_b() || ((AutoSmeltMode)this.autoSmeltMode.value).keep1Item && stack.func_190916_E() <= 1) continue;
                FurnaceIORange range = new FurnaceIORange((IInventory)this, this.furnaceOutputs);
                if (InventoryUtils.insertItem((InventoryRange)range, (ItemStack)result.func_77946_l(), (boolean)true) > 0) {
                    return false;
                }
                InventoryUtils.insertItem((InventoryRange)range, (ItemStack)result.func_77946_l(), (boolean)false);
                stack.func_190918_g(1);
                if (stack.func_190916_E() <= 0) {
                    this.func_70299_a(i, ItemStack.field_190927_a);
                }
                ++this.itemsSmelted;
                if (this.itemsSmelted != 5) continue;
                this.itemsSmelted = 0;
                this.attemptAutoFeed();
                return true;
            }
        }
        this.attemptAutoFeed();
        return true;
    }

    private boolean canSmelt() {
        for (int i = FIRST_FURNACE_SLOT; i <= LAST_FURNACE_SLOT; ++i) {
            ItemStack stack = this.func_70301_a(i);
            if (this.getSmeltResult(stack).func_190926_b() || ((AutoSmeltMode)this.autoSmeltMode.value).keep1Item && stack.func_190916_E() <= 1) continue;
            return true;
        }
        return false;
    }

    public ItemStack getSmeltResult(ItemStack stack) {
        if (stack.func_190926_b()) {
            return ItemStack.field_190927_a;
        }
        if (!this.func_70301_a(CORE_SLOT).func_190926_b()) {
            return OreDoublingRegistry.getSmeltingResult(stack);
        }
        return FurnaceRecipes.func_77602_a().func_151395_a(stack);
    }

    private double getSmeltingSpeed() {
        double eCapacity = (double)this.getEnergyStored() / (double)this.getMaxEnergyStored();
        return eCapacity > 0.1 ? 1.0 : eCapacity * 10.0;
    }

    private void updateEnergy() {
        if (this.energyStorage.getEnergyStored() < this.energyStorage.getMaxEnergyStored() && EnergyHelper.canExtractEnergy((ItemStack)this.func_70301_a(CAPACITOR_SLOT))) {
            this.energyStorage.receiveEnergy(EnergyHelper.extractEnergy((ItemStack)this.func_70301_a(CAPACITOR_SLOT), (int)this.energyStorage.receiveEnergy(this.energyStorage.getMaxReceive(), true), (boolean)false), false);
        }
    }

    public void validateSmelting() {
        ItemStack stack = this.func_70301_a(CORE_SLOT);
        if (stack.func_77973_b() instanceof ItemCore) {
            if (stack.func_77973_b() == DEFeatures.wyvernCore) {
                this.smeltEnergyPerTick.value = 1024;
                this.smeltTime.value = (byte)50;
            } else if (stack.func_77973_b() == DEFeatures.awakenedCore) {
                this.smeltEnergyPerTick.value = 4069;
                this.smeltTime.value = (byte)25;
            } else if (stack.func_77973_b() == DEFeatures.chaoticCore) {
                this.smeltEnergyPerTick.value = 16384;
                this.smeltTime.value = (byte)2;
            } else {
                this.smeltEnergyPerTick.value = 256;
                this.smeltTime.value = (byte)100;
            }
        } else {
            this.smeltEnergyPerTick.value = 256;
            this.smeltTime.value = (byte)100;
        }
        this.isSmelting.value = this.canSmelt();
        this.furnaceOutputBlocked.value = false;
    }

    public void scheduleAutoFeed() {
        this.autoFeedScheduled = true;
    }

    public boolean attemptAutoFeed() {
        if (this.autoSmeltMode.value == AutoSmeltMode.OFF || this.autoFeedRun) {
            return false;
        }
        this.checkIOCache();
        this.autoFeedRun = true;
        boolean stacksInserted = false;
        block4: for (int i = 0; i < LAST_CHEST_SLOT; ++i) {
            ItemStack stack;
            if (!this.furnaceInputs.contains(i) || (stack = this.func_70301_a(i)).func_190926_b() || this.getSmeltResult(stack).func_190926_b()) continue;
            int fullStacks = 0;
            for (int f = FIRST_FURNACE_SLOT; f <= LAST_FURNACE_SLOT; ++f) {
                ItemStack stackInFernace = this.func_70301_a(f);
                switch ((AutoSmeltMode)this.autoSmeltMode.value) {
                    case FILL: 
                    case LOCK: {
                        if (!ItemStack.func_179545_c((ItemStack)stackInFernace, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)stackInFernace, (ItemStack)stack) || stackInFernace.func_190916_E() >= stackInFernace.func_77976_d()) break;
                        int count = Math.min(stack.func_190916_E(), stackInFernace.func_77976_d() - stackInFernace.func_190916_E());
                        stackInFernace.func_190917_f(count);
                        stack.func_190918_g(count);
                        stacksInserted = true;
                        break;
                    }
                    case ALL: {
                        if (stackInFernace.func_190926_b()) {
                            this.func_70299_a(f, stack.func_77946_l());
                            stack = ItemStack.field_190927_a;
                            stacksInserted = true;
                            break;
                        }
                        if (!ItemStack.func_179545_c((ItemStack)stackInFernace, (ItemStack)stack) || !ItemStack.func_77970_a((ItemStack)stackInFernace, (ItemStack)stack) || stackInFernace.func_190916_E() >= stackInFernace.func_77976_d()) break;
                        int count = Math.min(stack.func_190916_E(), stackInFernace.func_77976_d() - stackInFernace.func_190916_E());
                        stackInFernace.func_190917_f(count);
                        stack.func_190918_g(count);
                        stacksInserted = true;
                    }
                }
                stackInFernace = this.func_70301_a(f);
                if (!stackInFernace.func_190926_b() && stackInFernace.func_190916_E() == stackInFernace.func_77976_d()) {
                    ++fullStacks;
                }
                if (stack.func_190926_b() || stack.func_190916_E() == 0) {
                    this.func_70299_a(i, ItemStack.field_190927_a);
                    if (fullStacks != 5) continue block4;
                    return stacksInserted;
                }
                if (fullStacks != 5) continue;
                return stacksInserted;
            }
        }
        return stacksInserted;
    }

    public void setAutoSmeltMode(AutoSmeltMode mode) {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(output -> output.writeByte(mode.ordinal()), 0);
        }
    }

    public void setColour(int colour) {
        if (this.field_145850_b.field_72995_K) {
            this.sendPacketToServer(output -> output.writeInt(colour), 2);
        }
    }

    public void setRegionState(int region) {
        NBTTagCompound compound = new NBTTagCompound();
        if (region >= 0 && region < this.slotRegions.length) {
            compound.func_74768_a("regionID", region);
            this.slotRegions[region].toNBT(compound);
            this.sendPacketToServer(output -> output.writeNBTTagCompound(compound), 1);
        }
        this.ioCacheValid = false;
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        if (id == 0) {
            byte index = data.readByte();
            this.autoSmeltMode.value = AutoSmeltMode.values()[index];
            this.scheduleAutoFeed();
            this.validateSmelting();
        } else if (id == 1) {
            NBTTagCompound compound = data.readNBTTagCompound();
            byte region = compound.func_74771_c("regionID");
            if (region >= 0 && region < this.slotRegions.length) {
                this.slotRegions[region].fromNBT(compound);
                for (SlotRegion r : this.slotRegions) {
                    r.validate();
                }
                this.ioCacheValid = false;
                this.func_70296_d();
                this.scheduleAutoFeed();
                this.validateSmelting();
            }
        } else if (id == 2) {
            this.colour.value = data.readInt();
            this.func_70296_d();
        }
    }

    protected void writeInventoryToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.craftingStacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.craftingStacks.get(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            nbttagcompound.func_74774_a("Slot", (byte)i);
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d()) {
            compound.func_74782_a("CraftingItems", (NBTBase)nbttaglist);
        }
        super.writeInventoryToNBT(compound);
    }

    protected void readInventoryFromNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = compound.func_150295_c("CraftingItems", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.craftingStacks.size()) continue;
            this.craftingStacks.set(j, (Object)new ItemStack(nbttagcompound));
        }
        super.readInventoryFromNBT(compound);
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index >= FIRST_FURNACE_SLOT && index <= LAST_FURNACE_SLOT) {
            return !this.getSmeltResult(stack).func_190926_b();
        }
        if (index == CAPACITOR_SLOT) {
            return EnergyHelper.canExtractEnergy((ItemStack)stack);
        }
        if (index == CORE_SLOT) {
            return stack.func_77973_b() instanceof ItemCore && stack.func_77973_b() != DEFeatures.draconicCore;
        }
        return super.func_94041_b(index, stack) && DraconiumChest.isStackValid(stack);
    }

    public ItemStack getStackInCraftingSlot(int i) {
        return (ItemStack)this.craftingStacks.get(i);
    }

    public void setInventoryCraftingSlotContents(int i, @Nonnull ItemStack stack) {
        this.craftingStacks.set(i, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public void func_70299_a(int index, ItemStack stack) {
        super.func_70299_a(index, stack);
        if (index >= FIRST_FURNACE_SLOT && index <= LAST_FURNACE_SLOT || index == CORE_SLOT) {
            this.validateSmelting();
        } else if (this.furnaceOutputBlocked.value) {
            this.furnaceOutputBlocked.value = false;
        }
        this.scheduleAutoFeed();
    }

    public NBTTagCompound writeToItemStack(ItemStack stack, boolean willHarvest) {
        NBTTagCompound compound = super.writeToItemStack(stack, willHarvest);
        this.writeRegions(compound);
        ItemNBTHelper.setInteger((ItemStack)stack, (String)"ChestColour", (int)this.colour.value);
        return compound;
    }

    public NBTTagCompound readFromItemStack(ItemStack stack) {
        NBTTagCompound compound = super.readFromItemStack(stack);
        this.readRegions(compound);
        return compound;
    }

    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        this.writeRegions(compound);
    }

    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        this.readRegions(compound);
    }

    private void writeRegions(NBTTagCompound compound) {
        NBTTagCompound regionTag = new NBTTagCompound();
        for (SlotRegion region : this.slotRegions) {
            region.toNBT(regionTag);
        }
        compound.func_74782_a("RegionData", (NBTBase)regionTag);
    }

    private void readRegions(NBTTagCompound compound) {
        if (compound.func_74764_b("RegionData")) {
            NBTTagCompound regionTag = compound.func_74775_l("RegionData");
            for (SlotRegion region : this.slotRegions) {
                region.fromNBT(regionTag);
            }
        }
    }

    private void checkIOCache() {
        if (this.ioCacheValid) {
            return;
        }
        DataUtils.forEach((Object[])this.slotRegions, region -> region.controledSlots.clear());
        block0: for (int i = 0; i <= LAST_CHEST_SLOT; ++i) {
            SlotRegion[] slotRegionArray = this.slotRegions;
            int n = slotRegionArray.length;
            for (int j = 0; j < n; ++j) {
                SlotRegion region2 = slotRegionArray[j];
                if (!region2.controlsSlot(i)) continue;
                region2.controledSlots.add(i);
                continue block0;
            }
        }
        for (EnumFacing worldFace : EnumFacing.values()) {
            int faceIndex = worldFace.func_176745_a();
            EnumFacing facing = this.getRotatedFacing(worldFace);
            ArrayList<Integer> accessibleSlots = new ArrayList<Integer>();
            ArrayList<Integer> insertSlots = new ArrayList<Integer>();
            ArrayList<Integer> extractSlots = new ArrayList<Integer>();
            for (SlotRegion region3 : this.slotRegions) {
                if (!region3.isActive() || !region3.hasIO(facing)) continue;
                accessibleSlots.addAll(region3.controledSlots);
                if (region3.canExtract(facing)) {
                    extractSlots.addAll(region3.controledSlots);
                }
                if (!region3.canInsert(facing)) continue;
                insertSlots.addAll(region3.controledSlots);
            }
            this.sidedSlots[faceIndex] = DataUtils.intListToArray(accessibleSlots);
            for (int i = 0; i <= LAST_CHEST_SLOT; ++i) {
                this.canInsert[faceIndex][i] = insertSlots.contains(i);
                this.canExtract[faceIndex][i] = extractSlots.contains(i);
            }
        }
        ArrayList<Integer> furnaceInsertSlots = new ArrayList<Integer>();
        ArrayList<Integer> furnaceExtractSlots = new ArrayList<Integer>();
        for (SlotRegion region4 : this.slotRegions) {
            if (!region4.isActive() || !region4.hasIO(null)) continue;
            if (region4.canExtract(null)) {
                furnaceExtractSlots.addAll(region4.controledSlots);
            }
            if (!region4.canInsert(null)) continue;
            furnaceInsertSlots.addAll(region4.controledSlots);
        }
        this.furnaceInputs.clear();
        this.furnaceInputs.addAll(furnaceInsertSlots);
        this.furnaceOutputs = DataUtils.intListToArray(furnaceExtractSlots);
        this.ioCacheValid = true;
    }

    private EnumFacing getRotatedFacing(EnumFacing worldFacing) {
        if (worldFacing == EnumFacing.UP || worldFacing == EnumFacing.DOWN) {
            return worldFacing;
        }
        int rotate = this.facing.value == EnumFacing.NORTH ? 0 : (this.facing.value == EnumFacing.EAST ? 1 : (this.facing.value == EnumFacing.SOUTH ? 2 : 3));
        for (int i = 0; i < rotate; ++i) {
            worldFacing = worldFacing.func_176735_f();
        }
        return worldFacing;
    }

    public int[] func_180463_a(EnumFacing side) {
        this.checkIOCache();
        return this.sidedSlots[side.func_176745_a()];
    }

    public boolean func_180462_a(int index, ItemStack itemStackIn, EnumFacing direction) {
        this.checkIOCache();
        return index < 260 && this.canInsert[direction.func_176745_a()][index];
    }

    public boolean func_180461_b(int index, ItemStack stack, EnumFacing direction) {
        this.checkIOCache();
        return index < 260 && this.canExtract[direction.func_176745_a()][index];
    }

    private void updateModel() {
        int xCoord = this.field_174879_c.func_177958_n();
        int yCoord = this.field_174879_c.func_177956_o();
        int zCoord = this.field_174879_c.func_177952_p();
        ++this.ticksSinceSync;
        if (!this.field_145850_b.field_72995_K && this.numPlayersUsing.value != 0 && (this.ticksSinceSync + xCoord + yCoord + zCoord) % 200 == 0) {
            this.numPlayersUsing.value = 0;
            for (EntityPlayer entityplayer : this.field_145850_b.func_72872_a(EntityPlayer.class, new AxisAlignedBB((double)((float)xCoord - 5.0f), (double)((float)yCoord - 5.0f), (double)((float)zCoord - 5.0f), (double)((float)(xCoord + 1) + 5.0f), (double)((float)(yCoord + 1) + 5.0f), (double)((float)(zCoord + 1) + 5.0f)))) {
                TileDraconiumChest tile;
                if (!(entityplayer.field_71070_bA instanceof ContainerDraconiumChest) || (tile = (TileDraconiumChest)((ContainerDraconiumChest)entityplayer.field_71070_bA).tile) != this) continue;
                this.numPlayersUsing.value = (short)(this.numPlayersUsing.value + 1);
            }
        }
        this.prevLidAngle = this.lidAngle;
        if (this.numPlayersUsing.value > 0 && this.lidAngle == 0.0f) {
            double d1 = (double)xCoord + 0.5;
            double d2 = (double)zCoord + 0.5;
            this.field_145850_b.func_184148_a((EntityPlayer)null, d1, (double)yCoord + 0.5, d2, SoundEvents.field_187657_V, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
        }
        if (this.numPlayersUsing.value == 0 && this.lidAngle > 0.0f || this.numPlayersUsing.value > 0 && this.lidAngle < 1.0f) {
            float f2 = this.lidAngle;
            this.lidAngle = this.numPlayersUsing.value > 0 ? (this.lidAngle += 0.1f) : (this.lidAngle -= 0.1f);
            if (this.lidAngle > 1.0f) {
                this.lidAngle = 1.0f;
            }
            if (this.lidAngle < 0.5f && f2 >= 0.5f) {
                double d3 = (double)xCoord + 0.5;
                double d0 = (double)zCoord + 0.5;
                this.field_145850_b.func_184148_a((EntityPlayer)null, d3, (double)yCoord + 0.5, d0, SoundEvents.field_187651_T, SoundCategory.BLOCKS, 0.5f, this.field_145850_b.field_73012_v.nextFloat() * 0.1f + 0.9f);
            }
            if (this.lidAngle < 0.0f) {
                this.lidAngle = 0.0f;
            }
        }
    }

    public void func_174889_b(EntityPlayer player) {
        if (!player.func_175149_v()) {
            if (this.numPlayersUsing.value < 0) {
                this.numPlayersUsing.value = 0;
            }
            this.numPlayersUsing.value = (short)(this.numPlayersUsing.value + 1);
        }
    }

    public void func_174886_c(EntityPlayer player) {
        if (!player.func_175149_v()) {
            this.numPlayersUsing.value = (short)(this.numPlayersUsing.value - 1);
        }
    }

    public boolean canRenderBreaking() {
        return true;
    }

    public class FurnaceIORange
    extends InventoryRange {
        public FurnaceIORange(IInventory inv, int[] slots) {
            super(inv);
            this.slots = slots;
        }

        public boolean canExtractItem(int slot, ItemStack item) {
            return true;
        }

        public boolean canInsertItem(int slot, ItemStack item) {
            return true;
        }
    }

    public class SlotRegion {
        public int regionID;
        public int xPos = 0;
        public int yPos = 0;
        public int xSize = 0;
        public int ySize = 0;
        public boolean enabled = false;
        public boolean invalid = false;
        public int colour;
        public final boolean isDefault;
        private Rectangle rectangle = new Rectangle();
        private byte nsweIO = (byte)-1;
        private byte dufIO = (byte)-1;
        public List<Integer> controledSlots = new ArrayList<Integer>();

        public SlotRegion(int regionID, int colour, boolean isDefault) {
            this.regionID = regionID;
            this.colour = colour;
            this.isDefault = isDefault;
        }

        public void toNBT(NBTTagCompound compound) {
            if (!this.isDefault) {
                compound.func_74774_a("SR_" + this.regionID + "_xPos", (byte)this.xPos);
                compound.func_74774_a("SR_" + this.regionID + "_yPos", (byte)this.yPos);
                compound.func_74774_a("SR_" + this.regionID + "_xSize", (byte)this.xSize);
                compound.func_74774_a("SR_" + this.regionID + "_ySize", (byte)this.ySize);
                compound.func_74757_a("SR_" + this.regionID + "_Enabled", this.enabled);
                compound.func_74757_a("SR_" + this.regionID + "_Invalid", this.invalid);
            }
            compound.func_74774_a("SR_" + this.regionID + "_nsweIO", this.nsweIO);
            compound.func_74774_a("SR_" + this.regionID + "_dufIO", this.dufIO);
        }

        public void fromNBT(NBTTagCompound compound) {
            if (!this.isDefault) {
                this.xPos = compound.func_74771_c("SR_" + this.regionID + "_xPos");
                this.yPos = compound.func_74771_c("SR_" + this.regionID + "_yPos");
                this.xSize = compound.func_74771_c("SR_" + this.regionID + "_xSize");
                this.ySize = compound.func_74771_c("SR_" + this.regionID + "_ySize");
                this.enabled = compound.func_74767_n("SR_" + this.regionID + "_Enabled");
                this.invalid = compound.func_74767_n("SR_" + this.regionID + "_Invalid");
            }
            this.nsweIO = compound.func_74771_c("SR_" + this.regionID + "_nsweIO");
            this.dufIO = compound.func_74771_c("SR_" + this.regionID + "_dufIO");
            if (this.xPos < 0 || this.xPos > 25) {
                this.xPos = 0;
            }
            if (this.yPos < 0 || this.yPos > 9) {
                this.yPos = 0;
            }
            if (this.xSize < 1 || this.xSize > 26 - this.xPos) {
                this.xSize = 0;
            }
            if (this.ySize < 1 || this.ySize > 10 - this.yPos) {
                this.ySize = 0;
            }
            this.validate();
        }

        public Rectangle getRectangle() {
            if (!this.isDefault) {
                this.rectangle.setBounds(this.xPos, this.yPos, this.xSize, this.ySize);
            }
            return this.rectangle;
        }

        public boolean isValid() {
            return this.isDefault || !this.invalid && this.xSize > 0 && this.ySize > 0;
        }

        public boolean validate() {
            this.invalid = false;
            if (this.isDefault) {
                this.invalid = false;
            } else if (this.xSize <= 0 || this.ySize <= 0) {
                this.invalid = true;
            } else {
                for (SlotRegion region : TileDraconiumChest.this.slotRegions) {
                    if (region == this || !region.enabled || !region.getRectangle().intersects(this.getRectangle())) continue;
                    this.invalid = true;
                    break;
                }
            }
            return !this.invalid;
        }

        public int getFaceIO(EnumFacing facing) {
            if (facing == null) {
                return this.getFurnaceIO();
            }
            switch (facing) {
                case DOWN: {
                    return this.dufIO >> 6 & 3;
                }
                case UP: {
                    return this.dufIO >> 4 & 3;
                }
                case NORTH: {
                    return this.nsweIO >> 6 & 3;
                }
                case SOUTH: {
                    return this.nsweIO >> 4 & 3;
                }
                case WEST: {
                    return this.nsweIO >> 2 & 3;
                }
                case EAST: {
                    return this.nsweIO & 3;
                }
            }
            return 0;
        }

        public int getFurnaceIO() {
            return this.dufIO >> 2 & 3;
        }

        public void setFaceIO(EnumFacing facing, int io) {
            if (facing == null) {
                this.setFurnaceIO(io);
                return;
            }
            switch (facing) {
                case DOWN: {
                    this.dufIO = (byte)(this.dufIO & 0x3F | io << 6);
                    return;
                }
                case UP: {
                    this.dufIO = (byte)(this.dufIO & 0xCF | io << 4);
                    return;
                }
                case NORTH: {
                    this.nsweIO = (byte)(this.nsweIO & 0x3F | io << 6);
                    return;
                }
                case SOUTH: {
                    this.nsweIO = (byte)(this.nsweIO & 0xCF | io << 4);
                    return;
                }
                case WEST: {
                    this.nsweIO = (byte)(this.nsweIO & 0xF3 | io << 2);
                    return;
                }
                case EAST: {
                    this.nsweIO = (byte)(this.nsweIO & 0xFC | io);
                }
            }
        }

        public void setFurnaceIO(int io) {
            this.dufIO = (byte)(this.dufIO & 0xF3 | io << 2);
        }

        public boolean controlsSlot(int index) {
            if (this.isDefault) {
                return true;
            }
            int x = index % 26;
            int y = index / 26;
            return this.enabled && this.validate() && this.getRectangle().contains(x, y);
        }

        public boolean isActive() {
            return this.isDefault || this.enabled && this.isValid();
        }

        public boolean hasIO(EnumFacing facing) {
            return this.getFaceIO(facing) > 0;
        }

        public boolean canInsert(EnumFacing facing) {
            return (this.getFaceIO(facing) & 1) == 1;
        }

        public boolean canExtract(EnumFacing facing) {
            return (this.getFaceIO(facing) & 2) == 2;
        }
    }

    public static enum AutoSmeltMode {
        OFF(false),
        FILL(false),
        LOCK(true),
        ALL(false);

        public final boolean keep1Item;

        private AutoSmeltMode(boolean keep1Item) {
            this.keep1Item = keep1Item;
        }
    }
}

