/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.blocks.tileentity;

import codechicken.lib.data.MCDataInput;
import cofh.api.energy.IEnergyReceiver;
import com.brandon3055.brandonscore.BrandonsCore;
import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.blocks.TileEnergyBase;
import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.lib.IActivatableTile;
import com.brandon3055.brandonscore.lib.IRedstoneEmitter;
import com.brandon3055.brandonscore.lib.TileEntityFilter;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.ManagedBool;
import com.brandon3055.brandonscore.lib.datamanager.ManagedByte;
import com.brandon3055.brandonscore.lib.datamanager.ManagedShort;
import com.brandon3055.brandonscore.utils.Utils;
import com.brandon3055.draconicevolution.DraconicEvolution;
import com.brandon3055.draconicevolution.blocks.machines.EntityDetector;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.client.render.particle.ParticleStarSpark;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.nbt.NBTTagString;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ITickable;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.internal.FMLNetworkHandler;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class TileEntityDetector
extends TileEnergyBase
implements IActivatableTile,
IRedstoneEmitter,
ITickable,
IEnergyReceiver {
    public float hRot = 0.0f;
    public float yRot = 1.5707964f;
    public float lthRot = 0.0f;
    public float ltyRot = 0.0f;
    public final ManagedShort PULSE_RATE = (ManagedShort)this.register("PULSE_RATE", (IManagedData)new ManagedShort(30)).saveToTile().saveToItem().syncViaTile().finish();
    public final ManagedShort RANGE = (ManagedShort)this.register("RANGE", (IManagedData)new ManagedShort(10)).saveToTile().saveToItem().syncViaTile().finish();
    public final ManagedByte RS_MIN_DETECTION = (ManagedByte)this.register("RS_MIN_DETECTION", (IManagedData)new ManagedByte(1)).saveToTile().saveToItem().syncViaTile().finish();
    public final ManagedByte RS_MAX_DETECTION = (ManagedByte)this.register("RS_MAX_DETECTION", (IManagedData)new ManagedByte(1)).saveToTile().saveToItem().syncViaTile().finish();
    public final ManagedBool PULSE_RS_MODE = (ManagedBool)this.register("PULSE_RS_MODE", (IManagedData)new ManagedBool(false)).saveToTile().saveToItem().syncViaTile().trigerUpdate().finish();
    public final ManagedByte OUTPUT_STRENGTH = (ManagedByte)this.register("OUTPUT_STRENGTH", (IManagedData)new ManagedByte(0)).saveToTile().finish();
    private int pulseTimer = -1;
    private int pulseDuration = 0;
    public TileEntityFilter entityFilter = new TileEntityFilter((TileBCBase)this, 32){

        public boolean isListEnabled() {
            return TileEntityDetector.this.isAdvanced();
        }

        public boolean isOtherSelectorEnabled() {
            return TileEntityDetector.this.isAdvanced();
        }

        public boolean isTypeSelectionEnabled() {
            return true;
        }
    };
    public List<String> playerNames = new ArrayList<String>();
    private boolean hasCheckedAdvanced = false;
    private boolean advanced = false;
    private AxisAlignedBB AABB = new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0);

    public TileEntityDetector() {
        this.setEnergySyncMode().syncViaContainer();
        this.setCapacityAndTransfer(512000, 32000, 0);
    }

    public void func_73660_a() {
        super.update();
        if (this.field_145850_b.field_72995_K) {
            this.updateAnimation();
            return;
        }
        if (this.pulseTimer == -1) {
            this.pulseTimer = this.PULSE_RATE.value;
        } else if (this.pulseTimer > 0) {
            --this.pulseTimer;
        } else if (this.pulseTimer <= 0) {
            if (this.energyStorage.getEnergyStored() >= this.getPulseCost()) {
                this.pulseTimer = this.PULSE_RATE.value;
                this.doScanPulse();
            } else {
                this.pulseTimer = 10;
            }
        }
        if (this.OUTPUT_STRENGTH.value > 0 && this.PULSE_RS_MODE.value && this.pulseDuration <= 0) {
            this.OUTPUT_STRENGTH.value = 0;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        } else {
            --this.pulseDuration;
        }
    }

    @SideOnly(value=Side.CLIENT)
    private void updateAnimation() {
        List entities = this.entityFilter.filterEntities(this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)this.RANGE.value, (double)this.RANGE.value, (double)this.RANGE.value)));
        Entity closest = null;
        double closestDist = -1.0;
        for (Entity entity : entities) {
            if (closest == null) {
                closest = entity;
                closestDist = entity.func_174831_c(this.field_174879_c);
                continue;
            }
            if (!(entity.func_174831_c(this.field_174879_c) < closestDist)) continue;
            closest = entity;
            closestDist = entity.func_174831_c(this.field_174879_c);
        }
        this.lthRot = this.hRot;
        this.ltyRot = this.yRot;
        if (closest != null) {
            double xDist = closest.field_70165_t - (double)((float)this.func_174877_v().func_177958_n() + 0.5f);
            double zDist = closest.field_70161_v - (double)((float)this.func_174877_v().func_177952_p() + 0.5f);
            double yDist = closest.field_70163_u + (double)closest.func_70047_e() - (double)((float)this.field_174879_c.func_177956_o() + 0.5f);
            double dist = Utils.getDistanceAtoB((Vec3D)Vec3D.getCenter((BlockPos)this.field_174879_c), (Vec3D)new Vec3D(closest));
            float thRot = (float)MathHelper.func_181159_b((double)zDist, (double)xDist);
            float tyRot = (float)MathHelper.func_181159_b((double)dist, (double)yDist);
            this.hRot = thRot;
            if (this.hRot < 0.0f && (double)this.lthRot > 0.5) {
                this.hRot = (float)((double)this.hRot + Math.PI * 2);
            }
            this.yRot = tyRot;
            if ((double)(this.hRot - this.lthRot) > 0.5) {
                this.hRot = this.lthRot + 0.5f;
            } else if ((double)(this.hRot - this.lthRot) < -0.5) {
                this.hRot = this.lthRot - 0.5f;
            }
            if ((double)(this.yRot - this.ltyRot) > 0.1) {
                this.yRot = this.ltyRot + 0.1f;
            } else if ((double)(this.yRot - this.ltyRot) < -0.1) {
                this.yRot = this.ltyRot - 0.1f;
            }
        } else {
            this.hRot = (float)((double)this.hRot + 0.02);
            this.hRot %= (float)Math.PI * 2;
            if (this.hRot < 0.0f && (double)this.lthRot > 0.5) {
                this.hRot = (float)((double)this.hRot + Math.PI * 2);
            }
            if ((double)this.yRot % Math.PI > 1.5707963267948966) {
                this.yRot = (float)((double)this.yRot - 0.02);
            }
            if ((double)this.yRot % Math.PI < 1.5707963267948966) {
                this.yRot = (float)((double)this.yRot + 0.02);
            }
        }
        ParticleStarSpark spark = new ParticleStarSpark(this.field_145850_b, Vec3D.getCenter((BlockPos)this.field_174879_c).add((-0.5 + this.field_145850_b.field_73012_v.nextDouble()) * 0.1, 0.005, (-0.5 + this.field_145850_b.field_73012_v.nextDouble()) * 0.1));
        spark.setSizeAndRandMotion((double)0.4f * ((double)this.field_145850_b.field_73012_v.nextFloat() + 0.1), 0.02, 0.0, 0.02);
        spark.setMaxAge(30, 10);
        spark.setGravity(2.0E-4);
        spark.setAirResistance(0.02f);
        spark.setColour(0.0f, 1.0f, 1.0f);
        BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)spark);
        int i = this.field_145850_b.field_73012_v.nextInt(4);
        double x = i / 2;
        double z = i % 2;
        spark = new ParticleStarSpark(this.field_145850_b, new Vec3D(this.field_174879_c).add(0.14 + x * 0.72, 0.17, 0.14 + z * 0.72));
        spark.setSizeAndRandMotion((double)0.3f * ((double)this.field_145850_b.field_73012_v.nextFloat() + 0.2), 0.002, 0.0, 0.002);
        spark.setGravity(2.0E-4);
        spark.sparkSize = 0.15f;
        if (this.isAdvanced()) {
            spark.setColour(1.0f, 0.7f, 0.0f);
        } else {
            spark.setColour(0.3f, 0.0f, 1.0f);
        }
        BCEffectHandler.spawnFXDirect((ResourceLocation)DEParticles.DE_SHEET, (BCParticle)spark);
    }

    public void doScanPulse() {
        List entities = this.entityFilter.filterEntities(this.field_145850_b.func_72872_a(Entity.class, new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1)).func_72314_b((double)this.RANGE.value, (double)this.RANGE.value, (double)this.RANGE.value)));
        double min = this.RS_MIN_DETECTION.value - 1;
        double max = this.RS_MAX_DETECTION.value;
        int eCount = entities.size();
        int output = min == max ? ((double)eCount > min ? 15 : 0) : (max - min == 15.0 ? (int)Math.max(0.0, Math.min(15.0, (double)eCount - min)) : (int)Math.max(0.0, Math.min(15.0, Utils.map((double)eCount, (double)min, (double)max, (double)0.0, (double)15.0))));
        if (this.OUTPUT_STRENGTH.value != output) {
            this.OUTPUT_STRENGTH.value = (byte)output;
            this.field_145850_b.func_175685_c(this.field_174879_c, this.func_145838_q(), true);
        }
        if (this.PULSE_RS_MODE.value) {
            this.pulseDuration = 2;
        }
        this.energyStorage.modifyEnergyStored(-this.getPulseCost());
    }

    public void adjustPulseRate(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 1 : 0);
    }

    public void adjustRange(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 3 : 2);
    }

    public void adjustRSMin(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 5 : 4);
    }

    public void adjustRSMax(boolean decrement, boolean shift) {
        this.sendPacketToServer(output -> output.writeBoolean(decrement), shift ? 7 : 6);
    }

    public void togglePulsemode() {
        this.sendPacketToServer(output -> output.writeBoolean(false), 8);
    }

    public void receivePacketFromClient(MCDataInput data, EntityPlayerMP client, int id) {
        if (id <= 8) {
            boolean decrement = data.readBoolean();
            boolean shift = id % 2 == 1;
            switch (id) {
                case 0: 
                case 1: {
                    short min = this.isAdvanced() ? (short)5 : 30;
                    short max = 1200;
                    int change = shift ? 100 : 5;
                    this.PULSE_RATE.value = (short)(this.PULSE_RATE.value + (decrement ? -change : change));
                    if (this.PULSE_RATE.value < min) {
                        this.PULSE_RATE.value = min;
                    } else if (this.PULSE_RATE.value > max) {
                        this.PULSE_RATE.value = max;
                    }
                    this.pulseTimer = this.PULSE_RATE.value;
                    break;
                }
                case 2: 
                case 3: {
                    short min = 1;
                    short max = this.isAdvanced() ? (short)64 : 16;
                    int change = shift ? 5 : 1;
                    this.RANGE.value = (short)(this.RANGE.value + (decrement ? -change : change));
                    if (this.RANGE.value < min) {
                        this.RANGE.value = min;
                        break;
                    }
                    if (this.RANGE.value <= max) break;
                    this.RANGE.value = max;
                    break;
                }
                case 4: 
                case 5: {
                    int change = shift ? 5 : 1;
                    int value = this.RS_MIN_DETECTION.value + (decrement ? -change : change);
                    byte max = this.RS_MAX_DETECTION.value;
                    if (value < 0) {
                        value = 0;
                    } else if (value > max) {
                        value = max;
                    }
                    this.RS_MIN_DETECTION.value = (byte)value;
                    break;
                }
                case 6: 
                case 7: {
                    int change = shift ? 5 : 1;
                    int value = this.RS_MAX_DETECTION.value + (decrement ? -change : change);
                    byte min = this.RS_MIN_DETECTION.value;
                    if (value < min) {
                        value = min;
                    } else if (value > 127) {
                        value = 127;
                    }
                    this.RS_MAX_DETECTION.value = (byte)value;
                    break;
                }
                case 8: {
                    boolean bl = this.PULSE_RS_MODE.value = !this.PULSE_RS_MODE.value;
                }
            }
        }
        if (id == this.entityFilter.packetID) {
            this.entityFilter.receiveConfigFromClient(data.readNBTTagCompound());
        }
    }

    public boolean onBlockActivated(IBlockState state, EntityPlayer player, EnumHand hand, EnumFacing side, float hitX, float hitY, float hitZ) {
        if (!this.field_145850_b.field_72995_K) {
            FMLNetworkHandler.openGui((EntityPlayer)player, (Object)DraconicEvolution.instance, (int)6, (World)this.field_145850_b, (int)this.field_174879_c.func_177958_n(), (int)this.field_174879_c.func_177956_o(), (int)this.field_174879_c.func_177952_p());
            MinecraftServer server = BrandonsCore.proxy.getMCServer();
            if (server != null) {
                NBTTagList list = new NBTTagList();
                for (String name : server.func_184103_al().func_72369_d()) {
                    list.func_74742_a((NBTBase)new NBTTagString(name));
                }
                NBTTagCompound compound = new NBTTagCompound();
                compound.func_74782_a("List", (NBTBase)list);
                this.sendPacketToClient((EntityPlayerMP)player, output -> output.writeNBTTagCompound(compound), 16);
            }
        }
        return true;
    }

    public int getWeakPower(IBlockState blockState, EnumFacing side) {
        return this.OUTPUT_STRENGTH.value;
    }

    public int getStrongPower(IBlockState blockState, EnumFacing side) {
        return this.OUTPUT_STRENGTH.value;
    }

    public void receivePacketFromServer(MCDataInput data, int id) {
        if (id == 16) {
            NBTTagList list = data.readNBTTagCompound().func_150295_c("List", 8);
            this.playerNames.clear();
            for (int i = 0; i < list.func_74745_c(); ++i) {
                this.playerNames.add(list.func_150307_f(i));
            }
        }
    }

    public int getPulseCost() {
        return (int)(125.0 * Math.pow(this.RANGE.value, 1.5));
    }

    public boolean hasFastRenderer() {
        return false;
    }

    public boolean isAdvanced() {
        if (!this.hasCheckedAdvanced && this.field_145850_b != null) {
            IBlockState state = this.field_145850_b.func_180495_p(this.field_174879_c);
            this.advanced = (Boolean)state.func_177229_b((IProperty)EntityDetector.ADVANCED);
            this.hasCheckedAdvanced = true;
        }
        return this.advanced;
    }

    @SideOnly(value=Side.CLIENT)
    public AxisAlignedBB getRenderBoundingBox() {
        return new AxisAlignedBB(this.field_174879_c, this.field_174879_c.func_177982_a(1, 1, 1));
    }
}

