/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.draconicevolution.DEConfig;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.handlers.BowHandler;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.material.Material;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.boss.EntityDragon;
import net.minecraft.entity.boss.EntityDragonPart;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.entity.projectile.EntityArrow;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.Packet;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.network.play.server.SPacketExplosion;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EntityDamageSourceIndirect;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.Explosion;
import net.minecraft.world.World;
import net.minecraftforge.event.ForgeEventFactory;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityCustomArrow
extends EntityArrow {
    private static final DataParameter<Boolean> IS_ENERGY = EntityDataManager.func_187226_a(EntityCustomArrow.class, (DataSerializer)DataSerializers.field_187198_h);
    public BowHandler.BowProperties bowProperties = new BowHandler.BowProperties();

    public EntityCustomArrow(World worldIn) {
        super(worldIn);
    }

    public EntityCustomArrow(World worldIn, double x, double y, double z) {
        super(worldIn, x, y, z);
    }

    public EntityCustomArrow(BowHandler.BowProperties bowProperties, World worldIn, EntityLivingBase shooter) {
        super(worldIn, shooter);
        this.bowProperties = bowProperties;
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(IS_ENERGY, (Object)false);
    }

    public void func_70186_c(double par1, double par3, double par5, float par7, float par8) {
        float f2 = MathHelper.func_76133_a((double)(par1 * par1 + par3 * par3 + par5 * par5));
        par1 /= (double)f2;
        par3 /= (double)f2;
        par5 /= (double)f2;
        par1 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 7.499999832361937E-4 * (double)par8;
        par3 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 7.499999832361937E-4 * (double)par8;
        par5 += this.field_70146_Z.nextGaussian() * (double)(this.field_70146_Z.nextBoolean() ? -1 : 1) * 7.499999832361937E-4 * (double)par8;
        this.field_70159_w = par1 *= (double)par7;
        this.field_70181_x = par3 *= (double)par7;
        this.field_70179_y = par5 *= (double)par7;
        float f3 = MathHelper.func_76133_a((double)(par1 * par1 + par5 * par5));
        this.field_70126_B = this.field_70177_z = (float)(Math.atan2(par1, par5) * 180.0 / Math.PI);
        this.field_70127_C = this.field_70125_A = (float)(Math.atan2(par3, f3) * 180.0 / Math.PI);
        this.field_70252_j = 0;
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        if (this.field_70170_p.field_72995_K) {
            this.bowProperties.energyBolt = (Boolean)this.field_70180_af.func_187225_a(IS_ENERGY);
        } else {
            this.field_70180_af.func_187227_b(IS_ENERGY, (Object)this.bowProperties.energyBolt);
        }
    }

    protected ItemStack func_184550_j() {
        return new ItemStack(Items.field_151032_g);
    }

    public void func_70100_b_(EntityPlayer entityIn) {
        if (!this.field_70170_p.field_72995_K && this.field_70254_i && this.field_70249_b <= 0) {
            boolean flag;
            boolean bl = flag = this.field_70251_a == EntityArrow.PickupStatus.ALLOWED || this.field_70251_a == EntityArrow.PickupStatus.CREATIVE_ONLY && entityIn.field_71075_bZ.field_75098_d;
            if (this.field_70251_a == EntityArrow.PickupStatus.ALLOWED && !entityIn.field_71071_by.func_70441_a(this.func_184550_j())) {
                flag = false;
            }
            if (flag) {
                this.func_184185_a(SoundEvents.field_187638_cR, 0.2f, ((this.field_70146_Z.nextFloat() - this.field_70146_Z.nextFloat()) * 0.7f + 1.0f) * 2.0f);
                entityIn.func_71001_a((Entity)this, 1);
                this.func_70106_y();
            }
        }
    }

    @Nullable
    protected Entity func_184551_a(Vec3d start, Vec3d end) {
        if (this.field_70170_p.field_72995_K) {
            return null;
        }
        Entity entity = null;
        List list = this.field_70170_p.func_175674_a((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0), field_184553_f);
        double d0 = 0.0;
        for (int i = 0; i < list.size(); ++i) {
            double d1;
            AxisAlignedBB axisalignedbb;
            RayTraceResult raytraceresult;
            Entity entity1 = (Entity)list.get(i);
            if (entity1 == this.field_70250_c && this.field_70257_an < 10 || (raytraceresult = (axisalignedbb = entity1.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(start, end)) == null || !((d1 = start.func_72436_e(raytraceresult.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = entity1;
            d0 = d1;
        }
        return entity;
    }

    @SideOnly(value=Side.CLIENT)
    private void spawnArrowParticles() {
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        if (this.bowProperties != null) {
            this.bowProperties.writeToNBT(compound);
        }
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        if (this.bowProperties != null) {
            this.bowProperties.readFromNBT(compound);
        }
    }

    protected void func_184549_a(RayTraceResult traceResult) {
        if (this.bowProperties.explosionPower > 0.0f && !this.field_70170_p.field_72995_K) {
            Explosion explosion = new Explosion(this.field_70170_p, (Entity)this, this.field_70169_q, this.field_70167_r, this.field_70166_s, this.bowProperties.explosionPower, false, DEConfig.bowBlockDamage){

                public EntityLivingBase func_94613_c() {
                    return EntityCustomArrow.this.field_70250_c instanceof EntityLivingBase ? (EntityLivingBase)EntityCustomArrow.this.field_70250_c : null;
                }
            };
            if (!ForgeEventFactory.onExplosionStart((World)this.field_70170_p, (Explosion)explosion)) {
                explosion.func_77278_a();
                explosion.func_77279_a(true);
                explosion.func_180342_d();
                for (EntityPlayer entityplayer : this.field_70170_p.field_73010_i) {
                    if (!(entityplayer.func_70092_e(this.field_70169_q, this.field_70167_r, this.field_70166_s) < 4096.0)) continue;
                    ((EntityPlayerMP)entityplayer).field_71135_a.func_147359_a((Packet)new SPacketExplosion(this.field_70169_q, this.field_70167_r, this.field_70166_s, this.bowProperties.explosionPower, explosion.func_180343_e(), (Vec3d)explosion.func_77277_b().get(entityplayer)));
                }
            }
            this.func_70106_y();
        }
        if (this.bowProperties.shockWavePower > 0.0f && !this.field_70170_p.field_72995_K) {
            BCEffectHandler.spawnFX((int)DEParticles.ARROW_SHOCKWAVE, (World)this.field_70170_p, (double)this.field_70165_t, (double)this.field_70163_u, (double)this.field_70161_v, (double)0.0, (double)0.0, (double)0.0, (double)256.0, (int[])new int[]{(int)(this.bowProperties.shockWavePower * 100.0f)});
            double range = (double)this.bowProperties.shockWavePower + 5.0;
            List list = this.field_70170_p.func_72872_a(Entity.class, this.func_174813_aQ().func_72314_b(range, range, range));
            float damage = 40.0f * this.bowProperties.shockWavePower;
            for (Entity e : list) {
                if (!(e instanceof EntityLivingBase)) continue;
                Entity entity = e;
                float distanceModifier = 1.0f - entity.func_70032_d((Entity)this) / (float)range;
                if (e instanceof EntityDragon) {
                    entity = ((EntityDragon)entity).field_70987_i;
                    distanceModifier = 1.0f - entity.func_70032_d((Entity)this) / (this.bowProperties.shockWavePower * 4.0f);
                }
                if (!(distanceModifier > 0.0f)) continue;
                entity.func_70097_a(this.getDamageSource(), distanceModifier * damage);
            }
            this.func_70106_y();
        }
        if (traceResult.field_72308_g != null) {
            if (this.field_70128_L) {
                return;
            }
            float velocity = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            int actualDamage = MathHelper.func_76123_f((float)(velocity * this.bowProperties.arrowDamage));
            if (this.bowProperties.energyBolt) {
                actualDamage = (int)((float)actualDamage * 1.1f);
            }
            if (this.bowProperties.energyBolt) {
                traceResult.field_72308_g.field_70172_ad = 0;
            }
            if (traceResult.field_72308_g instanceof EntityDragonPart && ((EntityDragonPart)traceResult.field_72308_g).field_70259_a instanceof EntityDragon && this.bowProperties.energyBolt) {
                ((EntityDragon)((EntityDragonPart)traceResult.field_72308_g).field_70259_a).field_70172_ad = 0;
            }
            if (traceResult.field_72308_g.func_70097_a(this.getDamageSource(), (float)actualDamage)) {
                if (traceResult.field_72308_g instanceof EntityLivingBase) {
                    EntityLivingBase entitylivingbase = (EntityLivingBase)traceResult.field_72308_g;
                    if (!this.field_70170_p.field_72995_K) {
                        entitylivingbase.func_85034_r(entitylivingbase.func_85035_bI() + 1);
                    }
                }
                this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
                this.func_70106_y();
            }
        } else {
            BlockPos blockpos = traceResult.func_178782_a();
            this.field_145791_d = blockpos.func_177958_n();
            this.field_145792_e = blockpos.func_177956_o();
            this.field_145789_f = blockpos.func_177952_p();
            IBlockState iblockstate = this.field_70170_p.func_180495_p(blockpos);
            this.field_145790_g = iblockstate.func_177230_c();
            this.field_70253_h = this.field_145790_g.func_176201_c(iblockstate);
            this.field_70159_w = (float)(traceResult.field_72307_f.field_72450_a - this.field_70165_t);
            this.field_70181_x = (float)(traceResult.field_72307_f.field_72448_b - this.field_70163_u);
            this.field_70179_y = (float)(traceResult.field_72307_f.field_72449_c - this.field_70161_v);
            float f2 = MathHelper.func_76133_a((double)(this.field_70159_w * this.field_70159_w + this.field_70181_x * this.field_70181_x + this.field_70179_y * this.field_70179_y));
            this.field_70165_t -= this.field_70159_w / (double)f2 * (double)0.05f;
            this.field_70163_u -= this.field_70181_x / (double)f2 * (double)0.05f;
            this.field_70161_v -= this.field_70179_y / (double)f2 * (double)0.05f;
            this.func_184185_a(SoundEvents.field_187731_t, 1.0f, 1.2f / (this.field_70146_Z.nextFloat() * 0.2f + 0.9f));
            this.field_70254_i = true;
            this.field_70249_b = 7;
            this.func_70243_d(false);
            if (iblockstate.func_185904_a() != Material.field_151579_a) {
                this.field_145790_g.func_180634_a(this.field_70170_p, blockpos, iblockstate, (Entity)this);
            }
        }
    }

    private DamageSource getDamageSource() {
        if (this.bowProperties.energyBolt) {
            return new EntityDamageSourceIndirect("customArrowEnergy", (Entity)this, (Entity)(this.field_70250_c != null ? this.field_70250_c : this)).func_76349_b().func_151518_m();
        }
        return DamageSource.func_76353_a((EntityArrow)this, (Entity)(this.field_70250_c != null ? this.field_70250_c : this));
    }
}

