/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.entity;

import com.brandon3055.draconicevolution.DEFeatures;
import com.brandon3055.draconicevolution.entity.EntityChaosGuardian;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.effect.EntityLightningBolt;
import net.minecraft.entity.item.EntityFallingBlock;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHandSide;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldProviderEnd;

public class EntityGuardianCrystal
extends EntityLivingBase {
    private static final DataParameter<Integer> SHIELD_TIME = EntityDataManager.func_187226_a(EntityGuardianCrystal.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Float> HEALTH = EntityDataManager.func_187226_a(EntityGuardianCrystal.class, (DataSerializer)DataSerializers.field_187193_c);
    public int innerRotation;
    public float deathAnimation = 1.0f;
    public int shieldTime = 0;
    public EntityChaosGuardian guardian;
    private int timeTillDeath = -1;
    public float health = 50.0f;

    public EntityGuardianCrystal(World p_i1698_1_) {
        super(p_i1698_1_);
        this.field_70156_m = true;
        this.func_70105_a(2.0f, 2.0f);
        this.innerRotation = this.field_70146_Z.nextInt(100000);
        this.func_70606_j(this.func_110138_aP());
        this.field_70158_ak = true;
    }

    protected void func_110147_ax() {
        super.func_110147_ax();
        this.func_110148_a(SharedMonsterAttributes.field_111267_a).func_111128_a(50.0);
    }

    public boolean func_70041_e_() {
        return false;
    }

    public void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(SHIELD_TIME, (Object)this.shieldTime);
        this.field_70180_af.func_187214_a(HEALTH, (Object)Float.valueOf(this.health));
    }

    public void func_70071_h_() {
        BlockPos pos;
        this.field_70169_q = this.field_70165_t;
        this.field_70167_r = this.field_70163_u;
        this.field_70166_s = this.field_70161_v;
        if (!this.field_70170_p.field_72995_K) {
            this.health = this.func_110143_aJ();
            this.field_70180_af.func_187227_b(SHIELD_TIME, (Object)this.shieldTime);
            this.field_70180_af.func_187227_b(HEALTH, (Object)Float.valueOf(this.health));
        } else {
            this.shieldTime = (Integer)this.field_70180_af.func_187225_a(SHIELD_TIME);
            this.health = ((Float)this.field_70180_af.func_187225_a(HEALTH)).floatValue();
        }
        if (this.health > 0.0f) {
            if (this.shieldTime > 0) {
                --this.shieldTime;
            }
            if (this.deathAnimation < 1.0f) {
                this.deathAnimation += 0.1f;
            }
            ++this.innerRotation;
            pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            if (this.field_70170_p.field_73011_w instanceof WorldProviderEnd && this.field_70170_p.func_180495_p(pos).isSideSolid((IBlockAccess)this.field_70170_p, pos, EnumFacing.UP) && this.field_70170_p.func_180495_p(pos).func_177230_c() != Blocks.field_150480_ab) {
                this.field_70170_p.func_175656_a(pos, Blocks.field_150480_ab.func_176223_P());
            }
        } else if (this.deathAnimation > 0.0f) {
            this.deathAnimation -= 0.1f;
        }
        if (this.guardian != null && this.guardian.field_70128_L) {
            this.setDeathTimer();
        }
        if (this.timeTillDeath > 0) {
            --this.timeTillDeath;
        }
        if (this.timeTillDeath == 0 && !this.field_70170_p.field_72995_K) {
            this.field_70170_p.func_72942_c((Entity)new EntityLightningBolt(this.field_70170_p, this.field_70165_t, this.field_70163_u, this.field_70161_v, false));
            this.field_70170_p.func_72876_a((Entity)this, this.field_70165_t, this.field_70163_u + 2.0, this.field_70161_v, 20.0f, true);
            pos = new BlockPos(MathHelper.func_76128_c((double)this.field_70165_t), MathHelper.func_76128_c((double)this.field_70163_u), MathHelper.func_76128_c((double)this.field_70161_v));
            ArrayList blocks = Lists.newArrayList((Iterable)BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-5, -25, -5), (BlockPos)pos.func_177982_a(5, 5, 5)));
            for (BlockPos blockPos : blocks) {
                IBlockState state = this.field_70170_p.func_180495_p(blockPos);
                if (state.func_177230_c() != Blocks.field_150343_Z && state.func_177230_c() != DEFeatures.infusedObsidian) continue;
                EntityFallingBlock fallingBlock = new EntityFallingBlock(this.field_70170_p, (double)blockPos.func_177958_n(), (double)blockPos.func_177956_o(), (double)blockPos.func_177952_p(), state);
                fallingBlock.field_145812_b = 2;
                fallingBlock.field_145813_c = false;
                float motion = 2.0f;
                fallingBlock.field_70159_w = (this.field_70146_Z.nextFloat() - 0.5f) * motion;
                fallingBlock.field_70181_x = (this.field_70146_Z.nextFloat() - 0.5f) * motion;
                fallingBlock.field_70179_y = (this.field_70146_Z.nextFloat() - 0.5f) * motion;
                this.field_70170_p.func_175698_g(blockPos);
                this.field_70170_p.func_72838_d((Entity)fallingBlock);
            }
            this.func_70106_y();
        }
    }

    public boolean func_70089_S() {
        return !this.field_70128_L;
    }

    public void setDeathTimer() {
        if (this.timeTillDeath > 0) {
            return;
        }
        this.timeTillDeath = this.field_70146_Z.nextInt(400);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
    }

    public boolean func_70067_L() {
        return true;
    }

    public boolean func_70097_a(DamageSource source, float dmg) {
        if (this.field_70170_p.field_72995_K) {
            return false;
        }
        if (this.func_180431_b(source)) {
            return false;
        }
        if (source.func_76346_g() instanceof EntityPlayer) {
            if (this.shieldTime <= 0 && this.func_110143_aJ() > 0.0f && !this.field_70170_p.field_72995_K) {
                this.func_70606_j(this.func_110143_aJ() - Math.min(this.func_110143_aJ(), dmg));
                if (this.func_110143_aJ() <= 0.0f) {
                    this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 6.0f, false);
                } else {
                    this.shieldTime = 100 + this.field_70146_Z.nextInt(100);
                    DESoundHandler.playSoundFromServer(this.field_70170_p, this.field_70165_t + 0.5, this.field_70163_u + 0.5, this.field_70161_v + 0.5, DESoundHandler.shieldUp, SoundCategory.HOSTILE, 10.0f, this.field_70146_Z.nextFloat() * 0.1f + 1.055f, false, 128.0);
                }
                if (this.getGuardian() != null) {
                    this.getGuardian().onCrystalTargeted((EntityPlayer)source.func_76346_g(), this.func_110143_aJ() <= 0.0f);
                }
                return true;
            }
            if (this.shieldTime > 0 && !this.field_70170_p.field_72995_K) {
                this.shieldTime = 100 + this.field_70146_Z.nextInt(100);
            }
        }
        return false;
    }

    private EntityChaosGuardian getGuardian() {
        if (this.guardian == null) {
            List list = this.field_70170_p.func_72872_a(EntityChaosGuardian.class, new AxisAlignedBB(this.field_70165_t, this.field_70163_u, this.field_70161_v, this.field_70165_t, this.field_70163_u, this.field_70161_v).func_72314_b(512.0, 512.0, 512.0));
            if (list.size() > 0) {
                this.guardian = (EntityChaosGuardian)((Object)list.get(0));
            }
            if (this.guardian != null && this.guardian.crystals != null && !this.guardian.crystals.contains((Object)this)) {
                this.guardian.crystals.add(this);
                this.guardian.updateCrystals();
            }
        }
        return this.guardian;
    }

    public void revive() {
        this.func_70606_j(this.func_110138_aP());
        this.shieldTime = 50;
        this.field_70170_p.func_72876_a(null, this.field_70165_t, this.field_70163_u, this.field_70161_v, 6.0f, false);
        if (this.getGuardian() != null) {
            this.getGuardian().updateCrystals();
        }
    }

    public boolean isAlive() {
        return this.func_110143_aJ() > 0.0f;
    }

    public Iterable<ItemStack> func_184193_aE() {
        return new ArrayList<ItemStack>();
    }

    @Nullable
    public ItemStack func_184582_a(EntityEquipmentSlot slotIn) {
        return ItemStack.field_190927_a;
    }

    public void func_184201_a(EntityEquipmentSlot slotIn, @Nullable ItemStack stack) {
    }

    public EnumHandSide func_184591_cq() {
        return EnumHandSide.RIGHT;
    }

    public boolean func_184222_aU() {
        return false;
    }
}

