/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import codechicken.lib.model.ModelRegistryHelper;
import codechicken.lib.model.bakedmodels.OverrideListModel;
import com.brandon3055.brandonscore.items.ItemEnergyBase;
import com.brandon3055.brandonscore.registry.Feature;
import com.brandon3055.brandonscore.registry.IRenderOverride;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.draconicevolution.api.IHudDisplay;
import com.brandon3055.draconicevolution.api.itemconfig.IConfigurableItem;
import com.brandon3055.draconicevolution.api.itemconfig.IItemConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.api.itemupgrade.IUpgradableItem;
import com.brandon3055.draconicevolution.api.itemupgrade.UpgradeHelper;
import com.brandon3055.draconicevolution.client.model.tool.IToolModelProvider;
import com.brandon3055.draconicevolution.client.model.tool.ToolOverrideList;
import com.brandon3055.draconicevolution.entity.EntityPersistentItem;
import com.brandon3055.draconicevolution.items.tools.IAOEWeapon;
import com.google.common.collect.Multimap;
import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.block.model.ItemOverrideList;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.world.World;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public abstract class ToolBase
extends ItemEnergyBase
implements IRenderOverride,
IUpgradableItem,
IConfigurableItem,
IHudDisplay,
IToolModelProvider {
    private float baseAttackDamage;
    private float baseAttackSpeed;
    protected int energyPerOperation = 1024;

    public ToolBase(double attackDamage, double attackSpeed) {
        this.baseAttackDamage = (float)attackDamage;
        this.baseAttackSpeed = (float)attackSpeed;
        this.func_77625_d(1);
    }

    public int getItemEnchantability(ItemStack stack) {
        return 23 + this.getToolTier(stack) * 3;
    }

    public boolean func_77616_k(ItemStack stack) {
        return true;
    }

    public boolean hasCustomEntity(ItemStack stack) {
        return true;
    }

    public Entity createEntity(World world, Entity location, ItemStack itemstack) {
        return new EntityPersistentItem(world, location, itemstack);
    }

    @Override
    public int getProfileCount(ItemStack stack) {
        return 5;
    }

    @Override
    public List<String> getValidUpgrades(ItemStack stack) {
        return new ArrayList<String>(){
            {
                this.add("rfCap");
            }
        };
    }

    @Override
    public abstract int getMaxUpgradeLevel(ItemStack var1, String var2);

    public void func_77624_a(ItemStack stack, EntityPlayer playerIn, List<String> tooltip, boolean advanced) {
        ToolBase.holdCTRLForUpgrades(tooltip, stack);
        super.func_77624_a(stack, playerIn, tooltip, advanced);
    }

    public static void holdCTRLForUpgrades(List<String> list, ItemStack stack) {
        if (!(stack.func_77973_b() instanceof IUpgradableItem)) {
            return;
        }
        if (!InfoHelper.isCtrlKeyDown()) {
            list.add(I18n.func_135052_a((String)"upgrade.de.holdCtrlForUpgrades.info", (Object[])new Object[]{TextFormatting.AQUA + "" + TextFormatting.ITALIC, TextFormatting.RESET + "" + TextFormatting.GRAY}));
        } else {
            list.add(TextFormatting.GOLD + I18n.func_135052_a((String)"upgrade.de.upgrades.info", (Object[])new Object[0]));
            list.addAll(UpgradeHelper.getUpgradeStats(stack));
        }
    }

    public int getCapacity(ItemStack stack) {
        int level = UpgradeHelper.getUpgradeLevel(stack, "rfCap");
        if (level == 0) {
            return super.getCapacity(stack);
        }
        return super.getCapacity(stack) * (int)Math.pow(2.0, level + 1);
    }

    @SideOnly(value=Side.CLIENT)
    public void registerRenderer(Feature feature) {
        ModelResourceLocation modelLocation = new ModelResourceLocation("draconicevolution:" + feature.getName(), "inventory");
        ModelLoader.setCustomModelResourceLocation((Item)this, (int)0, (ModelResourceLocation)modelLocation);
        ModelLoader.setCustomMeshDefinition((Item)this, stack -> modelLocation);
        ModelRegistryHelper.register((ModelResourceLocation)modelLocation, (IBakedModel)new OverrideListModel((ItemOverrideList)new ToolOverrideList()));
    }

    public boolean onLeftClickEntity(ItemStack stack, EntityPlayer player, Entity entity) {
        if (this instanceof IAOEWeapon && player.func_184825_o(0.5f) >= 0.95f && ((IAOEWeapon)((Object)this)).getWeaponAOE(stack) > 0.0) {
            List entities = player.field_70170_p.func_72872_a(EntityLivingBase.class, entity.func_174813_aQ().func_72314_b(((IAOEWeapon)((Object)this)).getWeaponAOE(stack), 0.25, ((IAOEWeapon)((Object)this)).getWeaponAOE(stack)));
            for (EntityLivingBase aoeEntity : entities) {
                if (aoeEntity == player || aoeEntity == entity || player.func_184191_r(entity) || !this.extractAttackEnergy(stack, (Entity)aoeEntity, player)) continue;
                aoeEntity.func_70653_a((Entity)player, 0.4f, (double)MathHelper.func_76126_a((float)(player.field_70177_z * ((float)Math.PI / 180))), (double)(-MathHelper.func_76134_b((float)(player.field_70177_z * ((float)Math.PI / 180)))));
                aoeEntity.func_70097_a(DamageSource.func_76365_a((EntityPlayer)player), this.getAttackDamage(stack));
            }
            player.field_70170_p.func_184148_a(null, player.field_70165_t, player.field_70163_u, player.field_70161_v, SoundEvents.field_187730_dW, player.func_184176_by(), 1.0f, 1.0f);
            player.func_184810_cG();
        }
        this.extractAttackEnergy(stack, entity, player);
        return super.onLeftClickEntity(stack, player, entity);
    }

    protected boolean extractAttackEnergy(ItemStack stack, Entity entity, EntityPlayer player) {
        if (this.getEnergyStored(stack) > this.energyPerOperation) {
            this.modifyEnergy(stack, -this.energyPerOperation);
            return true;
        }
        return false;
    }

    public float getAttackDamage(ItemStack stack) {
        float damage = this.baseAttackDamage + (float)UpgradeHelper.getUpgradeLevel(stack, "attackDmg") * (this.baseAttackDamage / 4.0f);
        if (this.getEnergyStored(stack) < this.energyPerOperation) {
            damage /= 10.0f;
        }
        return damage;
    }

    private float getAttackSpeed(ItemStack stack) {
        return this.baseAttackSpeed;
    }

    public Multimap<String, AttributeModifier> getAttributeModifiers(EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.getAttackDamage(stack) - 1.0, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", (double)this.getAttackSpeed(stack), 0));
        }
        return multimap;
    }

    public abstract int getToolTier(ItemStack var1);

    @Override
    @SideOnly(value=Side.CLIENT)
    public void addDisplayData(@Nullable ItemStack stack, World world, @Nullable BlockPos pos, List<String> displayList) {
        ItemConfigFieldRegistry registry = new ItemConfigFieldRegistry();
        this.getFields(stack, registry);
        displayList.add(TextFormatting.DARK_PURPLE + ToolConfigHelper.getProfileName(stack, ToolConfigHelper.getProfile(stack)));
        for (IItemConfigField field : registry.getFields()) {
            displayList.add(InfoHelper.ITC() + I18n.func_135052_a((String)field.getUnlocalizedName(), (Object[])new Object[0]) + ": " + InfoHelper.HITC() + field.getReadableValue());
        }
    }
}

