/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.items.tools;

import com.brandon3055.brandonscore.client.particle.BCEffectHandler;
import com.brandon3055.brandonscore.handlers.IProcess;
import com.brandon3055.brandonscore.handlers.ProcessHandler;
import com.brandon3055.brandonscore.inventory.InventoryDynamic;
import com.brandon3055.brandonscore.lib.PairKV;
import com.brandon3055.brandonscore.lib.Vec3D;
import com.brandon3055.draconicevolution.api.itemconfig.BooleanConfigField;
import com.brandon3055.draconicevolution.api.itemconfig.ItemConfigFieldRegistry;
import com.brandon3055.draconicevolution.api.itemconfig.ToolConfigHelper;
import com.brandon3055.draconicevolution.client.DEParticles;
import com.brandon3055.draconicevolution.entity.EntityLootCore;
import com.brandon3055.draconicevolution.items.tools.CollectorCallBack;
import com.brandon3055.draconicevolution.items.tools.MiningToolBase;
import com.brandon3055.draconicevolution.items.tools.ToolStats;
import com.brandon3055.draconicevolution.items.tools.TreeCollector;
import com.brandon3055.draconicevolution.lib.DESoundHandler;
import com.brandon3055.draconicevolution.utils.DETextures;
import com.brandon3055.draconicevolution.utils.LogHelper;
import java.util.Set;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumAction;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;

public class WyvernAxe
extends MiningToolBase {
    public WyvernAxe(double attackDamage, double attackSpeed, Set effectiveBlocks) {
        super(attackDamage, attackSpeed, effectiveBlocks);
    }

    public WyvernAxe() {
        super(ToolStats.WYV_AXE_ATTACK_DAMAGE, ToolStats.WYV_AXE_ATTACK_SPEED, AXE_OVERRIDES);
        this.baseMiningSpeed = (float)ToolStats.WYV_AXE_MINING_SPEED;
        this.baseAOE = ToolStats.BASE_WYVERN_MINING_AOE;
        this.setEnergyStats(ToolStats.WYVERN_BASE_CAPACITY, 512000, 0);
        this.setHarvestLevel("axe", 10);
    }

    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 7000;
    }

    @Override
    public int getMaxUpgradeLevel(ItemStack stack, String upgrade) {
        return 2;
    }

    @Override
    public int getToolTier(ItemStack stack) {
        return 0;
    }

    @Override
    public ItemConfigFieldRegistry getFields(ItemStack stack, ItemConfigFieldRegistry registry) {
        registry.register(stack, new BooleanConfigField("showHarvestIndicator", true, "config.field.showHarvestIndicator.description"));
        return super.getFields(stack, registry);
    }

    public EnumActionResult func_180614_a(EntityPlayer player, World world, BlockPos pos, EnumHand hand, EnumFacing facing, float hitX, float hitY, float hitZ) {
        ItemStack stack = player.func_184586_b(hand);
        if (world.func_180495_p(pos).func_177230_c().isWood((IBlockAccess)world, pos) && !player.func_70093_af()) {
            player.func_184598_c(hand);
            if (!world.field_72995_K) {
                SelectionController controller = new SelectionController(player, stack, pos, true, 2, this);
                ProcessHandler.addProcess((IProcess)controller);
            }
            return EnumActionResult.PASS;
        }
        return super.func_180614_a(player, world, pos, hand, facing, hitX, hitY, hitZ);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        super.func_77615_a(stack, worldIn, entityLiving, timeLeft);
    }

    protected static boolean isTree(World world, BlockPos pos) {
        IBlockState blockState = world.func_180495_p(pos);
        if (!blockState.func_177230_c().isWood((IBlockAccess)world, pos)) {
            return false;
        }
        int treeTop = 0;
        for (int y = 0; y <= 50; ++y) {
            IBlockState state = world.func_180495_p(pos.func_177982_a(0, y, 0));
            if (state.func_177230_c().isWood((IBlockAccess)world, pos.func_177982_a(0, y, 0)) || state.func_177230_c().isLeaves(state, (IBlockAccess)world, pos.func_177982_a(0, y, 0))) continue;
            treeTop = y;
            break;
        }
        Iterable list = BlockPos.func_177980_a((BlockPos)pos.func_177982_a(-1, 0, -1), (BlockPos)pos.func_177982_a(1, treeTop, 1));
        int leaves = 0;
        for (BlockPos checkPos : list) {
            IBlockState state = world.func_180495_p(checkPos);
            if (!state.func_177230_c().isLeaves(state, (IBlockAccess)world, checkPos) || ++leaves < 3) continue;
            return true;
        }
        return false;
    }

    protected int getHarvestRange() {
        return 1;
    }

    protected int getMaxHarvest() {
        return 512;
    }

    @Override
    public PairKV<TextureAtlasSprite, ResourceLocation> getModels(ItemStack stack) {
        return new PairKV((Object)DETextures.WYVERN_AXE, (Object)new ResourceLocation("draconicevolution", "models/item/tools/wyvern_axe.obj"));
    }

    private static class SelectionController
    implements IProcess,
    CollectorCallBack {
        private final EntityPlayer player;
        private final ItemStack stack;
        private final WyvernAxe axe;
        private final EnumHand hand;
        private boolean isDead = false;
        private TreeCollector collector;
        private boolean hasFinished = false;
        private boolean showHarvest = false;

        public SelectionController(EntityPlayer player, ItemStack stack, BlockPos clicked, boolean breakDown, int connectRad, WyvernAxe axe) {
            this.player = player;
            this.stack = stack;
            this.axe = axe;
            this.collector = new TreeCollector(player.field_70170_p, breakDown, connectRad, stack, player, axe);
            this.collector.setCollectionCallback(this);
            this.collector.collectTree(clicked);
            this.hand = player.func_184600_cs();
            LogHelper.dev("StartSelector");
            this.showHarvest = ToolConfigHelper.getBooleanField("showHarvestIndicator", stack);
        }

        @Override
        public void call(BlockPos pos) {
            if (this.showHarvest) {
                BCEffectHandler.spawnFX((int)DEParticles.AXE_SELECTION, (World)this.player.field_70170_p, (Vec3D)new Vec3D(pos), (Vec3D)new Vec3D(), (double)64.0, (int[])new int[0]);
            }
        }

        public void updateProcess() {
            if (!this.player.func_70089_S() || this.player.func_184586_b(this.hand) != this.stack || this.collector.collected >= this.axe.getMaxHarvest() || this.collector.isCollectionComplete()) {
                this.collector.killCollector();
                LogHelper.dev("Finish " + this.collector.collected);
                this.finishHarvest();
                return;
            }
            if (this.player.func_184587_cr() && this.player.func_184607_cu() == this.stack) {
                return;
            }
            this.finishHarvest();
        }

        public boolean isDead() {
            return this.isDead;
        }

        private void finishHarvest() {
            if (this.hasFinished || !(this.player.field_70170_p instanceof WorldServer)) {
                return;
            }
            DESoundHandler.playSoundFromServer(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, SoundEvents.field_187604_bf, SoundCategory.PLAYERS, 1.0f, 0.9f + this.player.field_70170_p.field_73012_v.nextFloat() * 0.2f, false, 16.0);
            if (!this.collector.isCollectionComplete()) {
                this.collector.killCollector();
            }
            this.axe.modifyEnergy(this.stack, -this.collector.energyUsed);
            this.collector.energyUsed = 0;
            this.hasFinished = true;
            InventoryDynamic inventory = this.collector.getCollected();
            if (inventory.func_70302_i_() > 2) {
                EntityLootCore lootCore = new EntityLootCore(this.player.field_70170_p, inventory);
                lootCore.func_70107_b(this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v);
                this.player.field_70170_p.func_72838_d((Entity)lootCore);
            } else {
                for (int i = 0; i < inventory.func_70302_i_(); ++i) {
                    ItemStack s = inventory.func_70304_b(i);
                    if (s == null) continue;
                    EntityItem item = new EntityItem(this.player.field_70170_p, this.player.field_70165_t, this.player.field_70163_u, this.player.field_70161_v, s);
                    this.player.field_70170_p.func_72838_d((Entity)item);
                }
            }
            this.isDead = true;
        }
    }
}

