/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.data;

import codechicken.lib.data.MCDataUtils;
import java.util.UUID;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraftforge.fluids.FluidStack;

public interface MCDataInput {
    public long readLong();

    public int readInt();

    public short readShort();

    public int readUShort();

    public byte readByte();

    public short readUByte();

    public double readDouble();

    public float readFloat();

    public boolean readBoolean();

    public char readChar();

    default public int readVarShort() {
        return MCDataUtils.readVarShort(this);
    }

    default public int readVarInt() {
        return MCDataUtils.readVarInt(this);
    }

    default public long readVarLong() {
        return MCDataUtils.readVarLong(this);
    }

    public byte[] readArray(int var1);

    default public String readString() {
        return MCDataUtils.readString(this);
    }

    default public UUID readUUID() {
        return new UUID(this.readLong(), this.readLong());
    }

    default public <T extends Enum<T>> T readEnum(Class<T> enumClass) {
        return (T)((Enum[])enumClass.getEnumConstants())[this.readVarInt()];
    }

    default public EnumFacing readEnumFacing() {
        return EnumFacing.field_82609_l[this.readByte()];
    }

    default public ResourceLocation readLocation() {
        return new ResourceLocation(this.readString());
    }

    default public BlockPos readPos() {
        return new BlockPos(this.readInt(), this.readInt(), this.readInt());
    }

    default public NBTTagCompound readNBTTagCompound() {
        return MCDataUtils.readNBTTagCompound(this);
    }

    default public ItemStack readItemStack() {
        return MCDataUtils.readItemStack(this);
    }

    default public FluidStack readFluidStack() {
        return MCDataUtils.readFluidStack(this);
    }
}

