/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.util.VertexDataUtils;
import codechicken.lib.vec.Cuboid6;
import codechicken.lib.vec.Vertex5;
import codechicken.lib.vec.uv.IconTransformation;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.EnumFacing;

public class PlanarFaceBakery {
    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite) {
        return PlanarFaceBakery.bakeFace(face, sprite, DefaultVertexFormats.field_176599_b);
    }

    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite, VertexFormat format) {
        return PlanarFaceBakery.bakeFace(face, sprite, format, -1);
    }

    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite, VertexFormat format, int colour) {
        return PlanarFaceBakery.bakeFace(face, sprite, format, new ColourRGBA(colour));
    }

    public static BakedQuad bakeFace(EnumFacing face, TextureAtlasSprite sprite, VertexFormat format, Colour colour) {
        IconTransformation t = new IconTransformation(sprite);
        double x1 = Cuboid6.full.min.x;
        double x2 = Cuboid6.full.max.x;
        double y1 = Cuboid6.full.min.y;
        double y2 = Cuboid6.full.max.y;
        double z1 = Cuboid6.full.min.z;
        double z2 = Cuboid6.full.max.z;
        switch (face) {
            case DOWN: {
                double u1 = x1;
                double v1 = z1;
                double u2 = x2;
                double v2 = z2;
                Vertex5 vert1 = new Vertex5(x1, y1, z2, u1, v2);
                Vertex5 vert2 = new Vertex5(x1, y1, z1, u1, v1);
                Vertex5 vert3 = new Vertex5(x2, y1, z1, u2, v1);
                Vertex5 vert4 = new Vertex5(x2, y1, z2, u2, v2);
                return VertexDataUtils.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case UP: {
                double u1 = x1;
                double v1 = z1;
                double u2 = x2;
                double v2 = z2;
                Vertex5 vert1 = new Vertex5(x2, y2, z2, u2, v2);
                Vertex5 vert2 = new Vertex5(x2, y2, z1, u2, v1);
                Vertex5 vert3 = new Vertex5(x1, y2, z1, u1, v1);
                Vertex5 vert4 = new Vertex5(x1, y2, z2, u1, v2);
                return VertexDataUtils.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case NORTH: {
                double u1 = 1.0 - x1;
                double v1 = 1.0 - y2;
                double u2 = 1.0 - x2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x1, y1, z1, u1, v2);
                Vertex5 vert2 = new Vertex5(x1, y2, z1, u1, v1);
                Vertex5 vert3 = new Vertex5(x2, y2, z1, u2, v1);
                Vertex5 vert4 = new Vertex5(x2, y1, z1, u2, v2);
                return VertexDataUtils.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case SOUTH: {
                double u1 = x1;
                double v1 = 1.0 - y2;
                double u2 = x2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x2, y1, z2, u2, v2);
                Vertex5 vert2 = new Vertex5(x2, y2, z2, u2, v1);
                Vertex5 vert3 = new Vertex5(x1, y2, z2, u1, v1);
                Vertex5 vert4 = new Vertex5(x1, y1, z2, u1, v2);
                return VertexDataUtils.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case WEST: {
                double u1 = z1;
                double v1 = 1.0 - y2;
                double u2 = z2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x1, y1, z2, u2, v2);
                Vertex5 vert2 = new Vertex5(x1, y2, z2, u2, v1);
                Vertex5 vert3 = new Vertex5(x1, y2, z1, u1, v1);
                Vertex5 vert4 = new Vertex5(x1, y1, z1, u1, v2);
                return VertexDataUtils.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
            case EAST: {
                double u1 = 1.0 - z1;
                double v1 = 1.0 - y2;
                double u2 = 1.0 - z2;
                double v2 = 1.0 - y1;
                Vertex5 vert1 = new Vertex5(x2, y1, z1, u1, v2);
                Vertex5 vert2 = new Vertex5(x2, y2, z1, u1, v1);
                Vertex5 vert3 = new Vertex5(x2, y2, z2, u2, v1);
                Vertex5 vert4 = new Vertex5(x2, y1, z2, u2, v2);
                return VertexDataUtils.buildQuad(format, sprite, face, colour, t, vert1, vert2, vert3, vert4);
            }
        }
        return new BakedQuad(null, 1, null, null, true, null);
    }
}

