/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.model.loader.cube;

import codechicken.lib.model.BakedModelProperties;
import codechicken.lib.model.bakedmodels.PerspectiveAwareLayeredModelWrapper;
import codechicken.lib.texture.TextureUtils;
import com.google.common.base.Function;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import net.minecraft.client.renderer.block.model.IBakedModel;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.util.BlockRenderLayer;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.IModel;
import net.minecraftforge.client.model.IModelSimpleProperties;
import net.minecraftforge.client.model.IRetexturableModel;
import net.minecraftforge.client.model.ModelLoaderRegistry;
import net.minecraftforge.client.model.ModelProcessingHelper;
import net.minecraftforge.common.model.IModelState;
import net.minecraftforge.common.model.TRSRTransformation;

public class CCModelCube
implements IModel,
IRetexturableModel,
IModelSimpleProperties {
    public static String[] layerNames = new String[]{"solid", "cutout_mipped", "cutout", "translucent"};
    public static Map<String, BlockRenderLayer> nameToLayer = new HashMap<String, BlockRenderLayer>(){
        {
            this.put("solid", BlockRenderLayer.SOLID);
            this.put("cutout_mipped", BlockRenderLayer.CUTOUT_MIPPED);
            this.put("cutout", BlockRenderLayer.CUTOUT);
            this.put("translucent", BlockRenderLayer.TRANSLUCENT);
        }
    };
    public static CCModelCube INSTANCE = new CCModelCube();
    private final ImmutableMap<BlockRenderLayer, Map<EnumFacing, String>> layerFaceSpriteMap;
    private boolean isAO;
    private boolean gui3d;

    public CCModelCube() {
        this(new HashMap<BlockRenderLayer, Map<EnumFacing, String>>());
    }

    public CCModelCube(Map<BlockRenderLayer, Map<EnumFacing, String>> layerFaceSpriteMap) {
        this.layerFaceSpriteMap = ImmutableMap.copyOf(layerFaceSpriteMap);
    }

    public Collection<ResourceLocation> getDependencies() {
        return Collections.singletonList(new ResourceLocation("minecraft:block/cube"));
    }

    public Collection<ResourceLocation> getTextures() {
        ArrayList<ResourceLocation> textures = new ArrayList<ResourceLocation>();
        for (Map.Entry layerEnrty : this.layerFaceSpriteMap.entrySet()) {
            for (Map.Entry faceEntry : ((Map)layerEnrty.getValue()).entrySet()) {
                textures.add(new ResourceLocation((String)faceEntry.getValue()));
            }
        }
        return ImmutableList.copyOf(textures);
    }

    public IBakedModel bake(IModelState state, VertexFormat format, Function<ResourceLocation, TextureAtlasSprite> bakedTextureGetter) {
        HashMap<BlockRenderLayer, IBakedModel> layerModelMap = new HashMap<BlockRenderLayer, IBakedModel>();
        TextureAtlasSprite particle = TextureUtils.getMissingSprite();
        for (Map.Entry layerEntry : this.layerFaceSpriteMap.entrySet()) {
            HashMap<String, String> kvTextures = new HashMap<String, String>();
            for (Map.Entry faceEntry : ((Map)layerEntry.getValue()).entrySet()) {
                if (faceEntry.getKey() == null) {
                    kvTextures.put("particle", (String)faceEntry.getValue());
                    continue;
                }
                kvTextures.put(((EnumFacing)faceEntry.getKey()).func_176610_l(), (String)faceEntry.getValue());
            }
            IModel vanillaModel = ModelLoaderRegistry.getModelOrLogError((ResourceLocation)new ResourceLocation("minecraft:block/cube"), (String)"Unable to get vanilla model wrapper..");
            vanillaModel = ModelProcessingHelper.retexture((IModel)vanillaModel, (ImmutableMap)ImmutableMap.copyOf(CCModelCube.addMissing(kvTextures)));
            IBakedModel model = vanillaModel.bake(state, format, bakedTextureGetter);
            if (layerEntry.getKey() == BlockRenderLayer.SOLID) {
                particle = model.func_177554_e();
            }
            layerModelMap.put((BlockRenderLayer)layerEntry.getKey(), model);
        }
        return new PerspectiveAwareLayeredModelWrapper(layerModelMap, state, new BakedModelProperties(this.isAO, this.gui3d, particle));
    }

    private static Map<String, String> addMissing(Map<String, String> textures) {
        HashMap<String, String> newTextures = new HashMap<String, String>(textures);
        for (EnumFacing face : EnumFacing.field_82609_l) {
            if (textures.containsKey(face.func_176610_l())) continue;
            newTextures.put("#" + face.func_176610_l(), "");
        }
        return newTextures;
    }

    public IModelState getDefaultState() {
        return TRSRTransformation.identity();
    }

    public IModel retexture(ImmutableMap<String, String> textures) {
        HashMap<BlockRenderLayer, Map<EnumFacing, String>> layerFaceSpriteMap = new HashMap<BlockRenderLayer, Map<EnumFacing, String>>();
        for (Map.Entry entry : textures.entrySet()) {
            EnumFacing face = CCModelCube.getFaceForKey((String)entry.getKey());
            BlockRenderLayer layer = CCModelCube.getLayerForTexKey((String)entry.getKey());
            HashMap faceMap = (HashMap)layerFaceSpriteMap.get(layer);
            if (faceMap == null) {
                faceMap = new HashMap();
                layerFaceSpriteMap.put(layer, faceMap);
            }
            faceMap.put(face, entry.getValue());
        }
        return new CCModelCube(layerFaceSpriteMap);
    }

    private static BlockRenderLayer getLayerForTexKey(String key) {
        String layerName = "solid";
        for (String l : layerNames) {
            if (!key.endsWith(l)) continue;
            layerName = l;
        }
        return nameToLayer.get(layerName);
    }

    public static EnumFacing getFaceForKey(String key) {
        String faceName = key;
        if (key.contains("_")) {
            faceName = key.substring(0, key.indexOf("_"));
        }
        return EnumFacing.func_176739_a((String)faceName);
    }

    public IModel smoothLighting(boolean value) {
        this.isAO = value;
        return this;
    }

    public IModel gui3d(boolean value) {
        this.gui3d = value;
        return this;
    }
}

