/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.packet;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.ICustomPacketHandler;
import codechicken.lib.packet.IHandshakeHandler;
import com.google.common.collect.Maps;
import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.ByteBufProcessor;
import io.netty.buffer.Unpooled;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.SimpleChannelInboundHandler;
import io.netty.handler.codec.EncoderException;
import io.netty.util.AttributeKey;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.nio.channels.GatheringByteChannel;
import java.nio.channels.ScatteringByteChannel;
import java.nio.charset.Charset;
import java.util.EnumMap;
import java.util.UUID;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import net.minecraft.client.Minecraft;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.INetHandler;
import net.minecraft.network.NetHandlerPlayServer;
import net.minecraft.network.Packet;
import net.minecraft.network.PacketBuffer;
import net.minecraft.network.play.INetHandlerPlayClient;
import net.minecraft.network.play.INetHandlerPlayServer;
import net.minecraft.network.play.server.SPacketUpdateTileEntity;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.management.PlayerChunkMapEntry;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fml.common.FMLCommonHandler;
import net.minecraftforge.fml.common.ModContainer;
import net.minecraftforge.fml.common.network.FMLEmbeddedChannel;
import net.minecraftforge.fml.common.network.FMLOutboundHandler;
import net.minecraftforge.fml.common.network.NetworkHandshakeEstablished;
import net.minecraftforge.fml.common.network.NetworkRegistry;
import net.minecraftforge.fml.common.network.handshake.NetworkDispatcher;
import net.minecraftforge.fml.common.network.internal.FMLProxyPacket;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public final class PacketCustom
extends ByteBuf
implements MCDataInput,
MCDataOutput {
    public static AttributeKey<CustomInboundHandler> cclHandler = AttributeKey.valueOf((String)"ccl:handler");
    private final ByteBuf buf;
    private String channel;
    private int type;

    public static FMLEmbeddedChannel getOrCreateChannel(String channelName, Side side) {
        if (!NetworkRegistry.INSTANCE.hasChannel(channelName, side)) {
            NetworkRegistry.INSTANCE.newChannel(channelName, new ChannelHandler[]{new CustomInboundHandler()});
        }
        return NetworkRegistry.INSTANCE.getChannel(channelName, side);
    }

    public static String channelName(Object channelKey) {
        if (channelKey instanceof String) {
            return (String)channelKey;
        }
        if (channelKey instanceof ModContainer) {
            String s = ((ModContainer)channelKey).getModId();
            if (s.length() > 20) {
                throw new IllegalArgumentException("Mod ID (" + s + ") too long for use as channel (20 chars). Use a string identifier");
            }
            return s;
        }
        ModContainer mc = FMLCommonHandler.instance().findContainerFor(channelKey);
        if (mc != null) {
            return mc.getModId();
        }
        throw new IllegalArgumentException("Invalid channel: " + channelKey);
    }

    public static void assignHandler(Object channelKey, ICustomPacketHandler handler) {
        String channelName = PacketCustom.channelName(channelKey);
        Side side = handler instanceof ICustomPacketHandler.IServerPacketHandler ? Side.SERVER : Side.CLIENT;
        FMLEmbeddedChannel channel = PacketCustom.getOrCreateChannel(channelName, side);
        ((CustomInboundHandler)((Object)channel.attr(PacketCustom.cclHandler).get())).handlers.put(side, side == Side.SERVER ? new ServerInboundHandler(handler) : new ClientInboundHandler(handler));
    }

    public static void assignHandshakeHandler(Object channelKey, IHandshakeHandler handler) {
        FMLEmbeddedChannel channel = PacketCustom.getOrCreateChannel(PacketCustom.channelName(channelKey), Side.SERVER);
        channel.pipeline().addLast(new ChannelHandler[]{new HandshakeInboundHandler(handler)});
    }

    public PacketCustom(ByteBuf payload) {
        this.buf = payload;
        this.type = this.readUnsignedByte();
        if (this.type > 128) {
            this.decompress();
        }
        this.type &= 0x7F;
    }

    public PacketCustom(Object channelKey, int type) {
        this.buf = Unpooled.buffer();
        if (type <= 0 || type >= 128) {
            throw new IllegalArgumentException("Packet type: " + type + " is not within required 0 < t < 0x80");
        }
        this.channel = PacketCustom.channelName(channelKey);
        this.type = type;
        this.writeByte(type);
    }

    private void decompress() {
        Inflater inflater = new Inflater();
        try {
            int len = this.readVarInt();
            byte[] out = new byte[len];
            inflater.setInput(this.array(), this.readerIndex(), this.readableBytes());
            inflater.inflate(out);
            this.clear();
            this.writeArray(out);
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            inflater.end();
        }
    }

    private void do_compress() {
        Deflater deflater = new Deflater();
        try {
            this.readerIndex(1);
            int len = this.readableBytes();
            deflater.setInput(this.array(), this.readerIndex(), len);
            deflater.finish();
            byte[] out = new byte[len];
            int clen = deflater.deflate(out);
            if (clen >= len - 5 || !deflater.finished()) {
                return;
            }
            this.clear();
            this.writeByte(this.type | 0x80);
            this.writeVarInt(len);
            this.writeArray(out);
        }
        catch (Exception e) {
            throw new EncoderException((Throwable)e);
        }
        finally {
            this.readerIndex(0);
            deflater.end();
        }
    }

    public boolean incoming() {
        return this.channel == null;
    }

    public int getType() {
        return this.type & 0x7F;
    }

    public PacketCustom compress() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to compress an incoming packet");
        }
        if ((this.type & 0x80) != 0) {
            throw new IllegalStateException("Packet already compressed");
        }
        this.type |= 0x80;
        return this;
    }

    public FMLProxyPacket toPacket() {
        if (this.incoming()) {
            throw new IllegalStateException("Tried to write an incoming packet");
        }
        if (this.readableBytes() > 32000 || (this.type & 0x80) != 0) {
            this.do_compress();
        }
        return new FMLProxyPacket(new PacketBuffer(this.copy()), this.channel);
    }

    public PacketBuffer toPacketBuffer() {
        return new PacketBuffer((ByteBuf)this);
    }

    public NBTTagCompound toNBTTag(NBTTagCompound tagCompound) {
        tagCompound.func_74773_a("CCL:data", this.array());
        return tagCompound;
    }

    public NBTTagCompound toNBTTag() {
        NBTTagCompound tagCompound = new NBTTagCompound();
        tagCompound.func_74773_a("CCL:data", this.array());
        return tagCompound;
    }

    public static PacketCustom fromNBTTag(NBTTagCompound tagCompound) {
        return new PacketCustom(Unpooled.copiedBuffer((byte[])tagCompound.func_74770_j("CCL:data")));
    }

    public SPacketUpdateTileEntity toTilePacket(BlockPos pos) {
        return new SPacketUpdateTileEntity(pos, 0, this.toNBTTag());
    }

    @SideOnly(value=Side.CLIENT)
    public static PacketCustom fromTilePacket(SPacketUpdateTileEntity tilePacket) {
        return PacketCustom.fromNBTTag(tilePacket.func_148857_g());
    }

    public void sendToPlayer(EntityPlayer player) {
        PacketCustom.sendToPlayer((Packet)this.toPacket(), player);
    }

    public static void sendToPlayer(Packet packet, EntityPlayer player) {
        if (player == null) {
            PacketCustom.sendToClients(packet);
        } else {
            ((EntityPlayerMP)player).field_71135_a.func_147359_a(packet);
        }
    }

    public void sendToClients() {
        PacketCustom.sendToClients((Packet)this.toPacket());
    }

    public static void sendToClients(Packet packet) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148540_a(packet);
    }

    public void sendPacketToAllAround(BlockPos pos, double range, int dim) {
        this.sendPacketToAllAround(pos.func_177958_n(), pos.func_177956_o(), pos.func_177952_p(), range, dim);
    }

    public void sendPacketToAllAround(double x, double y, double z, double range, int dim) {
        PacketCustom.sendToAllAround((Packet)this.toPacket(), x, y, z, range, dim);
    }

    public static void sendToAllAround(Packet packet, double x, double y, double z, double range, int dim) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148543_a(null, x, y, z, range, dim, packet);
    }

    public void sendToDimension(int dim) {
        PacketCustom.sendToDimension((Packet)this.toPacket(), dim);
    }

    public static void sendToDimension(Packet packet, int dim) {
        FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_148537_a(packet, dim);
    }

    public void sendToChunk(TileEntity tile) {
        this.sendToChunk(tile.func_145831_w(), tile.func_174877_v().func_177958_n() >> 4, tile.func_174877_v().func_177952_p() >> 4);
    }

    public void sendToChunk(World world, int chunkX, int chunkZ) {
        PacketCustom.sendToChunk((Packet)this.toPacket(), world, chunkX, chunkZ);
    }

    public static void sendToChunk(Packet packet, World world, int chunkX, int chunkZ) {
        PlayerChunkMapEntry playerInstance = ((WorldServer)world).func_184164_w().func_187301_b(chunkX, chunkZ);
        if (playerInstance != null) {
            playerInstance.func_187267_a(packet);
        }
    }

    public void sendToOps() {
        PacketCustom.sendToOps((Packet)this.toPacket());
    }

    public static void sendToOps(Packet packet) {
        for (EntityPlayerMP player : FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_181057_v()) {
            if (!FMLCommonHandler.instance().getMinecraftServerInstance().func_184103_al().func_152596_g(player.func_146103_bH())) continue;
            PacketCustom.sendToPlayer(packet, (EntityPlayer)player);
        }
    }

    @SideOnly(value=Side.CLIENT)
    public void sendToServer() {
        PacketCustom.sendToServer((Packet)this.toPacket());
    }

    @SideOnly(value=Side.CLIENT)
    public static void sendToServer(Packet packet) {
        Minecraft.func_71410_x().func_147114_u().func_147297_a(packet);
    }

    @Override
    public PacketCustom writeBoolean(boolean b) {
        this.buf.writeBoolean(b);
        return this;
    }

    @Override
    public PacketCustom writeByte(int b) {
        this.buf.writeByte(b);
        return this;
    }

    @Override
    public PacketCustom writeShort(int s) {
        this.buf.writeShort(s);
        return this;
    }

    @Override
    public PacketCustom writeInt(int i) {
        this.buf.writeInt(i);
        return this;
    }

    @Override
    public PacketCustom writeFloat(float f) {
        this.buf.writeFloat(f);
        return this;
    }

    @Override
    public PacketCustom writeDouble(double d) {
        this.buf.writeDouble(d);
        return this;
    }

    @Override
    public PacketCustom writeLong(long l) {
        this.buf.writeLong(l);
        return this;
    }

    @Override
    public PacketCustom writeChar(char c) {
        this.buf.writeChar((int)c);
        return this;
    }

    @Override
    public PacketCustom writeVarInt(int i) {
        MCDataOutput.super.writeVarInt(i);
        return this;
    }

    @Override
    public PacketCustom writeVarShort(int s) {
        MCDataOutput.super.writeVarShort(s);
        return this;
    }

    @Override
    public PacketCustom writeVarLong(long l) {
        MCDataOutput.super.writeVarLong(l);
        return this;
    }

    @Override
    public PacketCustom writeArray(byte[] barray) {
        this.buf.writeBytes(barray);
        return this;
    }

    @Override
    public PacketCustom writeString(String s) {
        MCDataOutput.super.writeString(s);
        return this;
    }

    @Override
    public PacketCustom writeUUID(UUID uuid) {
        MCDataOutput.super.writeUUID(uuid);
        return this;
    }

    @Override
    public PacketCustom writeEnum(Enum<?> value) {
        MCDataOutput.super.writeEnum(value);
        return this;
    }

    @Override
    public PacketCustom writeResourceLocation(ResourceLocation location) {
        MCDataOutput.super.writeResourceLocation(location);
        return this;
    }

    @Override
    public PacketCustom writePos(BlockPos pos) {
        MCDataOutput.super.writePos(pos);
        return this;
    }

    @Override
    public PacketCustom writeNBTTagCompound(NBTTagCompound tag) {
        MCDataOutput.super.writeNBTTagCompound(tag);
        return this;
    }

    @Override
    public PacketCustom writeItemStack(ItemStack stack) {
        MCDataOutput.super.writeItemStack(stack);
        return this;
    }

    @Override
    public PacketCustom writeFluidStack(FluidStack liquid) {
        MCDataOutput.super.writeFluidStack(liquid);
        return this;
    }

    @Override
    public short readUByte() {
        return this.buf.readUnsignedByte();
    }

    @Override
    public double readDouble() {
        return this.buf.readDouble();
    }

    @Override
    public float readFloat() {
        return this.buf.readFloat();
    }

    @Override
    public boolean readBoolean() {
        return this.buf.readBoolean();
    }

    @Override
    public char readChar() {
        return this.buf.readChar();
    }

    @Override
    public long readLong() {
        return this.buf.readLong();
    }

    @Override
    public int readInt() {
        return this.buf.readInt();
    }

    @Override
    public short readShort() {
        return this.buf.readShort();
    }

    @Override
    public int readUShort() {
        return this.buf.readUnsignedShort();
    }

    @Override
    public byte readByte() {
        return this.buf.readByte();
    }

    @Override
    public byte[] readArray(int length) {
        return this.buf.readBytes(length).array();
    }

    public boolean hasMemoryAddress() {
        return this.buf.hasMemoryAddress();
    }

    public long memoryAddress() {
        return this.buf.memoryAddress();
    }

    public int capacity() {
        return this.buf.capacity();
    }

    public PacketCustom capacity(int newCapacity) {
        this.buf.capacity(newCapacity);
        return this;
    }

    public int maxCapacity() {
        return this.buf.maxCapacity();
    }

    public ByteBufAllocator alloc() {
        return this.buf.alloc();
    }

    public ByteOrder order() {
        return this.buf.order();
    }

    public ByteBuf order(ByteOrder endianness) {
        return this.buf.order(endianness);
    }

    public ByteBuf unwrap() {
        return this.buf;
    }

    public boolean isDirect() {
        return this.buf.isDirect();
    }

    public int readerIndex() {
        return this.buf.readerIndex();
    }

    public ByteBuf readerIndex(int readerIndex) {
        this.buf.readerIndex(readerIndex);
        return this;
    }

    public int writerIndex() {
        return this.buf.writerIndex();
    }

    public PacketCustom writerIndex(int writerIndex) {
        this.buf.writerIndex(writerIndex);
        return this;
    }

    public PacketCustom setIndex(int readerIndex, int writerIndex) {
        this.buf.setIndex(readerIndex, writerIndex);
        return this;
    }

    public int readableBytes() {
        return this.buf.readableBytes();
    }

    public int writableBytes() {
        return this.buf.writableBytes();
    }

    public int maxWritableBytes() {
        return this.buf.maxWritableBytes();
    }

    public boolean isReadable() {
        return this.buf.isReadable();
    }

    public boolean isWritable() {
        return this.buf.isWritable();
    }

    public PacketCustom clear() {
        this.buf.clear();
        return this;
    }

    public PacketCustom markReaderIndex() {
        this.buf.markReaderIndex();
        return this;
    }

    public PacketCustom resetReaderIndex() {
        this.buf.resetReaderIndex();
        return this;
    }

    public PacketCustom markWriterIndex() {
        this.buf.markWriterIndex();
        return this;
    }

    public PacketCustom resetWriterIndex() {
        this.buf.resetWriterIndex();
        return this;
    }

    public PacketCustom discardReadBytes() {
        this.buf.discardReadBytes();
        return this;
    }

    public PacketCustom discardSomeReadBytes() {
        this.buf.discardSomeReadBytes();
        return this;
    }

    public PacketCustom ensureWritable(int minWritableBytes) {
        this.buf.ensureWritable(minWritableBytes);
        return this;
    }

    public int ensureWritable(int minWritableBytes, boolean force) {
        return this.buf.ensureWritable(minWritableBytes, force);
    }

    public boolean getBoolean(int index) {
        return this.buf.getBoolean(index);
    }

    public byte getByte(int index) {
        return this.buf.getByte(index);
    }

    public short getUnsignedByte(int index) {
        return this.buf.getUnsignedByte(index);
    }

    public short getShort(int index) {
        return this.buf.getShort(index);
    }

    public int getUnsignedShort(int index) {
        return this.buf.getUnsignedShort(index);
    }

    public int getMedium(int index) {
        return this.buf.getMedium(index);
    }

    public int getUnsignedMedium(int index) {
        return this.buf.getUnsignedMedium(index);
    }

    public int getInt(int index) {
        return this.buf.getInt(index);
    }

    public long getUnsignedInt(int index) {
        return this.buf.getUnsignedInt(index);
    }

    public long getLong(int index) {
        return this.buf.getLong(index);
    }

    public char getChar(int index) {
        return this.buf.getChar(index);
    }

    public float getFloat(int index) {
        return this.buf.getFloat(index);
    }

    public double getDouble(int index) {
        return this.buf.getDouble(index);
    }

    public PacketCustom getBytes(int index, ByteBuf dst) {
        this.buf.getBytes(index, dst);
        return this;
    }

    public PacketCustom getBytes(int index, ByteBuf dst, int length) {
        this.buf.getBytes(index, dst, length);
        return this;
    }

    public PacketCustom getBytes(int index, ByteBuf dst, int dstIndex, int length) {
        this.buf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public PacketCustom getBytes(int index, byte[] dst) {
        this.buf.getBytes(index, dst);
        return this;
    }

    public PacketCustom getBytes(int index, byte[] dst, int dstIndex, int length) {
        this.buf.getBytes(index, dst, dstIndex, length);
        return this;
    }

    public PacketCustom getBytes(int index, ByteBuffer dst) {
        this.buf.getBytes(index, dst);
        return this;
    }

    public PacketCustom getBytes(int index, OutputStream out, int length) throws IOException {
        this.buf.getBytes(index, out, length);
        return this;
    }

    public int getBytes(int index, GatheringByteChannel out, int length) throws IOException {
        return this.buf.getBytes(index, out, length);
    }

    public PacketCustom setBoolean(int index, boolean value) {
        this.buf.setBoolean(index, value);
        return this;
    }

    public PacketCustom setByte(int index, int value) {
        this.buf.setByte(index, value);
        return this;
    }

    public PacketCustom setShort(int index, int value) {
        this.buf.setShort(index, value);
        return this;
    }

    public PacketCustom setMedium(int index, int value) {
        this.buf.setMedium(index, value);
        return this;
    }

    public PacketCustom setInt(int index, int value) {
        this.buf.setInt(index, value);
        return this;
    }

    public PacketCustom setLong(int index, long value) {
        this.buf.setLong(index, value);
        return this;
    }

    public PacketCustom setChar(int index, int value) {
        this.buf.setChar(index, value);
        return this;
    }

    public PacketCustom setFloat(int index, float value) {
        this.buf.setFloat(index, value);
        return this;
    }

    public PacketCustom setDouble(int index, double value) {
        this.buf.setDouble(index, value);
        return this;
    }

    public PacketCustom setBytes(int index, ByteBuf src) {
        this.buf.setBytes(index, src);
        return this;
    }

    public PacketCustom setBytes(int index, ByteBuf src, int length) {
        this.buf.setBytes(index, src, length);
        return this;
    }

    public PacketCustom setBytes(int index, ByteBuf src, int srcIndex, int length) {
        this.buf.setBytes(index, src, srcIndex, length);
        return this;
    }

    public PacketCustom setBytes(int index, byte[] src) {
        this.buf.setBytes(index, src);
        return this;
    }

    public PacketCustom setBytes(int index, byte[] src, int srcIndex, int length) {
        this.buf.setBytes(index, src, srcIndex, length);
        return this;
    }

    public PacketCustom setBytes(int index, ByteBuffer src) {
        this.buf.setBytes(index, src);
        return this;
    }

    public int setBytes(int index, InputStream in, int length) throws IOException {
        return this.buf.setBytes(index, in, length);
    }

    public int setBytes(int index, ScatteringByteChannel in, int length) throws IOException {
        return this.buf.setBytes(index, in, length);
    }

    public PacketCustom setZero(int index, int length) {
        this.buf.setZero(index, length);
        return this;
    }

    public short readUnsignedByte() {
        return this.buf.readUnsignedByte();
    }

    public int readUnsignedShort() {
        return this.buf.readUnsignedShort();
    }

    public int readMedium() {
        return this.buf.readMedium();
    }

    public int readUnsignedMedium() {
        return this.buf.readUnsignedMedium();
    }

    public long readUnsignedInt() {
        return this.buf.readUnsignedInt();
    }

    public ByteBuf readBytes(int length) {
        return this.buf.readBytes(length);
    }

    public ByteBuf readSlice(int length) {
        return this.buf.readSlice(length);
    }

    public PacketCustom readBytes(ByteBuf dst) {
        this.buf.readBytes(dst);
        return this;
    }

    public PacketCustom readBytes(ByteBuf dst, int length) {
        this.buf.readBytes(dst, length);
        return this;
    }

    public PacketCustom readBytes(ByteBuf dst, int dstIndex, int length) {
        this.buf.readBytes(dst, dstIndex, length);
        return this;
    }

    public PacketCustom readBytes(byte[] dst) {
        this.buf.readBytes(dst);
        return this;
    }

    public PacketCustom readBytes(byte[] dst, int dstIndex, int length) {
        this.buf.readBytes(dst, dstIndex, length);
        return this;
    }

    public PacketCustom readBytes(ByteBuffer dst) {
        this.buf.readBytes(dst);
        return this;
    }

    public PacketCustom readBytes(OutputStream out, int length) throws IOException {
        this.buf.readBytes(out, length);
        return this;
    }

    public int readBytes(GatheringByteChannel out, int length) throws IOException {
        return this.buf.readBytes(out, length);
    }

    public PacketCustom skipBytes(int length) {
        this.buf.skipBytes(length);
        return this;
    }

    public PacketCustom writeMedium(int value) {
        this.buf.writeMedium(value);
        return this;
    }

    public PacketCustom writeChar(int value) {
        this.buf.writeChar(value);
        return this;
    }

    public PacketCustom writeBytes(ByteBuf src) {
        this.buf.writeBytes(src);
        return this;
    }

    public PacketCustom writeBytes(ByteBuf src, int length) {
        this.buf.writeBytes(src, length);
        return this;
    }

    public PacketCustom writeBytes(ByteBuf src, int srcIndex, int length) {
        this.buf.writeBytes(src, srcIndex, length);
        return this;
    }

    public PacketCustom writeBytes(byte[] src) {
        this.buf.writeBytes(src);
        return this;
    }

    public PacketCustom writeBytes(byte[] src, int srcIndex, int length) {
        this.buf.writeBytes(src, srcIndex, length);
        return this;
    }

    public PacketCustom writeBytes(ByteBuffer src) {
        this.buf.writeBytes(src);
        return this;
    }

    public int writeBytes(InputStream in, int length) throws IOException {
        return this.buf.writeBytes(in, length);
    }

    public int writeBytes(ScatteringByteChannel in, int length) throws IOException {
        return this.buf.writeBytes(in, length);
    }

    public PacketCustom writeZero(int length) {
        this.buf.writeZero(length);
        return this;
    }

    public int indexOf(int fromIndex, int toIndex, byte value) {
        return this.buf.indexOf(fromIndex, toIndex, value);
    }

    public int bytesBefore(byte value) {
        return this.buf.bytesBefore(value);
    }

    public int bytesBefore(int length, byte value) {
        return this.buf.bytesBefore(length, value);
    }

    public int bytesBefore(int index, int length, byte value) {
        return this.buf.bytesBefore(index, length, value);
    }

    public int forEachByte(ByteBufProcessor processor) {
        return this.buf.forEachByte(processor);
    }

    public int forEachByte(int index, int length, ByteBufProcessor processor) {
        return this.buf.forEachByte(index, length, processor);
    }

    public int forEachByteDesc(ByteBufProcessor processor) {
        return this.buf.forEachByteDesc(processor);
    }

    public int forEachByteDesc(int index, int length, ByteBufProcessor processor) {
        return this.buf.forEachByteDesc(index, length, processor);
    }

    public ByteBuf copy() {
        return this.buf.copy();
    }

    public ByteBuf copy(int index, int length) {
        return this.buf.copy(index, length);
    }

    public ByteBuf slice() {
        return this.buf.slice();
    }

    public ByteBuf slice(int index, int length) {
        return this.buf.slice(index, length);
    }

    public ByteBuf duplicate() {
        return this.buf.duplicate();
    }

    public int nioBufferCount() {
        return this.buf.nioBufferCount();
    }

    public ByteBuffer nioBuffer() {
        return this.buf.nioBuffer();
    }

    public ByteBuffer nioBuffer(int index, int length) {
        return this.buf.nioBuffer(index, length);
    }

    public ByteBuffer[] nioBuffers() {
        return this.buf.nioBuffers();
    }

    public ByteBuffer[] nioBuffers(int index, int length) {
        return this.buf.nioBuffers(index, length);
    }

    public ByteBuffer internalNioBuffer(int index, int length) {
        return this.buf.internalNioBuffer(index, length);
    }

    public boolean hasArray() {
        return this.buf.hasArray();
    }

    public byte[] array() {
        return this.buf.array();
    }

    public int arrayOffset() {
        return this.buf.arrayOffset();
    }

    public String toString(Charset charset) {
        return this.buf.toString(charset);
    }

    public String toString(int index, int length, Charset charset) {
        return this.buf.toString(index, length, charset);
    }

    public int hashCode() {
        return this.buf.hashCode();
    }

    public boolean equals(Object obj) {
        return this.buf.equals(obj);
    }

    public int compareTo(ByteBuf buffer) {
        return this.buf.compareTo(buffer);
    }

    public String toString() {
        return String.format("%s{ %s }", this.getClass().getName(), this.buf.toString());
    }

    public PacketCustom retain(int increment) {
        this.buf.retain(increment);
        return this;
    }

    public PacketCustom retain() {
        this.buf.retain();
        return this;
    }

    public boolean isReadable(int size) {
        return this.buf.isReadable(size);
    }

    public boolean isWritable(int size) {
        return this.buf.isWritable(size);
    }

    public int refCnt() {
        return this.buf.refCnt();
    }

    public boolean release() {
        return this.buf.release();
    }

    public boolean release(int decrement) {
        return this.buf.release(decrement);
    }

    public static class HandshakeInboundHandler
    extends ChannelInboundHandlerAdapter {
        public IHandshakeHandler handler;

        public HandshakeInboundHandler(IHandshakeHandler handler) {
            this.handler = handler;
        }

        public void userEventTriggered(ChannelHandlerContext ctx, Object evt) throws Exception {
            if (evt instanceof NetworkHandshakeEstablished) {
                INetHandler netHandler = ((NetworkDispatcher)ctx.channel().attr(FMLOutboundHandler.FML_MESSAGETARGETARGS).get()).getNetHandler();
                if (netHandler instanceof NetHandlerPlayServer) {
                    this.handler.handshakeReceived((NetHandlerPlayServer)netHandler);
                }
            } else {
                ctx.fireUserEventTriggered(evt);
            }
        }
    }

    public static class ServerInboundHandler
    implements CustomHandler {
        private ICustomPacketHandler.IServerPacketHandler handler;

        public ServerInboundHandler(ICustomPacketHandler handler) {
            this.handler = (ICustomPacketHandler.IServerPacketHandler)handler;
        }

        @Override
        public void handle(INetHandler netHandler, String channel, PacketCustom packet) {
            if (netHandler instanceof NetHandlerPlayServer) {
                MinecraftServer mc = FMLCommonHandler.instance().getMinecraftServerInstance();
                if (!mc.func_152345_ab()) {
                    mc.func_152344_a(() -> this.handle(netHandler, channel, packet));
                } else {
                    this.handler.handlePacket(packet, ((NetHandlerPlayServer)netHandler).field_147369_b, (INetHandlerPlayServer)netHandler);
                }
            } else {
                System.err.println("Invalid INetHandler for PacketCustom on channel: " + channel);
            }
        }
    }

    public static class ClientInboundHandler
    implements CustomHandler {
        private ICustomPacketHandler.IClientPacketHandler handler;

        public ClientInboundHandler(ICustomPacketHandler handler) {
            this.handler = (ICustomPacketHandler.IClientPacketHandler)handler;
        }

        @Override
        public void handle(INetHandler netHandler, String channel, PacketCustom packet) {
            if (netHandler instanceof INetHandlerPlayClient) {
                Minecraft mc = Minecraft.func_71410_x();
                if (!mc.func_152345_ab()) {
                    mc.func_152344_a(() -> this.handle(netHandler, channel, packet));
                } else {
                    this.handler.handlePacket(packet, mc, (INetHandlerPlayClient)netHandler);
                }
            } else {
                System.err.println("Invalid INetHandler for PacketCustom on channel: " + channel);
            }
        }
    }

    private static interface CustomHandler {
        public void handle(INetHandler var1, String var2, PacketCustom var3);
    }

    @ChannelHandler.Sharable
    public static class CustomInboundHandler
    extends SimpleChannelInboundHandler<FMLProxyPacket> {
        public EnumMap<Side, CustomHandler> handlers = Maps.newEnumMap(Side.class);

        public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
            super.handlerAdded(ctx);
            ctx.channel().attr(cclHandler).set((Object)this);
        }

        protected void channelRead0(ChannelHandlerContext ctx, FMLProxyPacket msg) throws Exception {
            this.handlers.get(ctx.channel().attr(NetworkRegistry.CHANNEL_SOURCE).get()).handle((INetHandler)ctx.channel().attr(NetworkRegistry.NET_HANDLER).get(), (String)ctx.channel().attr(NetworkRegistry.FML_CHANNEL).get(), new PacketCustom(msg.payload()));
        }
    }
}

