/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.buffer;

import codechicken.lib.colour.Colour;
import codechicken.lib.colour.ColourRGBA;
import codechicken.lib.vec.Vector3;
import codechicken.lib.vec.uv.UV;
import java.nio.ByteBuffer;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.VertexFormat;
import net.minecraft.client.renderer.vertex.VertexFormatElement;

public class VertexBufferllator
extends VertexBuffer {
    private final VertexBuffer wrapped;
    private final UV uv = new UV();
    private final int[] lmap = new int[2];
    private final Colour colour = new ColourRGBA(-1);
    private final Vector3 pos = new Vector3();
    private final Vector3 normal = new Vector3();

    public VertexBufferllator(VertexBuffer buffer) {
        super(1);
        this.wrapped = buffer;
    }

    public void func_181675_d() {
        VertexFormat format = this.func_178973_g();
        block7: for (int e = 0; e < format.func_177345_h(); ++e) {
            VertexFormatElement fmte = format.func_177348_c(e);
            switch (fmte.func_177375_c()) {
                case POSITION: {
                    this.wrapped.func_181662_b(this.pos.x, this.pos.y, this.pos.z);
                    continue block7;
                }
                case UV: {
                    if (fmte.func_177369_e() == 0) {
                        this.wrapped.func_187315_a(this.uv.u, this.uv.v);
                        continue block7;
                    }
                    this.wrapped.func_187314_a(this.lmap[0], this.lmap[1]);
                    continue block7;
                }
                case COLOR: {
                    if (this.wrapped.isColorDisabled()) {
                        this.wrapped.func_181667_k();
                        continue block7;
                    }
                    this.wrapped.func_181669_b(this.colour.r & 0xFF, this.colour.g & 0xFF, this.colour.b & 0xFF, this.colour.a & 0xFF);
                    continue block7;
                }
                case NORMAL: {
                    this.wrapped.func_181663_c((float)this.normal.x, (float)this.normal.y, (float)this.normal.z);
                    continue block7;
                }
                case PADDING: {
                    continue block7;
                }
                default: {
                    throw new UnsupportedOperationException("Generic vertex format element");
                }
            }
        }
        this.wrapped.func_181675_d();
    }

    public VertexBufferllator pos(double x, double y, double z) {
        this.pos.set(x, y, z);
        return this;
    }

    public VertexBufferllator tex(double u, double v) {
        this.uv.set(u, v);
        return this;
    }

    public VertexBuffer func_181663_c(float x, float y, float z) {
        this.normal.set(x, y, z);
        return this;
    }

    public VertexBufferllator lightmap(int p_187314_1_, int p_187314_2_) {
        this.lmap[0] = p_187314_1_;
        this.lmap[1] = p_187314_2_;
        return this;
    }

    public VertexBufferllator color(float red, float green, float blue, float alpha) {
        this.colour.set(red, green, blue, alpha);
        return this;
    }

    public VertexBufferllator color(int red, int green, int blue, int alpha) {
        this.colour.set(red, green, blue, alpha);
        return this;
    }

    public void func_181674_a(float p_181674_1_, float p_181674_2_, float p_181674_3_) {
        this.wrapped.func_181674_a(p_181674_1_, p_181674_2_, p_181674_3_);
    }

    public VertexBuffer.State func_181672_a() {
        return this.wrapped.func_181672_a();
    }

    public void func_178993_a(VertexBuffer.State state) {
        this.wrapped.func_178993_a(state);
    }

    public void func_181668_a(int glMode, VertexFormat format) {
        this.wrapped.func_181668_a(glMode, format);
    }

    public void func_178962_a(int p_178962_1_, int p_178962_2_, int p_178962_3_, int p_178962_4_) {
        this.wrapped.func_178962_a(p_178962_1_, p_178962_2_, p_178962_3_, p_178962_4_);
    }

    public void func_178987_a(double x, double y, double z) {
        this.wrapped.func_178987_a(x, y, z);
    }

    public int func_78909_a(int vertexIndex) {
        return this.wrapped.func_78909_a(vertexIndex);
    }

    public void func_178978_a(float red, float green, float blue, int vertexIndex) {
        this.wrapped.func_178978_a(red, green, blue, vertexIndex);
    }

    public void func_178994_b(float red, float green, float blue, int vertexIndex) {
        this.wrapped.func_178994_b(red, green, blue, vertexIndex);
    }

    public void func_178972_a(int index, int red, int green, int blue, int alpha) {
        this.wrapped.func_178972_a(index, red, green, blue, alpha);
    }

    public void func_78914_f() {
        this.wrapped.func_78914_f();
    }

    public void func_178981_a(int[] vertexData) {
        this.wrapped.func_178981_a(vertexData);
    }

    public void func_178975_e(float x, float y, float z) {
        this.wrapped.func_178975_e(x, y, z);
    }

    public void func_181667_k() {
        this.wrapped.func_181667_k();
    }

    public void func_178969_c(double x, double y, double z) {
        this.wrapped.func_178969_c(x, y, z);
    }

    public void func_178977_d() {
        this.wrapped.func_178977_d();
    }

    public ByteBuffer func_178966_f() {
        return this.wrapped.func_178966_f();
    }

    public VertexFormat func_178973_g() {
        return this.wrapped.func_178973_g();
    }

    public int func_178989_h() {
        return this.wrapped.func_178989_h();
    }

    public int func_178979_i() {
        return this.wrapped.func_178979_i();
    }

    public void func_178968_d(int argb) {
        this.wrapped.func_178968_d(argb);
    }

    public void func_178990_f(float red, float green, float blue) {
        this.wrapped.func_178990_f(red, green, blue);
    }

    public boolean isColorDisabled() {
        return this.wrapped.isColorDisabled();
    }
}

