/*
 * Decompiled with CFR 0.152.
 */
package codechicken.lib.render.state;

import com.google.common.base.Objects;
import java.util.ArrayList;
import java.util.LinkedList;
import net.minecraft.client.renderer.GlStateManager;

public class GlStateTracker {
    private static final LinkedList<SavedState> savedStates = new LinkedList();

    private static String parseBoolState(GlStateManager.BooleanState boolState) {
        return String.valueOf(boolState.field_179201_b).toUpperCase();
    }

    public static String dumpGLState(State ... states) {
        StringBuilder builder = new StringBuilder();
        builder.append("GlStateManager { ");
        for (int i = 0; i < states.length; ++i) {
            State state = states[i];
            builder.append(state.getState());
            if (i == states.length - 1) continue;
            builder.append(", ");
        }
        builder.append(" }");
        return builder.toString();
    }

    public static void pushState() {
        SavedState state = SavedState.createSavedState(State.values());
        savedStates.addLast(state);
    }

    public static void pushStates(State ... states) {
        if (states == null || states.length == 0) {
            states = State.values();
        }
        SavedState state = SavedState.createSavedState(states);
        savedStates.addLast(state);
    }

    public static void pushState(State[] states) {
        if (states == null || states.length == 0) {
            states = State.values();
        }
        SavedState state = SavedState.createSavedState(states);
        savedStates.addLast(state);
    }

    public static void popState() {
        if (savedStates.isEmpty()) {
            throw new IllegalStateException("Unable to pop the GL state as there is no saved state!");
        }
        SavedState pre = savedStates.removeLast();
        SavedState post = SavedState.createSavedState(pre);
        SavedState.applyState(pre, post);
    }

    public static class SavedState {
        private ArrayList<State> savedStates = new ArrayList();
        boolean alphaTest;
        int alphaFunc;
        float alphaRef;
        boolean lighting;
        boolean blend;
        int blendSrcFactor;
        int blendDstFactor;
        int blendSrcFactorAlpha;
        int blendDstFactorAlpha;
        boolean depthTest;
        boolean depthMaskEnabled;
        int depthFunc;
        boolean cull;
        int cullMode;
        boolean rescaleNormal;

        private SavedState() {
        }

        private static SavedState createSavedState(SavedState state) {
            return SavedState.createSavedState(state.savedStates.toArray(new State[state.savedStates.size()]));
        }

        private static SavedState createSavedState(State ... states) {
            SavedState saveState = new SavedState();
            for (State state : states) {
                state.pushState(saveState);
                saveState.savedStates.add(state);
            }
            return saveState;
        }

        private static void applyState(SavedState pre, SavedState post) {
            for (State state : pre.savedStates) {
                state.popState(pre, post);
            }
        }
    }

    public static enum State {
        GL_ALPHA_TEST{

            @Override
            public String getState() {
                GlStateManager.AlphaState alphaState = GlStateManager.field_179160_a;
                return Objects.toStringHelper((String)this.name()).add("Func", alphaState.field_179206_b).add("Ref", alphaState.field_179207_c).add("Enabled", (Object)String.valueOf(alphaState.field_179208_a.field_179201_b).toUpperCase()).toString();
            }

            @Override
            public void pushState(SavedState state) {
                state.alphaTest = GlStateManager.field_179160_a.field_179208_a.field_179201_b;
                state.alphaFunc = GlStateManager.field_179160_a.field_179206_b;
                state.alphaRef = GlStateManager.field_179160_a.field_179207_c;
            }

            @Override
            public void popState(SavedState pre, SavedState post) {
                if (pre.alphaTest) {
                    GlStateManager.func_179141_d();
                } else {
                    GlStateManager.func_179118_c();
                }
                GlStateManager.func_179092_a((int)pre.alphaFunc, (float)pre.alphaRef);
            }
        }
        ,
        GL_LIGHTING{

            @Override
            public String getState() {
                return Objects.toStringHelper((String)this.name()).add("Enabled", (Object)GlStateTracker.parseBoolState(GlStateManager.field_179158_b)).toString();
            }

            @Override
            public void pushState(SavedState state) {
                state.lighting = GlStateManager.field_179158_b.field_179201_b;
            }

            @Override
            public void popState(SavedState pre, SavedState post) {
                if (pre.lighting) {
                    GlStateManager.func_179145_e();
                } else {
                    GlStateManager.func_179140_f();
                }
            }
        }
        ,
        GL_BLEND{

            @Override
            public String getState() {
                GlStateManager.BlendState blendState = GlStateManager.field_179157_e;
                return Objects.toStringHelper((String)this.name()).add("SrcFactor", (Object)this.parseFactor(blendState.field_179211_b)).add("DstFactor", (Object)this.parseFactor(blendState.field_179212_c)).add("SrcFactorAlpha", (Object)this.parseFactor(blendState.field_179209_d)).add("DstFactorAlpha", (Object)this.parseFactor(blendState.field_179210_e)).add("Enabled", (Object)GlStateTracker.parseBoolState(blendState.field_179213_a)).toString();
            }

            @Override
            public void pushState(SavedState state) {
                state.blend = GlStateManager.field_179157_e.field_179213_a.field_179201_b;
                state.blendSrcFactor = GlStateManager.field_179157_e.field_179211_b;
                state.blendDstFactor = GlStateManager.field_179157_e.field_179212_c;
                state.blendSrcFactorAlpha = GlStateManager.field_179157_e.field_179209_d;
                state.blendDstFactorAlpha = GlStateManager.field_179157_e.field_179210_e;
            }

            @Override
            public void popState(SavedState pre, SavedState post) {
                if (pre.blend) {
                    GlStateManager.func_179147_l();
                } else {
                    GlStateManager.func_179084_k();
                }
                if (pre.blendSrcFactorAlpha != post.blendSrcFactorAlpha || pre.blendDstFactorAlpha != post.blendDstFactorAlpha) {
                    GlStateManager.func_179120_a((int)pre.blendSrcFactor, (int)pre.blendDstFactor, (int)pre.blendSrcFactorAlpha, (int)pre.blendDstFactorAlpha);
                } else {
                    GlStateManager.func_179112_b((int)pre.blendSrcFactor, (int)post.blendDstFactor);
                }
            }

            private String parseFactor(int factor) {
                switch (factor) {
                    case 32771: {
                        return "CONSTANT_ALPHA";
                    }
                    case 32769: {
                        return "CONSTANT_COLOR";
                    }
                    case 772: {
                        return "DST_ALPHA";
                    }
                    case 774: {
                        return "DST_COLOR";
                    }
                    case 1: {
                        return "ONE";
                    }
                    case 32772: {
                        return "ONE_MINUS_CONSTANT_ALPHA";
                    }
                    case 32770: {
                        return "ONE_MINUS_CONSTANT_COLOR";
                    }
                    case 773: {
                        return "ONE_MINUS_DST_ALPHA";
                    }
                    case 775: {
                        return "ONE_MINUS_DST_COLOR";
                    }
                    case 771: {
                        return "ONE_MINUS_SRC_ALPHA";
                    }
                    case 769: {
                        return "ONE_MINUS_SRC_COLOR";
                    }
                    case 770: {
                        return "SRC_ALPHA";
                    }
                    case 776: {
                        return "SRC_ALPHA_SATURATE";
                    }
                    case 768: {
                        return "SRC_COLOR";
                    }
                    case 0: {
                        return "ZERO";
                    }
                }
                return "UNKNOWN:" + factor;
            }
        }
        ,
        GL_DEPTH_TEST{

            @Override
            public String getState() {
                GlStateManager.DepthState depthState = GlStateManager.field_179154_f;
                return Objects.toStringHelper((String)this.name()).add("Func", (Object)this.parseFunc(depthState.field_179051_c)).add("Mask", (Object)String.valueOf(depthState.field_179050_b).toUpperCase()).add("Enabled", (Object)GlStateTracker.parseBoolState(depthState.field_179052_a)).toString();
            }

            @Override
            public void pushState(SavedState state) {
                state.depthTest = GlStateManager.field_179154_f.field_179052_a.field_179201_b;
                state.depthMaskEnabled = GlStateManager.field_179154_f.field_179050_b;
                state.depthFunc = GlStateManager.field_179154_f.field_179051_c;
            }

            @Override
            public void popState(SavedState pre, SavedState post) {
                if (pre.depthTest) {
                    GlStateManager.func_179126_j();
                } else {
                    GlStateManager.func_179097_i();
                }
                GlStateManager.func_179132_a((boolean)pre.depthMaskEnabled);
                GlStateManager.func_179143_c((int)pre.depthFunc);
            }

            private String parseFunc(int func) {
                switch (func) {
                    case 512: {
                        return "GL_NEVER";
                    }
                    case 513: {
                        return "GL_LESS";
                    }
                    case 514: {
                        return "GL_EQUAL";
                    }
                    case 515: {
                        return "GL_LEQUAL";
                    }
                    case 516: {
                        return "GL_GREATER";
                    }
                    case 517: {
                        return "GL_NOTEQUAL";
                    }
                    case 518: {
                        return "GL_GEQUAL";
                    }
                    case 519: {
                        return "GL_ALWAYS";
                    }
                }
                return "UNKNOWN:" + func;
            }
        }
        ,
        GL_CULL_FACE{

            @Override
            public String getState() {
                GlStateManager.CullState cullState = GlStateManager.field_179167_h;
                return Objects.toStringHelper((String)this.name()).add("Mode", (Object)this.parseMode(cullState.field_179053_b)).add("Enabled", (Object)GlStateTracker.parseBoolState(cullState.field_179054_a)).toString();
            }

            @Override
            public void pushState(SavedState state) {
                state.cull = GlStateManager.field_179167_h.field_179054_a.field_179201_b;
                state.cullMode = GlStateManager.field_179167_h.field_179053_b;
            }

            @Override
            public void popState(SavedState pre, SavedState post) {
                if (pre.cull) {
                    GlStateManager.func_179089_o();
                } else {
                    GlStateManager.func_179129_p();
                }
                GlStateManager.func_179107_e((int)pre.cullMode);
            }

            private String parseMode(int mode) {
                switch (mode) {
                    case 1028: {
                        return "FRONT";
                    }
                    case 1029: {
                        return "BACK";
                    }
                    case 1032: {
                        return "FRONT_AND_BACK";
                    }
                }
                return "UNKNOWN:" + mode;
            }
        }
        ,
        GL_RESCALE_NORMAL{

            @Override
            public String getState() {
                return Objects.toStringHelper((String)this.name()).add("Enabled", (Object)GlStateTracker.parseBoolState(GlStateManager.field_179172_r)).toString();
            }

            @Override
            public void pushState(SavedState state) {
                state.rescaleNormal = GlStateManager.field_179172_r.field_179201_b;
            }

            @Override
            public void popState(SavedState pre, SavedState post) {
                if (pre.rescaleNormal) {
                    GlStateManager.func_179091_B();
                } else {
                    GlStateManager.func_179101_C();
                }
            }
        };


        public abstract String getState();

        public abstract void pushState(SavedState var1);

        public abstract void popState(SavedState var1, SavedState var2);
    }
}

