/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import cofh.api.energy.EnergyStorage;
import com.brandon3055.brandonscore.blocks.TileInventoryBase;
import com.brandon3055.brandonscore.lib.EnergyHandlerWrapper;
import com.brandon3055.brandonscore.lib.EnergyHelper;
import com.brandon3055.brandonscore.lib.datamanager.ManagedInt;
import com.brandon3055.brandonscore.lib.datamanager.TileDataOptions;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockAccess;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.energy.CapabilityEnergy;

public class TileEnergyInventoryBase
extends TileInventoryBase {
    public ManagedInt energySync = null;
    public EnergyStorage energyStorage = new EnergyStorage(0, 0, 0);

    @Override
    public void update() {
        super.update();
        if (this.energySync != null) {
            if (this.field_145850_b.field_72995_K) {
                this.energyStorage.setEnergyStored(this.energySync.value);
            } else {
                this.energySync.value = this.energyStorage.getEnergyStored();
            }
        }
    }

    public TileDataOptions<ManagedInt> setEnergySyncMode() {
        TileDataOptions<ManagedInt> options = this.dataManager.register("anInt", new ManagedInt(0));
        this.energySync = options.finish();
        return options;
    }

    protected void setCapacityAndTransfer(int capacity, int receive, int extract) {
        this.energyStorage.setCapacity(capacity);
        this.energyStorage.setMaxReceive(receive);
        this.energyStorage.setMaxExtract(extract);
    }

    public int getEnergyStored(EnumFacing from) {
        return this.energyStorage.getEnergyStored();
    }

    public int getMaxEnergyStored(EnumFacing from) {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int extractEnergy(EnumFacing from, int maxExtract, boolean simulate) {
        return this.energyStorage.extractEnergy(maxExtract, simulate);
    }

    public int receiveEnergy(EnumFacing from, int maxReceive, boolean simulate) {
        return this.energyStorage.receiveEnergy(maxReceive, simulate);
    }

    public boolean canConnectEnergy(EnumFacing from) {
        return true;
    }

    @Override
    public NBTTagCompound writeToItemStack(ItemStack stack, boolean willHarvest) {
        NBTTagCompound dataTag = super.writeToItemStack(stack, willHarvest);
        this.energyStorage.writeToNBT(dataTag);
        return dataTag;
    }

    @Override
    public NBTTagCompound readFromItemStack(ItemStack stack) {
        NBTTagCompound dataTag = super.readFromItemStack(stack);
        this.energyStorage.readFromNBT(dataTag);
        return dataTag;
    }

    @Override
    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        this.energyStorage.writeToNBT(compound);
    }

    @Override
    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        this.energyStorage.readFromNBT(compound);
    }

    protected int getEnergyStored() {
        return this.energyStorage.getEnergyStored();
    }

    protected int getMaxEnergyStored() {
        return this.energyStorage.getMaxEnergyStored();
    }

    public int sendEnergyToAll() {
        if (this.getEnergyStored() == 0) {
            return 0;
        }
        int i = 0;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            i += this.sendEnergyTo(direction);
        }
        return i;
    }

    public int sendEnergyTo(EnumFacing side) {
        if (this.getEnergyStored() == 0) {
            return 0;
        }
        TileEntity tile = this.field_145850_b.func_175625_s(this.field_174879_c.func_177972_a(side));
        if (tile != null && EnergyHelper.canReceiveEnergy(tile)) {
            return EnergyHelper.insertEnergy(tile, this.getEnergyStored(), side.func_176734_d(), false);
        }
        return 0;
    }

    public static int sendEnergyTo(IBlockAccess world, BlockPos pos, int maxSend, EnumFacing side) {
        TileEntity tile = world.func_175625_s(pos.func_177972_a(side));
        if (tile != null && EnergyHelper.canReceiveEnergy(tile, side.func_176734_d())) {
            return EnergyHelper.insertEnergy(tile, maxSend, side.func_176734_d(), false);
        }
        return 0;
    }

    public static int sendEnergyToAll(IBlockAccess world, BlockPos pos, int maxSend) {
        int i = 0;
        for (EnumFacing direction : EnumFacing.field_82609_l) {
            i += TileEnergyInventoryBase.sendEnergyTo(world, pos, maxSend - i, direction);
        }
        return i;
    }

    public int extractEnergyFromItem(ItemStack stack, int maxExtract, boolean simulate) {
        if (EnergyHelper.isEnergyStack(stack)) {
            return EnergyHelper.extractEnergy(stack, maxExtract, simulate);
        }
        return 0;
    }

    @Override
    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY || super.hasCapability(capability, facing);
    }

    @Override
    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)new EnergyHandlerWrapper(this, facing));
        }
        return super.getCapability(capability, facing);
    }
}

