/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.blocks;

import com.brandon3055.brandonscore.blocks.TileBCBase;
import com.brandon3055.brandonscore.utils.DataUtils;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.nbt.NBTTagList;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentTranslation;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class TileInventoryBase
extends TileBCBase
implements IInventory {
    private NonNullList<ItemStack> inventoryStacks = NonNullList.func_191196_a();
    protected int stackLimit = 64;
    protected IItemHandler itemHandler = new InvWrapper((IInventory)this);
    protected SidedInvWrapper[] sidedHandlers = new SidedInvWrapper[6];

    public TileInventoryBase() {
        if (this instanceof ISidedInventory) {
            for (EnumFacing facing : EnumFacing.values()) {
                this.sidedHandlers[facing.func_176745_a()] = new SidedInvWrapper((ISidedInventory)this, facing);
            }
        }
    }

    protected void setInventorySize(int size) {
        this.inventoryStacks = NonNullList.func_191197_a((int)size, (Object)ItemStack.field_190927_a);
    }

    public int func_70302_i_() {
        return this.inventoryStacks.size();
    }

    public boolean func_191420_l() {
        return DataUtils.count(this.inventoryStacks, stack -> !stack.func_190926_b()) <= 0;
    }

    public ItemStack func_70301_a(int index) {
        return (ItemStack)this.inventoryStacks.get(index);
    }

    public ItemStack func_70298_a(int index, int count) {
        ItemStack stack = index >= 0 && index < this.inventoryStacks.size() && !((ItemStack)this.inventoryStacks.get(index)).func_190926_b() && count > 0 ? ((ItemStack)this.inventoryStacks.get(index)).func_77979_a(count) : ItemStack.field_190927_a;
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public ItemStack func_70304_b(int index) {
        ItemStack stack = index >= 0 && index < this.inventoryStacks.size() ? (ItemStack)this.inventoryStacks.set(index, (Object)ItemStack.field_190927_a) : ItemStack.field_190927_a;
        if (!stack.func_190926_b()) {
            this.func_70296_d();
        }
        return stack;
    }

    public void func_70299_a(int index, ItemStack stack) {
        this.inventoryStacks.set(index, (Object)stack);
        if (stack.func_190916_E() > this.func_70297_j_()) {
            stack.func_190920_e(this.func_70297_j_());
        }
        this.func_70296_d();
    }

    public int func_70297_j_() {
        return this.stackLimit;
    }

    public boolean func_70300_a(EntityPlayer player) {
        if (this.field_145850_b == null) {
            return false;
        }
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return player.func_174818_b(this.field_174879_c.func_177963_a(0.5, 0.5, 0.5)) < 64.0;
    }

    public void func_174889_b(EntityPlayer player) {
    }

    public void func_174886_c(EntityPlayer player) {
    }

    public boolean func_94041_b(int index, ItemStack stack) {
        return true;
    }

    public int func_174887_a_(int id) {
        return 0;
    }

    public void func_174885_b(int id, int value) {
    }

    public int func_174890_g() {
        return 0;
    }

    public void func_174888_l() {
        this.inventoryStacks.clear();
    }

    public String func_70005_c_() {
        return "";
    }

    public boolean func_145818_k_() {
        return false;
    }

    public ITextComponent func_145748_c_() {
        return new TextComponentTranslation(this.func_70005_c_(), new Object[0]);
    }

    protected void writeInventoryToNBT(NBTTagCompound compound) {
        NBTTagList nbttaglist = new NBTTagList();
        for (int i = 0; i < this.inventoryStacks.size(); ++i) {
            ItemStack itemstack = (ItemStack)this.inventoryStacks.get(i);
            if (itemstack.func_190926_b()) continue;
            NBTTagCompound nbttagcompound = new NBTTagCompound();
            if (this.inventoryStacks.size() > 255) {
                nbttagcompound.func_74777_a("Slot", (short)i);
            } else {
                nbttagcompound.func_74774_a("Slot", (byte)i);
            }
            itemstack.func_77955_b(nbttagcompound);
            nbttaglist.func_74742_a((NBTBase)nbttagcompound);
        }
        if (!nbttaglist.func_82582_d()) {
            compound.func_74782_a("Items", (NBTBase)nbttaglist);
        }
    }

    protected void readInventoryFromNBT(NBTTagCompound compound) {
        this.inventoryStacks.clear();
        NBTTagList nbttaglist = compound.func_150295_c("Items", 10);
        for (int i = 0; i < nbttaglist.func_74745_c(); ++i) {
            NBTTagCompound nbttagcompound = nbttaglist.func_150305_b(i);
            int j = this.inventoryStacks.size() > 255 ? nbttagcompound.func_74765_d("Slot") : nbttagcompound.func_74771_c("Slot") & 0xFF;
            if (j < 0 || j >= this.inventoryStacks.size()) continue;
            this.inventoryStacks.set(j, (Object)new ItemStack(nbttagcompound));
        }
    }

    @Override
    public void writeExtraNBT(NBTTagCompound compound) {
        super.writeExtraNBT(compound);
        this.writeInventoryToNBT(compound);
    }

    @Override
    public void readExtraNBT(NBTTagCompound compound) {
        super.readExtraNBT(compound);
        this.readInventoryFromNBT(compound);
    }

    @Override
    public NBTTagCompound writeToItemStack(ItemStack stack, boolean willHarvest) {
        NBTTagCompound dataTag = super.writeToItemStack(stack, willHarvest);
        this.writeInventoryToNBT(dataTag);
        return dataTag;
    }

    @Override
    public NBTTagCompound readFromItemStack(ItemStack stack) {
        NBTTagCompound dataTag = super.readFromItemStack(stack);
        this.readInventoryFromNBT(dataTag);
        return dataTag;
    }

    public boolean hasCapability(Capability<?> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return true;
        }
        return super.hasCapability(capability, facing);
    }

    public <T> T getCapability(Capability<T> capability, EnumFacing facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.getItemHandler(capability, facing);
        }
        return (T)super.getCapability(capability, facing);
    }

    protected <T> T getItemHandler(Capability<T> capability, EnumFacing facing) {
        if (this instanceof ISidedInventory && facing != null) {
            return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.sidedHandlers[facing.func_176745_a()]);
        }
        return (T)CapabilityItemHandler.ITEM_HANDLER_CAPABILITY.cast((Object)this.itemHandler);
    }
}

