/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import net.minecraft.client.Minecraft;

public class MGuiBackground
extends MGuiElementBase {
    public int textureX;
    public int textureY;
    public int textureSizeX = 256;
    public int textureSizeY = 256;
    public String texture;

    public MGuiBackground(IModularGui modularGui, int xPos, int yPos, int textureX, int textureY, int xSize, int ySize, String texture) {
        super(modularGui, xPos, yPos, xSize, ySize);
        this.textureX = textureX;
        this.textureY = textureY;
        this.texture = texture;
    }

    @Override
    public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        super.renderBackgroundLayer(minecraft, mouseX, mouseY, partialTicks);
        ResourceHelperBC.bindTexture(ResourceHelperBC.getResourceRAW(this.texture));
        this.drawModalRectWithCustomSizedTexture(this.xPos, this.yPos, this.textureX, this.textureY, this.xSize, this.ySize, this.textureSizeX, this.textureSizeY);
    }

    public MGuiBackground setTexturePos(int textureX, int textureY) {
        this.textureX = textureX;
        this.textureY = textureY;
        return this;
    }

    public MGuiBackground setTextureSize(int textureSize) {
        return this.setTextureSize(textureSize, textureSize);
    }

    public MGuiBackground setTexture(String texture) {
        this.texture = texture;
        return this;
    }

    public MGuiBackground setTextureSize(int textureSizeX, int textureSizeY) {
        this.textureSizeX = textureSizeX;
        this.textureSizeY = textureSizeY;
        return this;
    }

    public static MGuiBackground newGenericBackground(IModularGui modularGui, int xPos, int yPos, int xSize, int ySize) {
        return new MGuiBackground(modularGui, xPos, yPos, 0, 0, xSize, ySize, ""){

            @Override
            public void renderBackgroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
                ResourceHelperBC.bindTexture(ResourceHelperBC.getResourceRAW("brandonscore:textures/gui/base_gui.png"));
                this.drawTexturedModalRect(this.xPos, this.yPos, 0, 0, this.xSize / 2, this.ySize / 2);
                this.drawTexturedModalRect(this.xPos + this.xSize / 2, this.yPos, 255 - this.xSize / 2, 0, this.xSize / 2, this.ySize / 2);
                this.drawTexturedModalRect(this.xPos, this.yPos + this.ySize / 2, 0, 255 - this.ySize / 2, this.xSize / 2, this.ySize / 2);
                this.drawTexturedModalRect(this.xPos + this.xSize / 2, this.yPos + this.ySize / 2, 255 - this.xSize / 2, 255 - this.ySize / 2, this.xSize / 2, this.ySize / 2);
            }
        };
    }
}

