/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.gui.modulargui.modularelements;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffect;
import com.brandon3055.brandonscore.client.gui.effects.GuiEffectRenderer;
import com.brandon3055.brandonscore.client.gui.modulargui.IModularGui;
import com.brandon3055.brandonscore.client.gui.modulargui.MGuiElementBase;
import net.minecraft.client.Minecraft;

public class MGuiEffectRenderer
extends MGuiElementBase {
    private final GuiEffectRenderer effectRenderer = new GuiEffectRenderer();
    private String particleTexture = null;

    public MGuiEffectRenderer(IModularGui modularGui) {
        super(modularGui);
    }

    public MGuiEffectRenderer setParticleTexture(String particleTexture) {
        this.particleTexture = particleTexture;
        return this;
    }

    @Override
    public void renderForegroundLayer(Minecraft minecraft, int mouseX, int mouseY, float partialTicks) {
        if (this.particleTexture != null) {
            ResourceHelperBC.bindTexture(ResourceHelperBC.getResourceRAW(this.particleTexture));
        }
        this.effectRenderer.renderEffects(partialTicks);
        super.renderForegroundLayer(minecraft, mouseX, mouseY, partialTicks);
    }

    @Override
    public boolean onUpdate() {
        this.effectRenderer.updateEffects();
        return super.onUpdate();
    }

    public MGuiEffectRenderer addEffect(GuiEffect effect) {
        effect.zLevel = this.getRenderZLevel();
        this.effectRenderer.addEffect(effect);
        return this;
    }

    public void clearEffects() {
        this.effectRenderer.clearEffects();
    }
}

