/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.particle;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.client.particle.BCParticle;
import com.brandon3055.brandonscore.client.particle.IGLFXHandler;
import com.brandon3055.brandonscore.lib.PairKV;
import com.google.common.collect.Queues;
import java.util.ArrayDeque;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Queue;
import java.util.concurrent.Callable;
import net.minecraft.client.particle.Particle;
import net.minecraft.client.renderer.ActiveRenderInfo;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.crash.CrashReport;
import net.minecraft.crash.CrashReportCategory;
import net.minecraft.entity.Entity;
import net.minecraft.util.ReportedException;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;

public class BCEffectRenderer {
    public World world;
    private final Map<ResourceLocation, ArrayDeque<Particle>[][]> renderQueue = new HashMap<ResourceLocation, ArrayDeque<Particle>[][]>();
    private final Queue<PairKV<ResourceLocation, Particle>> newParticleQueue = new ArrayDeque<PairKV<ResourceLocation, Particle>>();
    private final Map<IGLFXHandler, ArrayDeque<Particle>[]> glRenderQueue = new HashMap<IGLFXHandler, ArrayDeque<Particle>[]>();
    private final Queue<PairKV<IGLFXHandler, Particle>> newGlParticleQueue = Queues.newArrayDeque();
    public static final IGLFXHandler DEFAULT_IGLFX_HANDLER = new IGLFXHandler(){

        @Override
        public void preDraw(int layer, VertexBuffer vertexbuffer, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
            GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179132_a((boolean)false);
            GlStateManager.func_179092_a((int)516, (float)0.0f);
        }

        @Override
        public void postDraw(int layer, VertexBuffer vertexbuffer, Tessellator tessellator) {
        }
    };

    public BCEffectRenderer(World world) {
        this.world = world;
    }

    public void addRawGLEffect(IGLFXHandler handler, BCParticle particle) {
        if (particle == null) {
            return;
        }
        if (!particle.isRawGLParticle()) {
            throw new RuntimeException("Attempted to spawn a regular particle as a Raw GL particle! This is not allowed!");
        }
        this.newGlParticleQueue.add(new PairKV<IGLFXHandler, BCParticle>(handler, particle));
    }

    public void addEffect(ResourceLocation resourceLocation, Particle particle) {
        if (resourceLocation == null || particle == null) {
            return;
        }
        if (particle instanceof BCParticle && ((BCParticle)particle).isRawGLParticle()) {
            throw new RuntimeException("Attempted to spawn a Raw GL particle using the default spawn call! This is not allowed!");
        }
        this.newParticleQueue.add(new PairKV<ResourceLocation, Particle>(resourceLocation, particle));
    }

    public void updateEffects() {
        for (int i = 0; i < 4; ++i) {
            this.updateEffectLayer(i);
        }
        if (!this.newGlParticleQueue.isEmpty()) {
            PairKV<IGLFXHandler, Particle> handlerParticle = this.newGlParticleQueue.poll();
            while (handlerParticle != null) {
                if (!this.glRenderQueue.containsKey(handlerParticle.getKey())) {
                    this.glRenderQueue.put(handlerParticle.getKey(), new ArrayDeque[]{new ArrayDeque(), new ArrayDeque(), new ArrayDeque(), new ArrayDeque()});
                }
                int layer = handlerParticle.getValue().func_70537_b();
                if (this.glRenderQueue.get(handlerParticle.getKey())[layer].size() > 6000) {
                    this.glRenderQueue.get(handlerParticle.getKey())[layer].removeFirst().func_187112_i();
                }
                this.glRenderQueue.get(handlerParticle.getKey())[layer].add(handlerParticle.getValue());
                handlerParticle = this.newGlParticleQueue.poll();
            }
        }
        if (!this.newParticleQueue.isEmpty()) {
            PairKV<ResourceLocation, Particle> entry = this.newParticleQueue.poll();
            while (entry != null) {
                int mask;
                ArrayDeque[][] array;
                if (!this.renderQueue.containsKey(entry.getKey())) {
                    array = new ArrayDeque[4][];
                    for (int i = 0; i < 4; ++i) {
                        array[i] = new ArrayDeque[2];
                        for (int j = 0; j < 2; ++j) {
                            array[i][j] = new ArrayDeque();
                        }
                    }
                    this.renderQueue.put(entry.getKey(), array);
                }
                array = this.renderQueue.get(entry.getKey());
                Particle Particle2 = entry.getValue();
                int layer = Particle2.func_70537_b();
                int n = mask = Particle2.func_187111_c() ? 0 : 1;
                if (array[layer][mask].size() >= 6000) {
                    ((Particle)array[layer][mask].removeFirst()).func_187112_i();
                }
                array[layer][mask].add(Particle2);
                entry = this.newParticleQueue.poll();
            }
        }
    }

    private void updateEffectLayer(int layer) {
        for (int i = 0; i < 2; ++i) {
            for (ArrayDeque<Particle>[][] queue : this.renderQueue.values()) {
                this.tickAndRemoveDead(queue[layer][i]);
            }
        }
        for (ArrayDeque<Particle>[] array : this.glRenderQueue.values()) {
            this.tickAndRemoveDead(array[layer]);
        }
    }

    private void tickAndRemoveDead(Queue<Particle> queue) {
        if (!queue.isEmpty()) {
            Iterator iterator = queue.iterator();
            while (iterator.hasNext()) {
                Particle particle = (Particle)iterator.next();
                this.tickParticle(particle);
                if (particle.func_187113_k()) continue;
                iterator.remove();
            }
        }
    }

    protected void clearEffects(World worldIn) {
        this.world = worldIn;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (ArrayDeque[][] arrayDequeArray : this.renderQueue.values()) {
                    for (Particle particle : arrayDequeArray[j][k]) {
                        particle.func_187112_i();
                    }
                }
            }
        }
        for (ArrayDeque<Particle>[] array : this.glRenderQueue.values()) {
            for (ArrayDeque<Particle> queue : array) {
                for (Particle particle : queue) {
                    particle.func_187112_i();
                }
            }
        }
    }

    private void tickParticle(final Particle particle) {
        try {
            particle.func_189213_a();
        }
        catch (Throwable throwable) {
            CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Ticking Particle");
            CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being ticked");
            final int i = particle.func_70537_b();
            crashreportcategory.func_71507_a("Particle", (Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return particle.toString();
                }
            });
            crashreportcategory.func_71507_a("Particle Type", (Object)new Callable<String>(){

                @Override
                public String call() throws Exception {
                    return i == 0 ? "MISC_TEXTURE" : (i == 1 ? "TERRAIN_TEXTURE" : (i == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i));
                }
            });
            throw new ReportedException(crashreport);
        }
    }

    public void renderParticles(Entity entityIn, float partialTicks) {
        float rotationX = ActiveRenderInfo.func_178808_b();
        float rotationZ = ActiveRenderInfo.func_178803_d();
        float rotationYZ = ActiveRenderInfo.func_178805_e();
        float rotationXY = ActiveRenderInfo.func_178807_f();
        float rotationXZ = ActiveRenderInfo.func_178809_c();
        Particle.field_70556_an = entityIn.field_70142_S + (entityIn.field_70165_t - entityIn.field_70142_S) * (double)partialTicks;
        Particle.field_70554_ao = entityIn.field_70137_T + (entityIn.field_70163_u - entityIn.field_70137_T) * (double)partialTicks;
        Particle.field_70555_ap = entityIn.field_70136_U + (entityIn.field_70161_v - entityIn.field_70136_U) * (double)partialTicks;
        GlStateManager.func_179147_l();
        GlStateManager.func_187401_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA);
        GlStateManager.func_179092_a((int)516, (float)0.003921569f);
        Tessellator tessellator = Tessellator.func_178181_a();
        for (int layer = 0; layer < 4; ++layer) {
            this.renderGlParticlesInLayer(layer, tessellator, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            this.renderTexturedParticlesInLayer(layer, tessellator, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
        }
        GlStateManager.func_179132_a((boolean)true);
        GlStateManager.func_179084_k();
        GlStateManager.func_179092_a((int)516, (float)0.1f);
    }

    private void renderGlParticlesInLayer(int layer, Tessellator tessellator, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        for (IGLFXHandler handler : this.glRenderQueue.keySet()) {
            handler.preDraw(layer, vertexbuffer, entityIn, partialTicks, rotationX, rotationZ, rotationYZ, rotationXY, rotationXZ);
            for (final Particle particle : this.glRenderQueue.get(handler)[layer]) {
                try {
                    particle.func_180434_a(vertexbuffer, entityIn, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
                }
                catch (Throwable throwable) {
                    CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                    CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                    crashreportcategory.func_71507_a("Particle", (Object)new Callable<String>(){

                        @Override
                        public String call() throws Exception {
                            return particle.toString();
                        }
                    });
                    throw new ReportedException(crashreport);
                }
            }
            handler.postDraw(layer, vertexbuffer, tessellator);
        }
    }

    private void renderTexturedParticlesInLayer(int layer, Tessellator tessellator, Entity entityIn, float partialTicks, float rotationX, float rotationZ, float rotationYZ, float rotationXY, float rotationXZ) {
        for (ResourceLocation resourceLocation : this.renderQueue.keySet()) {
            ResourceHelperBC.bindTexture(resourceLocation);
            ArrayDeque<Particle>[][] texRenderQueue = this.renderQueue.get(resourceLocation);
            for (int j = 0; j < 2; ++j) {
                final int i_f = layer;
                if (texRenderQueue[layer][j].isEmpty()) continue;
                switch (j) {
                    case 0: {
                        GlStateManager.func_179132_a((boolean)false);
                        GlStateManager.func_179092_a((int)516, (float)0.0f);
                        break;
                    }
                    case 1: {
                        GlStateManager.func_179132_a((boolean)true);
                    }
                }
                GlStateManager.func_179131_c((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                VertexBuffer vertexbuffer = tessellator.func_178180_c();
                vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181704_d);
                for (final Particle particle : texRenderQueue[layer][j]) {
                    try {
                        particle.func_180434_a(vertexbuffer, entityIn, partialTicks, rotationX, rotationXZ, rotationZ, rotationYZ, rotationXY);
                    }
                    catch (Throwable throwable) {
                        CrashReport crashreport = CrashReport.func_85055_a((Throwable)throwable, (String)"Rendering Particle");
                        CrashReportCategory crashreportcategory = crashreport.func_85058_a("Particle being rendered");
                        crashreportcategory.func_71507_a("Particle", (Object)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return particle.toString();
                            }
                        });
                        crashreportcategory.func_71507_a("Particle Type", (Object)new Callable<String>(){

                            @Override
                            public String call() throws Exception {
                                return i_f == 0 ? "MISC_TEXTURE" : (i_f == 1 ? "TERRAIN_TEXTURE" : (i_f == 3 ? "ENTITY_PARTICLE_TEXTURE" : "Unknown - " + i_f));
                            }
                        });
                        throw new ReportedException(crashreport);
                    }
                }
                tessellator.func_78381_a();
            }
        }
    }

    public String getStatistics() {
        int i = 0;
        for (int j = 0; j < 4; ++j) {
            for (int k = 0; k < 2; ++k) {
                for (ArrayDeque<Particle>[][] list : this.renderQueue.values()) {
                    i += list[j][k].size();
                }
            }
        }
        int g = 0;
        for (ArrayDeque<Particle>[] array : this.glRenderQueue.values()) {
            for (ArrayDeque<Particle> queue : array) {
                g += queue.size();
            }
        }
        return "" + i + " GLFX: " + g;
    }
}

