/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.client.utils;

import com.brandon3055.brandonscore.client.ResourceHelperBC;
import com.brandon3055.brandonscore.utils.InfoHelper;
import com.brandon3055.brandonscore.utils.Utils;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.Gui;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.OpenGlHelper;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.VertexBuffer;
import net.minecraft.client.renderer.block.model.ItemCameraTransforms;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.item.ItemStack;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.translation.I18n;
import net.minecraftforge.fml.client.config.GuiUtils;

public class GuiHelper {
    public static final double PXL128 = 0.0078125;
    public static final double PXL256 = 0.00390625;

    public static boolean isInRect(int x, int y, int xSize, int ySize, int mouseX, int mouseY) {
        return mouseX >= x && mouseX <= x + xSize && mouseY >= y && mouseY <= y + ySize;
    }

    public static void drawTexturedRect(int x, int y, int u, int v, int width, int height) {
        GuiHelper.drawTexturedRect(x, y, width, height, u, v, width, height, 0.0, 0.00390625);
    }

    public static void drawTexturedRect(double x, double y, double width, double height, int u, int v, int uSize, int vSize, double zLevel, double pxl) {
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexBuffer = tessellator.func_178180_c();
        vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexBuffer.func_181662_b(x, y + height, zLevel).func_187315_a((double)u * pxl, (double)(v + vSize) * pxl).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y + height, zLevel).func_187315_a((double)(u + uSize) * pxl, (double)(v + vSize) * pxl).func_181675_d();
        vertexBuffer.func_181662_b(x + width, y, zLevel).func_187315_a((double)(u + uSize) * pxl, (double)v * pxl).func_181675_d();
        vertexBuffer.func_181662_b(x, y, zLevel).func_187315_a((double)u * pxl, (double)v * pxl).func_181675_d();
        tessellator.func_78381_a();
    }

    public static void drawHoveringText(List list, int x, int y, FontRenderer font, int guiWidth, int guiHeight) {
        GuiUtils.drawHoveringText((List)list, (int)x, (int)y, (int)guiWidth, (int)guiHeight, (int)-1, (FontRenderer)font);
    }

    public static void drawHoveringTextScaled(List list, int mouseX, int mouseY, FontRenderer font, float fade, double scale, int guiWidth, int guiHeight) {
        if (!list.isEmpty()) {
            GlStateManager.func_179094_E();
            GlStateManager.func_179101_C();
            RenderHelper.func_74518_a();
            GlStateManager.func_179140_f();
            GlStateManager.func_179097_i();
            GlStateManager.func_179139_a((double)scale, (double)scale, (double)1.0);
            mouseX = (int)((double)mouseX / scale);
            mouseY = (int)((double)mouseY / scale);
            int tooltipTextWidth = 0;
            for (Object aList : list) {
                String s = (String)aList;
                int l = font.func_78256_a(s);
                if (l <= tooltipTextWidth) continue;
                tooltipTextWidth = l;
            }
            int tooltipX = mouseX + 12;
            int tooltipY = mouseY - 12;
            int tooltipHeight = 6;
            if (list.size() > 1) {
                tooltipHeight += 2 + (list.size() - 1) * 10;
            }
            if (tooltipX + tooltipTextWidth > (int)((double)guiWidth / scale)) {
                tooltipX -= 28 + tooltipTextWidth;
            }
            if (tooltipY + tooltipHeight + 6 > (int)((double)guiHeight / scale)) {
                tooltipY = (int)((double)guiHeight / scale) - tooltipHeight - 6;
            }
            int backgroundColor = -267386864;
            GuiHelper.drawGradientRect(tooltipX - 3, tooltipY - 4, tooltipX + tooltipTextWidth + 3, tooltipY - 3, backgroundColor, backgroundColor, fade, scale);
            GuiHelper.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 4, backgroundColor, backgroundColor, fade, scale);
            GuiHelper.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, fade, scale);
            GuiHelper.drawGradientRect(tooltipX - 4, tooltipY - 3, tooltipX - 3, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, fade, scale);
            GuiHelper.drawGradientRect(tooltipX + tooltipTextWidth + 3, tooltipY - 3, tooltipX + tooltipTextWidth + 4, tooltipY + tooltipHeight + 3, backgroundColor, backgroundColor, fade, scale);
            int k1 = 0x505000FF;
            int l1 = (k1 & 0xFEFEFE) >> 1 | k1 & 0xFF000000;
            GuiHelper.drawGradientRect(tooltipX - 3, tooltipY - 3 + 1, tooltipX - 3 + 1, tooltipY + tooltipHeight + 3 - 1, k1, l1, fade, scale);
            GuiHelper.drawGradientRect(tooltipX + tooltipTextWidth + 2, tooltipY - 3 + 1, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3 - 1, k1, l1, fade, scale);
            GuiHelper.drawGradientRect(tooltipX - 3, tooltipY - 3, tooltipX + tooltipTextWidth + 3, tooltipY - 3 + 1, k1, k1, fade, scale);
            GuiHelper.drawGradientRect(tooltipX - 3, tooltipY + tooltipHeight + 2, tooltipX + tooltipTextWidth + 3, tooltipY + tooltipHeight + 3, l1, l1, fade, scale);
            for (int i2 = 0; i2 < list.size(); ++i2) {
                String s1 = (String)list.get(i2);
                GlStateManager.func_179147_l();
                GlStateManager.func_179118_c();
                OpenGlHelper.func_148821_a((int)770, (int)771, (int)1, (int)0);
                font.func_175063_a(s1, (float)tooltipX, (float)tooltipY, (int)(fade * 240.0f) + 16 << 24 | 0xFFFFFF);
                GlStateManager.func_179141_d();
                tooltipY += 10;
            }
            GlStateManager.func_179145_e();
            GlStateManager.func_179126_j();
            RenderHelper.func_74519_b();
            GlStateManager.func_179091_B();
            GlStateManager.func_179121_F();
        }
    }

    public static void drawGradientRect(int left, int top, int right, int bottom, int colour1, int colour2, float fade, double zLevel) {
        float f = (float)(colour1 >> 24 & 0xFF) / 255.0f * fade;
        float f1 = (float)(colour1 >> 16 & 0xFF) / 255.0f;
        float f2 = (float)(colour1 >> 8 & 0xFF) / 255.0f;
        float f3 = (float)(colour1 & 0xFF) / 255.0f;
        float f4 = (float)(colour2 >> 24 & 0xFF) / 255.0f * fade;
        float f5 = (float)(colour2 >> 16 & 0xFF) / 255.0f;
        float f6 = (float)(colour2 >> 8 & 0xFF) / 255.0f;
        float f7 = (float)(colour2 & 0xFF) / 255.0f;
        GlStateManager.func_179090_x();
        GlStateManager.func_179147_l();
        GlStateManager.func_179118_c();
        GlStateManager.func_187428_a((GlStateManager.SourceFactor)GlStateManager.SourceFactor.SRC_ALPHA, (GlStateManager.DestFactor)GlStateManager.DestFactor.ONE_MINUS_SRC_ALPHA, (GlStateManager.SourceFactor)GlStateManager.SourceFactor.ONE, (GlStateManager.DestFactor)GlStateManager.DestFactor.ZERO);
        GlStateManager.func_179103_j((int)7425);
        Tessellator tessellator = Tessellator.func_178181_a();
        VertexBuffer vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181706_f);
        vertexbuffer.func_181662_b((double)right, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)top, zLevel).func_181666_a(f1, f2, f3, f).func_181675_d();
        vertexbuffer.func_181662_b((double)left, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        vertexbuffer.func_181662_b((double)right, (double)bottom, zLevel).func_181666_a(f5, f6, f7, f4).func_181675_d();
        tessellator.func_78381_a();
        GlStateManager.func_179103_j((int)7424);
        GlStateManager.func_179084_k();
        GlStateManager.func_179141_d();
        GlStateManager.func_179098_w();
    }

    public static void drawEnergyBar(Gui gui, int posX, int posZ, int size, long energy, long maxEnergy) {
        GuiHelper.drawEnergyBar(gui, posX, posZ, size, false, energy, maxEnergy, false, 0, 0);
    }

    public static void drawEnergyBar(Gui gui, int posX, int posY, int size, boolean horizontal, long energy, long maxEnergy, boolean toolTip, int mouseX, int mouseY) {
        ResourceHelperBC.bindTexture("textures/gui/energy_gui.png");
        int draw = (int)((double)energy / (double)maxEnergy * (double)(size - 2));
        boolean inRect = GuiHelper.isInRect(posX, posY, size, 14, mouseX, mouseY);
        if (horizontal) {
            int x = posY;
            posY = posX;
            posX = x;
            GlStateManager.func_179094_E();
            GlStateManager.func_179109_b((float)(size + posY * 2), (float)0.0f, (float)0.0f);
            GlStateManager.func_179114_b((float)90.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        }
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(posX, posY, 0, 0, 14, size);
        gui.func_73729_b(posX, posY + size - 1, 0, 255, 14, 1);
        gui.func_73729_b(posX + 1, posY + size - draw - 1, 14, size - draw, 12, draw);
        if (horizontal) {
            GlStateManager.func_179121_F();
        }
        if (toolTip && inRect) {
            ArrayList<String> list = new ArrayList<String>();
            list.add(InfoHelper.ITC() + I18n.func_74838_a((String)"gui.de.energyStorage.txt"));
            list.add(InfoHelper.HITC() + Utils.formatNumber(energy) + " / " + Utils.formatNumber(maxEnergy));
            list.add(TextFormatting.GRAY + "[" + Utils.addCommas(energy) + " RF]");
            GuiHelper.drawHoveringText(list, mouseX, mouseY, Minecraft.func_71410_x().field_71466_p, Minecraft.func_71410_x().field_71443_c, Minecraft.func_71410_x().field_71440_d);
        }
    }

    public static void drawGuiBaseBackground(Gui gui, int posX, int posY, int xSize, int ySize) {
        ResourceHelperBC.bindTexture("textures/gui/base_gui.png");
        GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
        gui.func_73729_b(posX, posY, 0, 0, xSize - 3, ySize - 3);
        gui.func_73729_b(posX + xSize - 3, posY, 253, 0, 3, ySize - 3);
        gui.func_73729_b(posX, posY + ySize - 3, 0, 253, xSize - 3, 3);
        gui.func_73729_b(posX + xSize - 3, posY + ySize - 3, 253, 253, 3, 3);
    }

    public static void drawPlayerSlots(Gui gui, int posX, int posY, boolean center) {
        ResourceHelperBC.bindTexture("textures/gui/bc_widgets.png");
        if (center) {
            posX -= 81;
        }
        for (int y = 0; y < 3; ++y) {
            for (int x = 0; x < 9; ++x) {
                gui.func_73729_b(posX + x * 18, posY + y * 18, 138, 0, 18, 18);
            }
        }
        for (int x = 0; x < 9; ++x) {
            gui.func_73729_b(posX + x * 18, posY + 58, 138, 0, 18, 18);
        }
    }

    public static void drawCenteredString(FontRenderer fontRenderer, String text, int x, int y, int color, boolean dropShadow) {
        fontRenderer.func_175065_a(text, (float)(x - fontRenderer.func_78256_a(text) / 2), (float)y, color, dropShadow);
    }

    public static void drawCenteredSplitString(FontRenderer fontRenderer, String str, int x, int y, int wrapWidth, int color, boolean dropShadow) {
        for (String s : fontRenderer.func_78271_c(str, wrapWidth)) {
            GuiHelper.drawCenteredString(fontRenderer, s, x, y, color, dropShadow);
            y += fontRenderer.field_78288_b;
        }
    }

    public static void drawStack2D(ItemStack stack, Minecraft mc, int x, int y, float scale) {
        if (stack.func_190926_b()) {
            return;
        }
        RenderHelper.func_74520_c();
        GlStateManager.func_179109_b((float)0.0f, (float)0.0f, (float)32.0f);
        mc.func_175599_af().field_77023_b = 200.0f;
        FontRenderer font = mc.field_71466_p;
        mc.func_175599_af().func_180450_b(stack, x, y);
        String count = stack.func_190916_E() > 1 ? String.valueOf(stack.func_190916_E()) : "";
        mc.func_175599_af().func_180453_a(font, stack, x, y, count);
        mc.func_175599_af().field_77023_b = 0.0f;
    }

    public static void drawStack(ItemStack stack, Minecraft mc, int x, int y, float scale) {
        if (stack.func_190926_b()) {
            return;
        }
        GlStateManager.func_179094_E();
        GlStateManager.func_179109_b((float)x, (float)y, (float)300.0f);
        GlStateManager.func_179152_a((float)scale, (float)scale, (float)scale);
        GlStateManager.func_179114_b((float)180.0f, (float)1.0f, (float)0.0f, (float)0.0f);
        mc.func_175599_af().func_181564_a(stack, ItemCameraTransforms.TransformType.NONE);
        GlStateManager.func_179121_F();
    }

    public static void drawGradientRect(int posX, int posY, int xSize, int ySize, int colour, int colour2) {
        GuiHelper.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour2, 1.0f, 0.0);
    }

    public static void drawColouredRect(int posX, int posY, int xSize, int ySize, int colour) {
        GuiHelper.drawGradientRect(posX, posY, posX + xSize, posY + ySize, colour, colour, 1.0f, 0.0);
    }

    public static void drawBorderedRect(int posX, int posY, int xSize, int ySize, int borderWidth, int fillColour, int borderColour) {
        GuiHelper.drawColouredRect(posX, posY, xSize, borderWidth, borderColour);
        GuiHelper.drawColouredRect(posX, posY + ySize - borderWidth, xSize, borderWidth, borderColour);
        GuiHelper.drawColouredRect(posX, posY + borderWidth, borderWidth, ySize - 2 * borderWidth, borderColour);
        GuiHelper.drawColouredRect(posX + xSize - borderWidth, posY + borderWidth, borderWidth, ySize - 2 * borderWidth, borderColour);
        GuiHelper.drawColouredRect(posX + borderWidth, posY + borderWidth, xSize - 2 * borderWidth, ySize - 2 * borderWidth, fillColour);
    }
}

