/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.command;

import com.brandon3055.brandonscore.handlers.HandHelper;
import com.brandon3055.brandonscore.lib.ChatHelper;
import com.brandon3055.brandonscore.utils.DataUtils;
import com.brandon3055.brandonscore.utils.LogHelperBC;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.command.CommandBase;
import net.minecraft.command.CommandException;
import net.minecraft.command.ICommandSender;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.MinecraftServer;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;

public class BCUtilCommands
extends CommandBase {
    public String func_71517_b() {
        return "bcore_util";
    }

    public String func_71518_a(ICommandSender sender) {
        return "/bcore_util help";
    }

    public int func_82362_a() {
        return 3;
    }

    public void func_184881_a(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        if (args.length == 0) {
            this.help(sender);
            return;
        }
        String function = args[0];
        if (function.toLowerCase().equals("nbt")) {
            this.functionNBT(server, sender, args);
        } else if (!(function.equals("") || function.equals("") || function.equals("") || function.equals("") || function.equals(""))) {
            this.help(sender);
        }
    }

    public List<String> func_184883_a(MinecraftServer server, ICommandSender sender, String[] args, @Nullable BlockPos targetPos) {
        return BCUtilCommands.func_71530_a((String[])args, (String[])new String[]{"nbt"});
    }

    private void help(ICommandSender sender) {
        ChatHelper.message(sender, "The following are a list of Brandon's Core Utility Commands", new Style().func_150238_a(TextFormatting.AQUA).func_150228_d(Boolean.valueOf(true)));
        ChatHelper.message(sender, "/bcore_util nbt", TextFormatting.BLUE);
        ChatHelper.message(sender, "-Prints the NBT tag of the stack you are holding to chat and to the console.", TextFormatting.GRAY);
    }

    private void functionNBT(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
        EntityPlayerMP player = BCUtilCommands.func_71521_c((ICommandSender)sender);
        ItemStack stack = HandHelper.getMainFirst((EntityPlayer)player);
        if (stack.func_190926_b()) {
            throw new CommandException("You are not holding an item!", new Object[0]);
        }
        if (!stack.func_77942_o()) {
            throw new CommandException("That stack has no NBT tag!", new Object[0]);
        }
        NBTTagCompound compound = stack.func_77978_p();
        LogHelperBC.logNBT(compound);
        StringBuilder builder = new StringBuilder();
        LogHelperBC.buildNBT(builder, (NBTBase)compound, "", "Tag", false);
        String[] lines = builder.toString().split("\n");
        DataUtils.forEach(lines, s -> ChatHelper.message(sender, s, TextFormatting.GOLD));
    }

    private void randomFunction1(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction2(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction3(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction4(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }

    private void randomFunction5(MinecraftServer server, ICommandSender sender, String[] args) throws CommandException {
    }
}

