/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import cofh.api.energy.IEnergyContainerItem;
import javax.annotation.Nullable;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.energy.CapabilityEnergy;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyContainerWrapper
implements IEnergyStorage,
ICapabilityProvider {
    private ItemStack stack;

    public EnergyContainerWrapper(ItemStack stack) {
        this.stack = stack;
    }

    private boolean isStackValid() {
        return !this.stack.func_190926_b() && this.stack.func_77973_b() instanceof IEnergyContainerItem;
    }

    private IEnergyContainerItem getContainer() {
        return (IEnergyContainerItem)this.stack.func_77973_b();
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.isStackValid()) {
            return this.getContainer().receiveEnergy(this.stack, maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.isStackValid()) {
            return this.getContainer().extractEnergy(this.stack, maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.isStackValid() ? this.getContainer().getEnergyStored(this.stack) : 0;
    }

    public int getMaxEnergyStored() {
        return this.isStackValid() ? this.getContainer().getMaxEnergyStored(this.stack) : 0;
    }

    public boolean canExtract() {
        return this.isStackValid();
    }

    public boolean canReceive() {
        return this.isStackValid();
    }

    public boolean hasCapability(Capability<?> capability, @Nullable EnumFacing facing) {
        return capability == CapabilityEnergy.ENERGY;
    }

    public <T> T getCapability(Capability<T> capability, @Nullable EnumFacing facing) {
        if (capability == CapabilityEnergy.ENERGY) {
            return (T)CapabilityEnergy.ENERGY.cast((Object)this);
        }
        return null;
    }
}

