/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib;

import cofh.api.energy.IEnergyHandler;
import cofh.api.energy.IEnergyProvider;
import cofh.api.energy.IEnergyReceiver;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.EnumFacing;
import net.minecraftforge.energy.IEnergyStorage;

public class EnergyHandlerWrapper
implements IEnergyStorage {
    private TileEntity tile;
    private EnumFacing side;

    public EnergyHandlerWrapper(TileEntity tile, EnumFacing side) {
        this.tile = tile;
        this.side = side;
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        if (this.tile instanceof IEnergyReceiver) {
            return ((IEnergyReceiver)this.tile).receiveEnergy(this.side, maxReceive, simulate);
        }
        return 0;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        if (this.tile instanceof IEnergyProvider) {
            return ((IEnergyProvider)this.tile).extractEnergy(this.side, maxExtract, simulate);
        }
        return 0;
    }

    public int getEnergyStored() {
        return this.tile instanceof IEnergyHandler ? ((IEnergyHandler)this.tile).getEnergyStored(this.side) : 0;
    }

    public int getMaxEnergyStored() {
        return this.tile instanceof IEnergyHandler ? ((IEnergyHandler)this.tile).getMaxEnergyStored(this.side) : 0;
    }

    public boolean canExtract() {
        return this.tile instanceof IEnergyProvider && ((IEnergyProvider)this.tile).canConnectEnergy(this.side);
    }

    public boolean canReceive() {
        return this.tile instanceof IEnergyReceiver && ((IEnergyReceiver)this.tile).canConnectEnergy(this.side);
    }
}

