/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.brandonscore.lib.datamanager;

import codechicken.lib.data.MCDataInput;
import codechicken.lib.data.MCDataOutput;
import codechicken.lib.packet.PacketCustom;
import com.brandon3055.brandonscore.lib.datamanager.IDataManager;
import com.brandon3055.brandonscore.lib.datamanager.IManagedData;
import com.brandon3055.brandonscore.lib.datamanager.TileDataOptions;
import com.brandon3055.brandonscore.utils.DataUtils;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import net.minecraft.block.state.IBlockState;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.inventory.IContainerListener;
import net.minecraft.nbt.NBTBase;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.tileentity.TileEntity;

public class TileDataManager<T extends TileEntity>
implements IDataManager {
    protected LinkedList<IManagedData> managedDataList = new LinkedList();
    protected Map<IManagedData, TileDataOptions> dataOptions = new HashMap<IManagedData, TileDataOptions>();
    public final T tile;

    public TileDataManager(T tile) {
        this.tile = tile;
    }

    public <M extends IManagedData> TileDataOptions<M> register(String name, M managedData) {
        managedData.setName(name);
        managedData.setIndex(this.managedDataList.size());
        this.managedDataList.add(managedData);
        TileDataOptions<M> ops = new TileDataOptions<M>(managedData);
        this.dataOptions.put(managedData, ops);
        return ops;
    }

    @Override
    public void detectAndSendChanges() {
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        for (IManagedData data : this.managedDataList) {
            if (!this.dataOptions.get((Object)data).syncViaTile || !data.detectChanges()) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
        }
    }

    public void detectAndSendChangesToListeners(List<IContainerListener> listeners) {
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        for (IManagedData data : this.managedDataList) {
            if (!this.dataOptions.get((Object)data).syncViaContainer || !data.detectChanges()) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
            DataUtils.forEachMatch(listeners, p -> p instanceof EntityPlayerMP, p -> syncPacket.sendToPlayer((EntityPlayer)((EntityPlayerMP)p)));
        }
    }

    public void forceContainerSync(List<IContainerListener> listeners) {
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        for (IManagedData data : this.managedDataList) {
            if (!this.dataOptions.get((Object)data).syncViaContainer) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            DataUtils.forEachMatch(listeners, p -> p instanceof EntityPlayerMP, p -> syncPacket.sendToPlayer((EntityPlayer)((EntityPlayerMP)p)));
        }
    }

    public void forceSync() {
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        for (IManagedData data : this.managedDataList) {
            if (!this.dataOptions.get((Object)data).syncViaTile) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToChunk(this.tile);
        }
    }

    public void forcePlayerSync(EntityPlayerMP player) {
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        for (IManagedData data : this.managedDataList) {
            if (!this.dataOptions.get((Object)data).syncViaContainer) continue;
            PacketCustom syncPacket = this.createSyncPacket();
            syncPacket.writeByte((int)((byte)data.getIndex()));
            data.toBytes((MCDataOutput)syncPacket);
            syncPacket.sendToPlayer((EntityPlayer)player);
        }
    }

    public void forceSync(IManagedData data) {
        if (this.tile.func_145831_w().field_72995_K) {
            return;
        }
        PacketCustom syncPacket = this.createSyncPacket();
        syncPacket.writeByte((int)((byte)data.getIndex()));
        data.toBytes((MCDataOutput)syncPacket);
        syncPacket.sendToChunk(this.tile);
    }

    @Override
    public PacketCustom createSyncPacket() {
        PacketCustom packet = new PacketCustom((Object)"BCPCChannel", 1);
        packet.writePos(this.tile.func_174877_v());
        return packet;
    }

    @Override
    public void receiveSyncData(MCDataInput input) {
        int index = input.readByte() & 0xFF;
        IManagedData data = this.getDataByIndex(index);
        if (data != null) {
            data.fromBytes(input);
            if (this.dataOptions.get((Object)data).triggerUpdate) {
                IBlockState state = this.tile.func_145831_w().func_180495_p(this.tile.func_174877_v());
                this.tile.func_145831_w().func_184138_a(this.tile.func_174877_v(), state, state, 3);
            }
        }
    }

    @Override
    public IManagedData getDataByName(String name) {
        return DataUtils.firstMatch(this.managedDataList, data -> data.getName().equals(name));
    }

    @Override
    public IManagedData getDataByIndex(int index) {
        return DataUtils.firstMatch(this.managedDataList, data -> data.getIndex() == index);
    }

    @Override
    public void writeToNBT(NBTTagCompound compound) {
        NBTTagCompound dataTag = new NBTTagCompound();
        DataUtils.forEachMatch(this.managedDataList, p -> this.dataOptions.get((Object)p).saveToNBT, p -> p.toNBT(dataTag));
        compound.func_74782_a("BCManagedData", (NBTBase)dataTag);
    }

    @Override
    public void readFromNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("BCManagedData", 10)) {
            NBTTagCompound dataTag = compound.func_74775_l("BCManagedData");
            DataUtils.forEachMatch(this.managedDataList, p -> this.dataOptions.get((Object)p).saveToNBT, p -> p.fromNBT(dataTag));
        }
    }

    public void writeSyncNBT(NBTTagCompound compound) {
        NBTTagCompound dataTag = new NBTTagCompound();
        DataUtils.forEachMatch(this.managedDataList, p -> this.dataOptions.get((Object)p).syncViaTile, p -> p.toNBT(dataTag));
        compound.func_74782_a("BCManagedData", (NBTBase)dataTag);
    }

    public void readSyncNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("BCManagedData", 10)) {
            NBTTagCompound dataTag = compound.func_74775_l("BCManagedData");
            DataUtils.forEachMatch(this.managedDataList, p -> this.dataOptions.get((Object)p).syncViaTile, p -> p.fromNBT(dataTag));
        }
    }

    public void writeToStackNBT(NBTTagCompound compound) {
        NBTTagCompound dataTag = new NBTTagCompound();
        DataUtils.forEachMatch(this.managedDataList, p -> this.dataOptions.get((Object)p).saveToItem, p -> p.toNBT(dataTag));
        compound.func_74782_a("BCManagedData", (NBTBase)dataTag);
    }

    public void readFromStackNBT(NBTTagCompound compound) {
        if (compound.func_150297_b("BCManagedData", 10)) {
            NBTTagCompound dataTag = compound.func_74775_l("BCManagedData");
            DataUtils.forEachMatch(this.managedDataList, p -> this.dataOptions.get((Object)p).saveToItem, p -> p.fromNBT(dataTag));
        }
    }
}

