/*
 * Decompiled with CFR 0.152.
 */
package com.brandon3055.draconicevolution.common.utills;

import com.brandon3055.draconicevolution.common.ModBlocks;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TileDislocatorReceptacle;
import com.brandon3055.draconicevolution.common.tileentities.multiblocktiles.TilePortalBlock;
import net.minecraft.block.Block;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraftforge.common.util.ForgeDirection;

public class PortalHelper {
    static int iterationNow = 0;

    public static boolean isFrame(Block block) {
        return block == ModBlocks.infusedObsidian;
    }

    public static boolean isReceptacle(Block block) {
        return block == ModBlocks.dislocatorReceptacle;
    }

    public static boolean isPortal(Block block) {
        return block == ModBlocks.portal;
    }

    public static PortalStructure getValidStructure(World world, int x, int y, int z) {
        if (world.field_72995_K) {
            return null;
        }
        for (ForgeDirection direction : ForgeDirection.VALID_DIRECTIONS) {
            for (ForgeDirection plane : ForgeDirection.VALID_DIRECTIONS) {
                PortalStructure structure;
                if (plane == direction || plane == direction.getOpposite() || (structure = PortalHelper.traceFrame(world, x, y, z, direction, plane)) == null || !structure.scanPortal(world, x, y, z, false, false)) continue;
                return structure;
            }
        }
        return null;
    }

    public static PortalStructure traceFrame(World world, int x, int y, int z, ForgeDirection startDir, ForgeDirection plane) {
        Block block;
        int i;
        int MAX_SIZE = 150;
        int startX = x + startDir.offsetX;
        int startY = y + startDir.offsetY;
        int startZ = z + startDir.offsetZ;
        if (!world.func_147437_c(startX, startY, startZ)) {
            return null;
        }
        int xSize = 0;
        int ySize = 0;
        int yOffset = 0;
        for (i = 0; i <= MAX_SIZE; ++i) {
            block = world.func_147439_a(startX + i * startDir.offsetX, startY + i * startDir.offsetY, startZ + i * startDir.offsetZ);
            if (PortalHelper.isFrame(block)) {
                xSize = i;
                break;
            }
            if (world.func_147437_c(startX + i * startDir.offsetX, startY + i * startDir.offsetY, startZ + i * startDir.offsetZ)) continue;
            return null;
        }
        for (i = 0; i <= MAX_SIZE; ++i) {
            block = world.func_147439_a(startX + i * plane.offsetX, startY + i * plane.offsetY, startZ + i * plane.offsetZ);
            if (PortalHelper.isFrame(block)) {
                ySize = i;
                break;
            }
            if (world.func_147437_c(startX + i * plane.offsetX, startY + i * plane.offsetY, startZ + i * plane.offsetZ)) continue;
            return null;
        }
        for (i = 0; i <= MAX_SIZE; ++i) {
            block = world.func_147439_a(startX - i * plane.offsetX, startY - i * plane.offsetY, startZ - i * plane.offsetZ);
            if (PortalHelper.isFrame(block)) {
                ySize += i - 1;
                yOffset = i;
                break;
            }
            if (world.func_147437_c(startX - i * plane.offsetX, startY - i * plane.offsetY, startZ - i * plane.offsetZ)) continue;
            return null;
        }
        if (xSize == 0 || ySize == 0 || ySize > MAX_SIZE) {
            return null;
        }
        PortalStructure structure = new PortalStructure(xSize, ySize, yOffset, startDir, plane);
        if (!structure.checkFrameIsValid(world, x, y, z) || !structure.scanPortal(world, x, y, z, false, false)) {
            return null;
        }
        return structure;
    }

    public static class PortalStructure {
        public int xSize;
        public int ySize;
        public int yOffset;
        public ForgeDirection startDir;
        public ForgeDirection plane;

        public PortalStructure() {
        }

        public PortalStructure(int xSize, int ySize, int yOffset, ForgeDirection startDir, ForgeDirection plane) {
            this.xSize = xSize;
            this.ySize = ySize;
            this.yOffset = yOffset;
            this.startDir = startDir;
            this.plane = plane;
        }

        public boolean checkFrameIsValid(World world, int x, int y, int z) {
            int startX = x + this.startDir.offsetX;
            int startY = y + this.startDir.offsetY;
            int startZ = z + this.startDir.offsetZ;
            for (int y1 = 1; y1 <= this.ySize; ++y1) {
                int y2 = y1 - this.yOffset;
                int inX = startX + y2 * this.plane.offsetX - this.startDir.offsetX;
                int inY = startY + y2 * this.plane.offsetY - this.startDir.offsetY;
                int inZ = startZ + y2 * this.plane.offsetZ - this.startDir.offsetZ;
                int outX = startX + y2 * this.plane.offsetX + this.xSize * this.startDir.offsetX;
                int outY = startY + y2 * this.plane.offsetY + this.xSize * this.startDir.offsetY;
                int outZ = startZ + y2 * this.plane.offsetZ + this.xSize * this.startDir.offsetZ;
                if (!(PortalHelper.isFrame(world.func_147439_a(inX, inY, inZ)) || inX == x && inY == y && inZ == z)) {
                    return false;
                }
                if (PortalHelper.isFrame(world.func_147439_a(outX, outY, outZ))) continue;
                return false;
            }
            for (int x1 = 0; x1 < this.xSize; ++x1) {
                int upX = startX + x1 * this.startDir.offsetX - this.yOffset * this.plane.offsetX;
                int upY = startY + x1 * this.startDir.offsetY - this.yOffset * this.plane.offsetY;
                int upZ = startZ + x1 * this.startDir.offsetZ - this.yOffset * this.plane.offsetZ;
                int downX = startX + x1 * this.startDir.offsetX + (this.ySize - this.yOffset + 1) * this.plane.offsetX;
                int downY = startY + x1 * this.startDir.offsetY + (this.ySize - this.yOffset + 1) * this.plane.offsetY;
                int downZ = startZ + x1 * this.startDir.offsetZ + (this.ySize - this.yOffset + 1) * this.plane.offsetZ;
                if (!PortalHelper.isFrame(world.func_147439_a(upX, upY, upZ))) {
                    return false;
                }
                if (PortalHelper.isFrame(world.func_147439_a(downX, downY, downZ))) continue;
                return false;
            }
            return true;
        }

        public boolean scanPortal(World world, int x, int y, int z, boolean setPortalBlocks, boolean checkPortalBlocks) {
            int startX = x + this.startDir.offsetX;
            int startY = y + this.startDir.offsetY;
            int startZ = z + this.startDir.offsetZ;
            TileDislocatorReceptacle receptacle = (TileDislocatorReceptacle)world.func_147438_o(x, y, z);
            if (receptacle == null) {
                return false;
            }
            if (setPortalBlocks) {
                receptacle.updating = true;
            }
            for (int x1 = 0; x1 < this.xSize; ++x1) {
                for (int y1 = 1; y1 <= this.ySize; ++y1) {
                    int y2 = y1 - this.yOffset;
                    int X = startX + x1 * this.startDir.offsetX + y2 * this.plane.offsetX;
                    int Y = startY + x1 * this.startDir.offsetY + y2 * this.plane.offsetY;
                    int Z = startZ + x1 * this.startDir.offsetZ + y2 * this.plane.offsetZ;
                    Block block = world.func_147439_a(X, Y, Z);
                    if (checkPortalBlocks) {
                        if (PortalHelper.isPortal(block)) continue;
                        return false;
                    }
                    if (setPortalBlocks) {
                        world.func_147449_b(X, Y, Z, (Block)ModBlocks.portal);
                        Chunk chunk = world.func_72938_d(X, Z);
                        TilePortalBlock tile = (TilePortalBlock)chunk.func_150806_e(X & 0xF, Y, Z & 0xF);
                        tile.masterX = x;
                        tile.masterY = y;
                        tile.masterZ = z;
                        continue;
                    }
                    if (world.func_147437_c(X, Y, Z)) continue;
                    return false;
                }
            }
            if (setPortalBlocks) {
                receptacle.updating = false;
            }
            return true;
        }

        public void writeToNBT(NBTTagCompound compound) {
            compound.func_74768_a("XSize", this.xSize);
            compound.func_74768_a("YSize", this.ySize);
            compound.func_74768_a("YOffset", this.yOffset);
            compound.func_74778_a("StartDir", this.startDir.name());
            compound.func_74778_a("Plane", this.plane.name());
        }

        public void readFromNBT(NBTTagCompound compound) {
            this.xSize = compound.func_74762_e("XSize");
            this.ySize = compound.func_74762_e("YSize");
            this.yOffset = compound.func_74762_e("YOffset");
            this.startDir = ForgeDirection.valueOf((String)compound.func_74779_i("StartDir"));
            this.plane = ForgeDirection.valueOf((String)compound.func_74779_i("Plane"));
        }
    }
}

