/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.api.casters;

import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.translation.I18n;

public class NodeSetting {
    int value;
    public String key;
    String description;
    INodeSettingType type;

    public NodeSetting(String key, String description, INodeSettingType setting) {
        this.key = key;
        this.type = setting;
        this.value = setting.getDefault();
        this.description = description;
    }

    public int getValue() {
        return this.type.getValue(this.value);
    }

    public void setValue(int truevalue) {
        int lv = -1;
        this.value = 0;
        while (this.getValue() != truevalue && lv != this.value) {
            lv = this.value;
            this.increment();
        }
    }

    public String getValueText() {
        return I18n.func_74838_a((String)this.type.getValueText(this.value));
    }

    public void increment() {
        ++this.value;
        this.value = this.getType().clamp(this.value);
    }

    public void decrement() {
        --this.value;
        this.value = this.getType().clamp(this.value);
    }

    public INodeSettingType getType() {
        return this.type;
    }

    public String getLocalizedName() {
        return I18n.func_74838_a((String)this.description);
    }

    public static class NodeSettingIntRange
    implements INodeSettingType {
        int min;
        int max;

        public NodeSettingIntRange(int min, int max) {
            this.min = min;
            this.max = max;
        }

        @Override
        public int getDefault() {
            return this.min;
        }

        @Override
        public int clamp(int old) {
            return MathHelper.func_76125_a((int)old, (int)this.min, (int)this.max);
        }

        @Override
        public int getValue(int value) {
            return this.clamp(value);
        }

        @Override
        public String getValueText(int value) {
            return "" + this.getValue(value);
        }
    }

    public static class NodeSettingIntList
    implements INodeSettingType {
        int[] values;
        String[] descriptions;

        public NodeSettingIntList(int[] values, String[] descriptions) {
            this.values = values;
            this.descriptions = descriptions;
        }

        @Override
        public int getDefault() {
            return 0;
        }

        @Override
        public int clamp(int old) {
            return MathHelper.func_76125_a((int)old, (int)0, (int)(this.values.length - 1));
        }

        @Override
        public int getValue(int value) {
            return this.values[this.clamp(value)];
        }

        @Override
        public String getValueText(int value) {
            return this.descriptions[value];
        }
    }

    public static interface INodeSettingType {
        public int getDefault();

        public int clamp(int var1);

        public int getValue(int var1);

        public String getValueText(int var1);
    }
}

