/*
 * Decompiled with CFR 0.152.
 */
package thaumcraft.common.entities.construct.golem.seals;

import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.entity.Entity;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.World;
import thaumcraft.api.golems.EnumGolemTrait;
import thaumcraft.api.golems.GolemHelper;
import thaumcraft.api.golems.IGolemAPI;
import thaumcraft.api.golems.seals.ISealConfigArea;
import thaumcraft.api.golems.seals.ISealConfigToggles;
import thaumcraft.api.golems.seals.ISealEntity;
import thaumcraft.api.golems.tasks.Task;
import thaumcraft.common.entities.construct.golem.seals.SealFiltered;
import thaumcraft.common.entities.construct.golem.tasks.TaskHandler;
import thaumcraft.common.lib.utils.InventoryUtils;

public class SealPickup
extends SealFiltered
implements ISealConfigArea {
    int delay = new Random(System.nanoTime()).nextInt(100);
    static HashMap<Integer, HashMap<Integer, Integer>> itemEntities = new HashMap();
    ResourceLocation icon = new ResourceLocation("thaumcraft", "items/seals/seal_pickup");
    protected ISealConfigToggles.SealToggle[] props = new ISealConfigToggles.SealToggle[]{new ISealConfigToggles.SealToggle(true, "pmeta", "golem.prop.meta"), new ISealConfigToggles.SealToggle(true, "pnbt", "golem.prop.nbt"), new ISealConfigToggles.SealToggle(false, "pore", "golem.prop.ore"), new ISealConfigToggles.SealToggle(false, "pmod", "golem.prop.mod")};

    @Override
    public String getKey() {
        return "thaumcraft:pickup";
    }

    @Override
    public void tickSeal(World world, ISealEntity seal) {
        AxisAlignedBB area;
        List list;
        if (this.delay++ % 20 != 0) {
            return;
        }
        if (!itemEntities.containsKey(world.field_73011_w.getDimension())) {
            itemEntities.put(world.field_73011_w.getDimension(), new HashMap());
        }
        if ((list = world.func_72872_a(EntityItem.class, area = GolemHelper.getBoundsForArea(seal))).size() > 0) {
            for (Object e : list) {
                ItemStack stack;
                EntityItem ent = (EntityItem)e;
                if (ent == null || !ent.field_70122_E || ent.func_174874_s() || ent.func_92059_d() == null || itemEntities.get(world.field_73011_w.getDimension()).containsValue(ent.func_145782_y()) || (stack = InventoryUtils.findFirstMatchFromFilter(this.filter, this.isBlacklist(), new ItemStack[]{ent.func_92059_d()}, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value)) == null) continue;
                Task task = new Task(seal.getSealPos(), (Entity)ent);
                task.setPriority(seal.getPriority());
                itemEntities.get(world.field_73011_w.getDimension()).put(task.getId(), ent.func_145782_y());
                TaskHandler.addTask(world.field_73011_w.getDimension(), task);
                break;
            }
        }
        if (this.delay % 100 != 0) {
            HashMap<Integer, Integer> hm = itemEntities.get(world.field_73011_w.getDimension());
            Iterator<Integer> it = hm.values().iterator();
            while (it.hasNext()) {
                Entity e = world.func_73045_a(it.next().intValue());
                if (e != null && !e.field_70128_L) continue;
                try {
                    it.remove();
                }
                catch (Exception exception) {}
            }
        }
    }

    @Override
    public boolean onTaskCompletion(World world, IGolemAPI golem, Task task) {
        ItemStack stack;
        EntityItem ei;
        if (!itemEntities.containsKey(world.field_73011_w.getDimension())) {
            itemEntities.put(world.field_73011_w.getDimension(), new HashMap());
        }
        if ((ei = this.getItemEntity(world, task)) != null && ei.func_92059_d() != null && (stack = InventoryUtils.findFirstMatchFromFilter(this.filter, this.isBlacklist(), new ItemStack[]{ei.func_92059_d()}, !this.props[0].value, !this.props[1].value, this.props[2].value, this.props[3].value)) != null) {
            ItemStack is = golem.holdItem(ei.func_92059_d());
            if (is != null && is.field_77994_a > 0) {
                ei.func_92058_a(is);
            }
            if (is == null || is.field_77994_a <= 0) {
                ei.func_70106_y();
            }
            ((Entity)golem).func_184185_a(SoundEvents.field_187638_cR, 0.125f, ((world.field_73012_v.nextFloat() - world.field_73012_v.nextFloat()) * 0.7f + 1.0f) * 2.0f);
            golem.swingArm();
        }
        task.setSuspended(true);
        itemEntities.get(world.field_73011_w.getDimension()).remove(task.getId());
        return true;
    }

    protected EntityItem getItemEntity(World world, Task task) {
        Entity ent;
        Integer ei = itemEntities.get(world.field_73011_w.getDimension()).get(task.getId());
        if (ei != null && (ent = world.func_73045_a(ei.intValue())) != null && ent instanceof EntityItem) {
            return (EntityItem)ent;
        }
        return null;
    }

    @Override
    public boolean canGolemPerformTask(IGolemAPI golem, Task task) {
        EntityItem ei = this.getItemEntity(golem.getGolemWorld(), task);
        if (ei != null && ei.func_92059_d() != null) {
            if (ei.field_70128_L) {
                task.setSuspended(true);
                return false;
            }
            return golem.canCarry(ei.func_92059_d(), true);
        }
        return false;
    }

    @Override
    public boolean canPlaceAt(World world, BlockPos pos, EnumFacing side) {
        return !world.func_175623_d(pos);
    }

    @Override
    public ResourceLocation getSealIcon() {
        return this.icon;
    }

    @Override
    public int[] getGuiCategories() {
        return new int[]{2, 1, 0, 4};
    }

    @Override
    public EnumGolemTrait[] getRequiredTags() {
        return null;
    }

    @Override
    public EnumGolemTrait[] getForbiddenTags() {
        return new EnumGolemTrait[]{EnumGolemTrait.CLUMSY};
    }

    @Override
    public void onTaskStarted(World world, IGolemAPI golem, Task task) {
    }

    @Override
    public void onTaskSuspension(World world, Task task) {
    }

    @Override
    public void onRemoval(World world, BlockPos pos, EnumFacing side) {
    }
}

